/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.Recycler;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.function.Executable;

public class RecyclerTest {
    private static Recycler<HandledObject> newRecycler(int maxCapacityPerThread) {
        return RecyclerTest.newRecycler(maxCapacityPerThread, 8, maxCapacityPerThread >> 1);
    }

    private static Recycler<HandledObject> newRecycler(int maxCapacityPerThread, int maxSharedCapacityFactor, int ratio, int maxDelayedQueuesPerThread, int delayedQueueRatio, int chunkSize) {
        return RecyclerTest.newRecycler(maxCapacityPerThread, ratio, chunkSize);
    }

    private static Recycler<HandledObject> newRecycler(int maxCapacityPerThread, int ratio, int chunkSize) {
        return new Recycler<HandledObject>(maxCapacityPerThread, ratio, chunkSize){

            protected HandledObject newObject(Recycler.Handle<HandledObject> handle) {
                return new HandledObject(handle);
            }
        };
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testThreadCanBeCollectedEvenIfHandledObjectIsReferenced() throws Exception {
        final Recycler<HandledObject> recycler = RecyclerTest.newRecycler(1024);
        final AtomicBoolean collected = new AtomicBoolean();
        final AtomicReference<Object> reference = new AtomicReference<Object>();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                HandledObject object = (HandledObject)recycler.get();
                reference.set(object);
            }
        }){

            protected void finalize() throws Throwable {
                super.finalize();
                collected.set(true);
            }
        };
        org.junit.jupiter.api.Assertions.assertFalse((boolean)collected.get());
        thread.start();
        thread.join();
        thread = null;
        while (!collected.get()) {
            System.gc();
            System.runFinalization();
            Thread.sleep(50L);
        }
        ((HandledObject)reference.getAndSet(null)).recycle();
    }

    @Test
    public void verySmallRecycer() {
        RecyclerTest.newRecycler(2, 0, 1).get();
    }

    @Test
    public void testMultipleRecycle() {
        Recycler<HandledObject> recycler = RecyclerTest.newRecycler(1024);
        final HandledObject object = (HandledObject)recycler.get();
        object.recycle();
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, (Executable)new Executable(){

            public void execute() {
                object.recycle();
            }
        });
    }

    @Test
    public void testMultipleRecycleAtDifferentThread() throws InterruptedException {
        Recycler<HandledObject> recycler = RecyclerTest.newRecycler(1024);
        final HandledObject object = (HandledObject)recycler.get();
        final AtomicReference exceptionStore = new AtomicReference();
        Thread thread1 = new Thread(new Runnable(){

            @Override
            public void run() {
                object.recycle();
            }
        });
        thread1.start();
        thread1.join();
        Thread thread2 = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    object.recycle();
                }
                catch (IllegalStateException e) {
                    exceptionStore.set(e);
                }
            }
        });
        thread2.start();
        thread2.join();
        HandledObject a = (HandledObject)recycler.get();
        HandledObject b = (HandledObject)recycler.get();
        org.junit.jupiter.api.Assertions.assertNotSame((Object)a, (Object)b);
        IllegalStateException exception = (IllegalStateException)exceptionStore.get();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleRecycleAtDifferentThreadRacing() throws InterruptedException {
        Recycler<HandledObject> recycler = RecyclerTest.newRecycler(1024);
        final HandledObject object = (HandledObject)recycler.get();
        final AtomicReference exceptionStore = new AtomicReference();
        final CountDownLatch countDownLatch = new CountDownLatch(2);
        Thread thread1 = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    object.recycle();
                }
                catch (IllegalStateException e) {
                    Exception x = exceptionStore.getAndSet(e);
                    if (x != null) {
                        e.addSuppressed(x);
                    }
                }
                finally {
                    countDownLatch.countDown();
                }
            }
        });
        thread1.start();
        Thread thread2 = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    object.recycle();
                }
                catch (IllegalStateException e) {
                    Exception x = exceptionStore.getAndSet(e);
                    if (x != null) {
                        e.addSuppressed(x);
                    }
                }
                finally {
                    countDownLatch.countDown();
                }
            }
        });
        thread2.start();
        try {
            countDownLatch.await();
            HandledObject a = (HandledObject)recycler.get();
            HandledObject b = (HandledObject)recycler.get();
            org.junit.jupiter.api.Assertions.assertNotSame((Object)a, (Object)b);
            IllegalStateException exception = (IllegalStateException)exceptionStore.get();
            if (exception != null) {
                Assertions.assertThat((Throwable)exception).hasMessageContaining("recycled already");
                org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)exception.getSuppressed().length);
            }
        }
        finally {
            thread1.join(1000L);
            thread2.join(1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleRecycleRacing() throws InterruptedException {
        Thread thread1;
        CountDownLatch countDownLatch;
        AtomicReference<IllegalStateException> exceptionStore;
        Recycler<HandledObject> recycler;
        block5: {
            recycler = RecyclerTest.newRecycler(1024);
            final HandledObject object = (HandledObject)recycler.get();
            exceptionStore = new AtomicReference<IllegalStateException>();
            countDownLatch = new CountDownLatch(1);
            thread1 = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        object.recycle();
                    }
                    catch (IllegalStateException e) {
                        Exception x = exceptionStore.getAndSet(e);
                        if (x != null) {
                            e.addSuppressed(x);
                        }
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                }
            });
            thread1.start();
            try {
                object.recycle();
            }
            catch (IllegalStateException e) {
                Exception x = exceptionStore.getAndSet(e);
                if (x == null) break block5;
                e.addSuppressed(x);
            }
        }
        try {
            countDownLatch.await();
            HandledObject a = (HandledObject)recycler.get();
            HandledObject b = (HandledObject)recycler.get();
            org.junit.jupiter.api.Assertions.assertNotSame((Object)a, (Object)b);
            IllegalStateException exception = (IllegalStateException)exceptionStore.get();
            org.junit.jupiter.api.Assertions.assertNotNull((Object)exception);
        }
        finally {
            thread1.join(1000L);
        }
    }

    @Test
    public void testRecycle() {
        Recycler<HandledObject> recycler = RecyclerTest.newRecycler(1024);
        HandledObject object = (HandledObject)recycler.get();
        object.recycle();
        HandledObject object2 = (HandledObject)recycler.get();
        org.junit.jupiter.api.Assertions.assertSame((Object)object, (Object)object2);
        object2.recycle();
    }

    @Test
    public void testRecycleDisable() {
        Recycler<HandledObject> recycler = RecyclerTest.newRecycler(-1);
        HandledObject object = (HandledObject)recycler.get();
        object.recycle();
        HandledObject object2 = (HandledObject)recycler.get();
        org.junit.jupiter.api.Assertions.assertNotSame((Object)object, (Object)object2);
        object2.recycle();
    }

    @Test
    public void testRecycleDisableDrop() {
        Recycler<HandledObject> recycler = RecyclerTest.newRecycler(1024, 0, 16);
        HandledObject object = (HandledObject)recycler.get();
        object.recycle();
        HandledObject object2 = (HandledObject)recycler.get();
        org.junit.jupiter.api.Assertions.assertSame((Object)object, (Object)object2);
        object2.recycle();
        HandledObject object3 = (HandledObject)recycler.get();
        org.junit.jupiter.api.Assertions.assertSame((Object)object, (Object)object3);
        object3.recycle();
    }

    @Test
    public void testMaxCapacity() {
        RecyclerTest.testMaxCapacity(300);
        Random rand = new Random();
        for (int i = 0; i < 50; ++i) {
            RecyclerTest.testMaxCapacity(rand.nextInt(1000) + 256);
        }
    }

    private static void testMaxCapacity(int maxCapacity) {
        int i;
        Recycler<HandledObject> recycler = RecyclerTest.newRecycler(maxCapacity);
        HandledObject[] objects = new HandledObject[maxCapacity * 3];
        for (i = 0; i < objects.length; ++i) {
            objects[i] = (HandledObject)recycler.get();
        }
        for (i = 0; i < objects.length; ++i) {
            objects[i].recycle();
            objects[i] = null;
        }
        org.junit.jupiter.api.Assertions.assertTrue((maxCapacity >= recycler.threadLocalSize() ? 1 : 0) != 0, (String)("The threadLocalSize (" + recycler.threadLocalSize() + ") must be <= maxCapacity (" + maxCapacity + ") as we not pool all new handles internally"));
    }

    @Test
    public void testRecycleAtDifferentThread() throws Exception {
        Recycler<HandledObject> recycler = RecyclerTest.newRecycler(256, 2, 16);
        final HandledObject o = (HandledObject)recycler.get();
        final HandledObject o2 = (HandledObject)recycler.get();
        Thread thread = new Thread(){

            @Override
            public void run() {
                o.recycle();
                o2.recycle();
            }
        };
        thread.start();
        thread.join();
        org.junit.jupiter.api.Assertions.assertSame((Object)recycler.get(), (Object)o);
        org.junit.jupiter.api.Assertions.assertNotSame((Object)recycler.get(), (Object)o2);
    }

    @Test
    public void testRecycleAtTwoThreadsMulti() throws Exception {
        Recycler<HandledObject> recycler = RecyclerTest.newRecycler(256);
        final HandledObject o = (HandledObject)recycler.get();
        ExecutorService single = Executors.newSingleThreadExecutor();
        final CountDownLatch latch1 = new CountDownLatch(1);
        single.execute(new Runnable(){

            @Override
            public void run() {
                o.recycle();
                latch1.countDown();
            }
        });
        org.junit.jupiter.api.Assertions.assertTrue((boolean)latch1.await(100L, TimeUnit.MILLISECONDS));
        final HandledObject o2 = (HandledObject)recycler.get();
        org.junit.jupiter.api.Assertions.assertSame((Object)o2, (Object)o);
        final CountDownLatch latch2 = new CountDownLatch(1);
        single.execute(new Runnable(){

            @Override
            public void run() {
                o2.recycle();
                latch2.countDown();
            }
        });
        org.junit.jupiter.api.Assertions.assertTrue((boolean)latch2.await(100L, TimeUnit.MILLISECONDS));
        HandledObject o3 = (HandledObject)recycler.get();
        org.junit.jupiter.api.Assertions.assertSame((Object)o3, (Object)o);
        single.shutdown();
    }

    @Test
    public void testMaxCapacityWithRecycleAtDifferentThread() throws Exception {
        int i;
        int maxCapacity = 4;
        Recycler<HandledObject> recycler = RecyclerTest.newRecycler(4, 4, 4);
        final HandledObject[] array = new HandledObject[12];
        for (i = 0; i < array.length; ++i) {
            array[i] = (HandledObject)recycler.get();
        }
        for (i = 0; i < 4; ++i) {
            array[i].recycle();
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                for (int i = 4; i < array.length; ++i) {
                    array[i].recycle();
                }
            }
        };
        thread.start();
        thread.join();
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)recycler.threadLocalSize());
        for (int i2 = 0; i2 < array.length; ++i2) {
            recycler.get();
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)recycler.threadLocalSize());
    }

    @Test
    public void testDiscardingExceedingElementsWithRecycleAtDifferentThread() throws Exception {
        int maxCapacity = 32;
        final AtomicInteger instancesCount = new AtomicInteger(0);
        Recycler<HandledObject> recycler = new Recycler<HandledObject>(32){

            protected HandledObject newObject(Recycler.Handle<HandledObject> handle) {
                instancesCount.incrementAndGet();
                return new HandledObject(handle);
            }
        };
        final HandledObject[] array = new HandledObject[64];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (HandledObject)recycler.get();
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)array.length, (int)instancesCount.get());
        instancesCount.set(0);
        Thread thread = new Thread(){

            @Override
            public void run() {
                for (HandledObject object : array) {
                    object.recycle();
                }
            }
        };
        thread.start();
        thread.join();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)instancesCount.get());
        for (int i = 0; i < array.length; ++i) {
            recycler.get();
        }
        org.junit.jupiter.api.Assertions.assertTrue((array.length - 16 <= instancesCount.get() ? 1 : 0) != 0, (String)("The instances count (" + instancesCount.get() + ") must be <= array.length (" + array.length + ") - maxCapacity (" + 32 + ") / 2 as we not pool all new handles internally"));
    }

    static final class HandledObject {
        Recycler.Handle<HandledObject> handle;

        HandledObject(Recycler.Handle<HandledObject> handle) {
            this.handle = handle;
        }

        void recycle() {
            this.handle.recycle((Object)this);
        }
    }
}

