/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakTracker;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class ResourceLeakDetectorTest {
    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testConcurrentUsage() throws Throwable {
        final AtomicBoolean finished = new AtomicBoolean();
        final AtomicReference<Throwable> error = new AtomicReference<Throwable>();
        Thread[] threads = new Thread[50];
        final CyclicBarrier barrier = new CyclicBarrier(threads.length);
        for (int i = 0; i < threads.length; ++i) {
            Thread t;
            threads[i] = t = new Thread(new Runnable(){
                final Queue<LeakAwareResource> resources = new ArrayDeque<LeakAwareResource>(100);

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        barrier.await();
                        for (int b = 0; b < 1000 && !finished.get(); ++b) {
                            for (int a = 0; a < 100; ++a) {
                                DefaultResource resource = new DefaultResource();
                                ResourceLeakTracker leak = DefaultResource.detector.track(resource);
                                LeakAwareResource leakAwareResource = new LeakAwareResource(resource, (ResourceLeakTracker<Resource>)leak);
                                this.resources.add(leakAwareResource);
                            }
                            if (!this.closeResources(true)) continue;
                            finished.set(true);
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (Throwable e) {
                        error.compareAndSet(null, e);
                    }
                    finally {
                        this.closeResources(false);
                    }
                }

                private boolean closeResources(boolean checkClosed) {
                    boolean closed;
                    do {
                        LeakAwareResource r;
                        if ((r = this.resources.poll()) == null) {
                            return false;
                        }
                        closed = r.close();
                    } while (!checkClosed || closed);
                    error.compareAndSet(null, new AssertionError((Object)"ResourceLeak.close() returned 'false' but expected 'true'"));
                    return true;
                }
            });
            t.start();
        }
        for (Thread t : threads) {
            t.join();
        }
        DefaultResource.detector.assertNoErrors();
        ResourceLeakDetectorTest.assertNoErrors(error);
    }

    private static void assertNoErrors(AtomicReference<Throwable> ref) throws Throwable {
        Throwable error = ref.get();
        if (error != null) {
            throw error;
        }
    }

    private static final class TestResourceLeakDetector<T>
    extends ResourceLeakDetector<T> {
        private final AtomicReference<Throwable> error = new AtomicReference();

        TestResourceLeakDetector(Class<?> resourceType, int samplingInterval, long maxActive) {
            super(resourceType, samplingInterval, maxActive);
        }

        protected void reportTracedLeak(String resourceType, String records) {
            this.reportError(new AssertionError((Object)("Leak reported for '" + resourceType + "':\n" + records)));
        }

        protected void reportUntracedLeak(String resourceType) {
            this.reportError(new AssertionError((Object)("Leak reported for '" + resourceType + '\'')));
        }

        protected void reportInstancesLeak(String resourceType) {
            this.reportError(new AssertionError((Object)("Leak reported for '" + resourceType + '\'')));
        }

        private void reportError(AssertionError cause) {
            this.error.compareAndSet(null, (Throwable)((Object)cause));
        }

        void assertNoErrors() throws Throwable {
            ResourceLeakDetectorTest.assertNoErrors(this.error);
        }
    }

    private static interface Resource {
        public boolean close();
    }

    private static final class DefaultResource
    implements Resource {
        static final TestResourceLeakDetector<Resource> detector = new TestResourceLeakDetector(Resource.class, 1, Integer.MAX_VALUE);

        private DefaultResource() {
        }

        @Override
        public boolean close() {
            return true;
        }
    }

    private static final class LeakAwareResource
    implements Resource {
        private final Resource resource;
        private final ResourceLeakTracker<Resource> leak;

        LeakAwareResource(Resource resource, ResourceLeakTracker<Resource> leak) {
            this.resource = resource;
            this.leak = leak;
        }

        @Override
        public boolean close() {
            return this.leak.close((Object)this.resource);
        }
    }
}

