/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.FastThreadLocalThread;
import io.netty.util.internal.ObjectCleaner;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class FastThreadLocalTest {
    @BeforeEach
    public void setUp() {
        FastThreadLocal.removeAll();
        MatcherAssert.assertThat((Object)FastThreadLocal.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testGetIfExists() {
        FastThreadLocal<Boolean> threadLocal = new FastThreadLocal<Boolean>(){

            protected Boolean initialValue() {
                return Boolean.TRUE;
            }
        };
        Assertions.assertNull((Object)threadLocal.getIfExists());
        Assertions.assertTrue((boolean)((Boolean)threadLocal.get()));
        Assertions.assertTrue((boolean)((Boolean)threadLocal.getIfExists()));
        FastThreadLocal.removeAll();
        Assertions.assertNull((Object)threadLocal.getIfExists());
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testRemoveAll() throws Exception {
        final AtomicBoolean removed = new AtomicBoolean();
        FastThreadLocal<Boolean> var = new FastThreadLocal<Boolean>(){

            protected void onRemoval(Boolean value) {
                removed.set(true);
            }
        };
        MatcherAssert.assertThat((Object)var.get(), (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)FastThreadLocal.size(), (Matcher)CoreMatchers.is((Object)1));
        FastThreadLocal.removeAll();
        MatcherAssert.assertThat((Object)removed.get(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)FastThreadLocal.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testRemoveAllFromFTLThread() throws Throwable {
        final AtomicReference throwable = new AtomicReference();
        FastThreadLocalThread thread = new FastThreadLocalThread(){

            public void run() {
                try {
                    FastThreadLocalTest.this.testRemoveAll();
                }
                catch (Throwable t) {
                    throwable.set(t);
                }
            }
        };
        thread.start();
        thread.join();
        Throwable t = (Throwable)throwable.get();
        if (t != null) {
            throw t;
        }
    }

    @Test
    public void testMultipleSetRemove() throws Exception {
        final FastThreadLocal threadLocal = new FastThreadLocal();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                threadLocal.set((Object)"1");
                threadLocal.remove();
                threadLocal.set((Object)"2");
                threadLocal.remove();
            }
        };
        int sizeWhenStart = ObjectCleaner.getLiveSetCount();
        Thread thread = new Thread(runnable);
        thread.start();
        thread.join();
        Assertions.assertEquals((int)0, (int)(ObjectCleaner.getLiveSetCount() - sizeWhenStart));
        Thread thread2 = new Thread(runnable);
        thread2.start();
        thread2.join();
        Assertions.assertEquals((int)0, (int)(ObjectCleaner.getLiveSetCount() - sizeWhenStart));
    }

    @Test
    public void testMultipleSetRemove_multipleThreadLocal() throws Exception {
        final FastThreadLocal threadLocal = new FastThreadLocal();
        final FastThreadLocal threadLocal2 = new FastThreadLocal();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                threadLocal.set((Object)"1");
                threadLocal.remove();
                threadLocal.set((Object)"2");
                threadLocal.remove();
                threadLocal2.set((Object)"1");
                threadLocal2.remove();
                threadLocal2.set((Object)"2");
                threadLocal2.remove();
            }
        };
        int sizeWhenStart = ObjectCleaner.getLiveSetCount();
        Thread thread = new Thread(runnable);
        thread.start();
        thread.join();
        Assertions.assertEquals((int)0, (int)(ObjectCleaner.getLiveSetCount() - sizeWhenStart));
        Thread thread2 = new Thread(runnable);
        thread2.start();
        thread2.join();
        Assertions.assertEquals((int)0, (int)(ObjectCleaner.getLiveSetCount() - sizeWhenStart));
    }

    @Test
    @Timeout(value=4000L, unit=TimeUnit.MILLISECONDS)
    public void testOnRemoveCalledForFastThreadLocalGet() throws Exception {
        FastThreadLocalTest.testOnRemoveCalled(true, true);
    }

    @Disabled(value="onRemoval(...) not called with non FastThreadLocal")
    @Test
    @Timeout(value=4000L, unit=TimeUnit.MILLISECONDS)
    public void testOnRemoveCalledForNonFastThreadLocalGet() throws Exception {
        FastThreadLocalTest.testOnRemoveCalled(false, true);
    }

    @Test
    @Timeout(value=4000L, unit=TimeUnit.MILLISECONDS)
    public void testOnRemoveCalledForFastThreadLocalSet() throws Exception {
        FastThreadLocalTest.testOnRemoveCalled(true, false);
    }

    @Disabled(value="onRemoval(...) not called with non FastThreadLocal")
    @Test
    @Timeout(value=4000L, unit=TimeUnit.MILLISECONDS)
    public void testOnRemoveCalledForNonFastThreadLocalSet() throws Exception {
        FastThreadLocalTest.testOnRemoveCalled(false, false);
    }

    private static void testOnRemoveCalled(boolean fastThreadLocal, final boolean callGet) throws Exception {
        final TestFastThreadLocal threadLocal = new TestFastThreadLocal();
        final TestFastThreadLocal threadLocal2 = new TestFastThreadLocal();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (callGet) {
                    Assertions.assertEquals((Object)Thread.currentThread().getName(), (Object)threadLocal.get());
                    Assertions.assertEquals((Object)Thread.currentThread().getName(), (Object)threadLocal2.get());
                } else {
                    threadLocal.set(Thread.currentThread().getName());
                    threadLocal2.set(Thread.currentThread().getName());
                }
            }
        };
        Object thread = fastThreadLocal ? new FastThreadLocalThread(runnable) : new Thread(runnable);
        ((Thread)thread).start();
        ((Thread)thread).join();
        String threadName = ((Thread)thread).getName();
        thread = null;
        while (threadLocal.onRemovalCalled.get() == null || threadLocal2.onRemovalCalled.get() == null) {
            System.gc();
            System.runFinalization();
            Thread.sleep(50L);
        }
        Assertions.assertEquals((Object)threadName, (Object)threadLocal.onRemovalCalled.get());
        Assertions.assertEquals((Object)threadName, (Object)threadLocal2.onRemovalCalled.get());
    }

    private static final class TestFastThreadLocal
    extends FastThreadLocal<String> {
        final AtomicReference<String> onRemovalCalled = new AtomicReference();

        private TestFastThreadLocal() {
        }

        protected String initialValue() throws Exception {
            return Thread.currentThread().getName();
        }

        protected void onRemoval(String value) throws Exception {
            this.onRemovalCalled.set(value);
        }
    }
}

