/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.AbstractScheduledEventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class AbstractScheduledEventExecutorTest {
    private static final Runnable TEST_RUNNABLE = new Runnable(){

        @Override
        public void run() {
        }
    };
    private static final Callable<?> TEST_CALLABLE = Executors.callable(TEST_RUNNABLE);

    @Test
    public void testScheduleRunnableZero() {
        TestScheduledEventExecutor executor = new TestScheduledEventExecutor();
        ScheduledFuture future = executor.schedule(TEST_RUNNABLE, 0L, TimeUnit.NANOSECONDS);
        Assertions.assertEquals((long)0L, (long)future.getDelay(TimeUnit.NANOSECONDS));
        Assertions.assertNotNull((Object)executor.pollScheduledTask());
        Assertions.assertNull((Object)executor.pollScheduledTask());
    }

    @Test
    public void testScheduleRunnableNegative() {
        TestScheduledEventExecutor executor = new TestScheduledEventExecutor();
        ScheduledFuture future = executor.schedule(TEST_RUNNABLE, -1L, TimeUnit.NANOSECONDS);
        Assertions.assertEquals((long)0L, (long)future.getDelay(TimeUnit.NANOSECONDS));
        Assertions.assertNotNull((Object)executor.pollScheduledTask());
        Assertions.assertNull((Object)executor.pollScheduledTask());
    }

    @Test
    public void testScheduleCallableZero() {
        TestScheduledEventExecutor executor = new TestScheduledEventExecutor();
        ScheduledFuture future = executor.schedule(TEST_CALLABLE, 0L, TimeUnit.NANOSECONDS);
        Assertions.assertEquals((long)0L, (long)future.getDelay(TimeUnit.NANOSECONDS));
        Assertions.assertNotNull((Object)executor.pollScheduledTask());
        Assertions.assertNull((Object)executor.pollScheduledTask());
    }

    @Test
    public void testScheduleCallableNegative() {
        TestScheduledEventExecutor executor = new TestScheduledEventExecutor();
        ScheduledFuture future = executor.schedule(TEST_CALLABLE, -1L, TimeUnit.NANOSECONDS);
        Assertions.assertEquals((long)0L, (long)future.getDelay(TimeUnit.NANOSECONDS));
        Assertions.assertNotNull((Object)executor.pollScheduledTask());
        Assertions.assertNull((Object)executor.pollScheduledTask());
    }

    @Test
    public void testScheduleAtFixedRateRunnableZero() {
        final TestScheduledEventExecutor executor = new TestScheduledEventExecutor();
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                executor.scheduleAtFixedRate(TEST_RUNNABLE, 0L, 0L, TimeUnit.DAYS);
            }
        });
    }

    @Test
    public void testScheduleAtFixedRateRunnableNegative() {
        final TestScheduledEventExecutor executor = new TestScheduledEventExecutor();
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                executor.scheduleAtFixedRate(TEST_RUNNABLE, 0L, -1L, TimeUnit.DAYS);
            }
        });
    }

    @Test
    public void testScheduleWithFixedDelayZero() {
        final TestScheduledEventExecutor executor = new TestScheduledEventExecutor();
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                executor.scheduleWithFixedDelay(TEST_RUNNABLE, 0L, -1L, TimeUnit.DAYS);
            }
        });
    }

    @Test
    public void testScheduleWithFixedDelayNegative() {
        final TestScheduledEventExecutor executor = new TestScheduledEventExecutor();
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                executor.scheduleWithFixedDelay(TEST_RUNNABLE, 0L, -1L, TimeUnit.DAYS);
            }
        });
    }

    private static final class TestScheduledEventExecutor
    extends AbstractScheduledEventExecutor {
        private TestScheduledEventExecutor() {
        }

        public boolean isShuttingDown() {
            return false;
        }

        public boolean inEventLoop(Thread thread) {
            return true;
        }

        public void shutdown() {
        }

        public Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        public Future<?> terminationFuture() {
            throw new UnsupportedOperationException();
        }

        public boolean isShutdown() {
            return false;
        }

        public boolean isTerminated() {
            return false;
        }

        public boolean awaitTermination(long timeout, TimeUnit unit) {
            return false;
        }

        public void execute(Runnable command) {
            throw new UnsupportedOperationException();
        }
    }
}

