/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.logging;

import io.netty.util.internal.ReflectionUtil;
import io.netty.util.internal.logging.AbstractInternalLoggerTest;
import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.Log4J2Logger;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.message.Message;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;

public class Log4J2LoggerTest
extends AbstractInternalLoggerTest<Logger> {
    public Log4J2LoggerTest() {
        this.mockLog = LogManager.getLogger((String)this.loggerName);
        this.logger = new Log4J2Logger((Logger)this.mockLog){
            private static final long serialVersionUID = 1L;

            public void logMessage(String fqcn, Level level, Marker marker, Message message, Throwable t) {
                Log4J2LoggerTest.this.result.put("level", level.name());
                Log4J2LoggerTest.this.result.put("t", t);
                super.logMessage(fqcn, level, marker, message, t);
            }
        };
    }

    @Override
    protected void setLevelEnable(InternalLogLevel level, boolean enable) throws Exception {
        Method method;
        Object targetLevel = Level.valueOf((String)level.name());
        if (!enable) {
            Object[] levels = Level.values();
            Arrays.sort(levels);
            int pos = Arrays.binarySearch(levels, targetLevel);
            targetLevel = levels[pos - 1];
        }
        if (!(method = ((Logger)this.mockLog).getClass().getDeclaredMethod("setLevel", Level.class)).isAccessible()) {
            Assumptions.assumeTrue((ReflectionUtil.trySetAccessible((AccessibleObject)method, (boolean)true) == null ? 1 : 0) != 0);
        }
        method.invoke(this.mockLog, targetLevel);
    }

    @Override
    protected void assertResult(InternalLogLevel level, String format, Throwable t, Object ... args) {
        super.assertResult(level, format, t, args);
        Assertions.assertEquals((Object)t, this.result.get("t"));
        Assertions.assertEquals((Object)level.name(), this.result.get("level"));
    }
}

