/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseAggregator;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.Mockito;

public class PromiseAggregatorTest {
    @Test
    public void testNullAggregatePromise() {
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() {
                new PromiseAggregator(null);
            }
        });
    }

    @Test
    public void testAddNullFuture() {
        Promise p = (Promise)Mockito.mock(Promise.class);
        final PromiseAggregator a = new PromiseAggregator(p);
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() {
                a.add((Promise[])null);
            }
        });
    }

    @Test
    public void testSuccessfulNoPending() throws Exception {
        Promise p = (Promise)Mockito.mock(Promise.class);
        PromiseAggregator a = new PromiseAggregator(p);
        Future future = (Future)Mockito.mock(Future.class);
        Mockito.when((Object)p.setSuccess(null)).thenReturn((Object)p);
        a.add(new Promise[0]);
        a.operationComplete(future);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{future});
        ((Promise)Mockito.verify((Object)p)).setSuccess(null);
    }

    @Test
    public void testSuccessfulPending() throws Exception {
        Promise p = (Promise)Mockito.mock(Promise.class);
        PromiseAggregator a = new PromiseAggregator(p);
        Promise p1 = (Promise)Mockito.mock(Promise.class);
        Promise p2 = (Promise)Mockito.mock(Promise.class);
        Mockito.when((Object)p1.addListener((GenericFutureListener)a)).thenReturn((Object)p1);
        Mockito.when((Object)p2.addListener((GenericFutureListener)a)).thenReturn((Object)p2);
        Mockito.when((Object)p1.isSuccess()).thenReturn((Object)true);
        Mockito.when((Object)p2.isSuccess()).thenReturn((Object)true);
        Mockito.when((Object)p.setSuccess(null)).thenReturn((Object)p);
        MatcherAssert.assertThat((Object)a.add(new Promise[]{p1, null, p2}), (Matcher)CoreMatchers.is((Object)a));
        a.operationComplete((Future)p1);
        a.operationComplete((Future)p2);
        ((Promise)Mockito.verify((Object)p1)).addListener((GenericFutureListener)a);
        ((Promise)Mockito.verify((Object)p2)).addListener((GenericFutureListener)a);
        ((Promise)Mockito.verify((Object)p1)).isSuccess();
        ((Promise)Mockito.verify((Object)p2)).isSuccess();
        ((Promise)Mockito.verify((Object)p)).setSuccess(null);
    }

    @Test
    public void testFailedFutureFailPending() throws Exception {
        Promise p = (Promise)Mockito.mock(Promise.class);
        PromiseAggregator a = new PromiseAggregator(p);
        Promise p1 = (Promise)Mockito.mock(Promise.class);
        Promise p2 = (Promise)Mockito.mock(Promise.class);
        Throwable t = (Throwable)Mockito.mock(Throwable.class);
        Mockito.when((Object)p1.addListener((GenericFutureListener)a)).thenReturn((Object)p1);
        Mockito.when((Object)p2.addListener((GenericFutureListener)a)).thenReturn((Object)p2);
        Mockito.when((Object)p1.isSuccess()).thenReturn((Object)false);
        Mockito.when((Object)p1.cause()).thenReturn((Object)t);
        Mockito.when((Object)p.setFailure(t)).thenReturn((Object)p);
        Mockito.when((Object)p2.setFailure(t)).thenReturn((Object)p2);
        a.add(new Promise[]{p1, p2});
        a.operationComplete((Future)p1);
        ((Promise)Mockito.verify((Object)p1)).addListener((GenericFutureListener)a);
        ((Promise)Mockito.verify((Object)p2)).addListener((GenericFutureListener)a);
        ((Promise)Mockito.verify((Object)p1)).cause();
        ((Promise)Mockito.verify((Object)p)).setFailure(t);
        ((Promise)Mockito.verify((Object)p2)).setFailure(t);
    }

    @Test
    public void testFailedFutureNoFailPending() throws Exception {
        Promise p = (Promise)Mockito.mock(Promise.class);
        PromiseAggregator a = new PromiseAggregator(p, false);
        Promise p1 = (Promise)Mockito.mock(Promise.class);
        Promise p2 = (Promise)Mockito.mock(Promise.class);
        Throwable t = (Throwable)Mockito.mock(Throwable.class);
        Mockito.when((Object)p1.addListener((GenericFutureListener)a)).thenReturn((Object)p1);
        Mockito.when((Object)p2.addListener((GenericFutureListener)a)).thenReturn((Object)p2);
        Mockito.when((Object)p1.isSuccess()).thenReturn((Object)false);
        Mockito.when((Object)p1.cause()).thenReturn((Object)t);
        Mockito.when((Object)p.setFailure(t)).thenReturn((Object)p);
        a.add(new Promise[]{p1, p2});
        a.operationComplete((Future)p1);
        ((Promise)Mockito.verify((Object)p1)).addListener((GenericFutureListener)a);
        ((Promise)Mockito.verify((Object)p2)).addListener((GenericFutureListener)a);
        ((Promise)Mockito.verify((Object)p1)).isSuccess();
        ((Promise)Mockito.verify((Object)p1)).cause();
        ((Promise)Mockito.verify((Object)p)).setFailure(t);
    }
}

