/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseNotifier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.Mockito;

public class PromiseNotifierTest {
    @Test
    public void testNullPromisesArray() {
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() {
                new PromiseNotifier((Promise[])null);
            }
        });
    }

    @Test
    public void testNullPromiseInArray() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                new PromiseNotifier(new Promise[]{null});
            }
        });
    }

    @Test
    public void testListenerSuccess() throws Exception {
        Promise p1 = (Promise)Mockito.mock(Promise.class);
        Promise p2 = (Promise)Mockito.mock(Promise.class);
        PromiseNotifier notifier = new PromiseNotifier(new Promise[]{p1, p2});
        Future future = (Future)Mockito.mock(Future.class);
        Mockito.when((Object)future.isSuccess()).thenReturn((Object)true);
        Mockito.when((Object)future.get()).thenReturn(null);
        Mockito.when((Object)p1.trySuccess(null)).thenReturn((Object)true);
        Mockito.when((Object)p2.trySuccess(null)).thenReturn((Object)true);
        notifier.operationComplete(future);
        ((Promise)Mockito.verify((Object)p1)).trySuccess(null);
        ((Promise)Mockito.verify((Object)p2)).trySuccess(null);
    }

    @Test
    public void testListenerFailure() throws Exception {
        Promise p1 = (Promise)Mockito.mock(Promise.class);
        Promise p2 = (Promise)Mockito.mock(Promise.class);
        PromiseNotifier notifier = new PromiseNotifier(new Promise[]{p1, p2});
        Future future = (Future)Mockito.mock(Future.class);
        Throwable t = (Throwable)Mockito.mock(Throwable.class);
        Mockito.when((Object)future.isSuccess()).thenReturn((Object)false);
        Mockito.when((Object)future.isCancelled()).thenReturn((Object)false);
        Mockito.when((Object)future.cause()).thenReturn((Object)t);
        Mockito.when((Object)p1.tryFailure(t)).thenReturn((Object)true);
        Mockito.when((Object)p2.tryFailure(t)).thenReturn((Object)true);
        notifier.operationComplete(future);
        ((Promise)Mockito.verify((Object)p1)).tryFailure(t);
        ((Promise)Mockito.verify((Object)p2)).tryFailure(t);
    }

    @Test
    public void testCancelPropagationWhenFusedFromFuture() {
        Promise p1 = ImmediateEventExecutor.INSTANCE.newPromise();
        Promise p2 = ImmediateEventExecutor.INSTANCE.newPromise();
        Promise returned = (Promise)PromiseNotifier.cascade((Future)p1, (Promise)p2);
        Assertions.assertSame((Object)p1, (Object)returned);
        Assertions.assertTrue((boolean)returned.cancel(false));
        Assertions.assertTrue((boolean)returned.isCancelled());
        Assertions.assertTrue((boolean)p2.isCancelled());
    }
}

