/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.PlatformDependent;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class OsClassifiersTest {
    private static final String OS_CLASSIFIERS_PROPERTY = "io.netty.osClassifiers";
    private Properties systemProperties;

    @BeforeEach
    void setUp() {
        this.systemProperties = System.getProperties();
    }

    @AfterEach
    void tearDown() {
        this.systemProperties.remove(OS_CLASSIFIERS_PROPERTY);
    }

    @Test
    void testOsClassifiersPropertyAbsent() {
        HashSet<String> allowed = new HashSet<String>(Arrays.asList("fedora", "suse", "arch"));
        LinkedHashSet available = new LinkedHashSet(2);
        boolean added = PlatformDependent.addPropertyOsClassifiers(allowed, available);
        Assertions.assertFalse((boolean)added);
        Assertions.assertTrue((boolean)available.isEmpty());
    }

    @Test
    void testOsClassifiersPropertyEmpty() {
        this.systemProperties.setProperty(OS_CLASSIFIERS_PROPERTY, "");
        Set<String> allowed = Collections.singleton("fedora");
        LinkedHashSet available = new LinkedHashSet(2);
        boolean added = PlatformDependent.addPropertyOsClassifiers(allowed, available);
        Assertions.assertTrue((boolean)added);
        Assertions.assertTrue((boolean)available.isEmpty());
    }

    @Test
    void testOsClassifiersPropertyNotEmptyNoClassifiers() {
        this.systemProperties.setProperty(OS_CLASSIFIERS_PROPERTY, ",");
        final HashSet<String> allowed = new HashSet<String>(Arrays.asList("fedora", "suse", "arch"));
        final LinkedHashSet available = new LinkedHashSet(2);
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                PlatformDependent.addPropertyOsClassifiers((Set)allowed, (Set)available);
            }
        });
    }

    @Test
    void testOsClassifiersPropertySingle() {
        this.systemProperties.setProperty(OS_CLASSIFIERS_PROPERTY, "fedora");
        Set<String> allowed = Collections.singleton("fedora");
        LinkedHashSet available = new LinkedHashSet(2);
        boolean added = PlatformDependent.addPropertyOsClassifiers(allowed, available);
        Assertions.assertTrue((boolean)added);
        Assertions.assertEquals((int)1, (int)available.size());
        Assertions.assertEquals((Object)"fedora", available.iterator().next());
    }

    @Test
    void testOsClassifiersPropertyPair() {
        this.systemProperties.setProperty(OS_CLASSIFIERS_PROPERTY, "manjaro,arch");
        HashSet<String> allowed = new HashSet<String>(Arrays.asList("fedora", "suse", "arch"));
        LinkedHashSet available = new LinkedHashSet(2);
        boolean added = PlatformDependent.addPropertyOsClassifiers(allowed, available);
        Assertions.assertTrue((boolean)added);
        Assertions.assertEquals((int)1, (int)available.size());
        Assertions.assertEquals((Object)"arch", available.iterator().next());
    }

    @Test
    void testOsClassifiersPropertyExcessive() {
        this.systemProperties.setProperty(OS_CLASSIFIERS_PROPERTY, "manjaro,arch,slackware");
        final HashSet<String> allowed = new HashSet<String>(Arrays.asList("fedora", "suse", "arch"));
        final LinkedHashSet available = new LinkedHashSet(2);
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                PlatformDependent.addPropertyOsClassifiers((Set)allowed, (Set)available);
            }
        });
    }
}

