/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.AbstractConstant;
import io.netty.util.ConstantPool;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeSet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class ConstantPoolTest {
    private static final ConstantPool<TestConstant> pool = new ConstantPool<TestConstant>(){

        protected TestConstant newConstant(int id, String name) {
            return new TestConstant(id, name);
        }
    };

    @Test
    public void testCannotProvideNullName() {
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() {
                pool.valueOf(null);
            }
        });
    }

    @Test
    public void testUniqueness() {
        TestConstant a = (TestConstant)pool.valueOf(new String("Leroy"));
        TestConstant b = (TestConstant)pool.valueOf(new String("Leroy"));
        MatcherAssert.assertThat((Object)((Object)a), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)((Object)b))));
    }

    @Test
    public void testIdUniqueness() {
        TestConstant one = (TestConstant)pool.valueOf("one");
        TestConstant two = (TestConstant)pool.valueOf("two");
        MatcherAssert.assertThat((Object)one.id(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)two.id())));
    }

    @Test
    public void testCompare() {
        TestConstant a = (TestConstant)pool.valueOf("a_alpha");
        TestConstant b = (TestConstant)pool.valueOf("b_beta");
        TestConstant c = (TestConstant)pool.valueOf("c_gamma");
        TestConstant d = (TestConstant)pool.valueOf("d_delta");
        TestConstant e = (TestConstant)pool.valueOf("e_epsilon");
        TreeSet<TestConstant> set = new TreeSet<TestConstant>();
        set.add(b);
        set.add(c);
        set.add(e);
        set.add(d);
        set.add(a);
        TestConstant[] array = set.toArray(new TestConstant[0]);
        MatcherAssert.assertThat((Object)array.length, (Matcher)CoreMatchers.is((Object)5));
        Arrays.sort(array, new Comparator<TestConstant>(){

            @Override
            public int compare(TestConstant o1, TestConstant o2) {
                return o1.name().compareTo(o2.name());
            }
        });
        MatcherAssert.assertThat((Object)((Object)array[0]), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)((Object)a))));
        MatcherAssert.assertThat((Object)((Object)array[1]), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)((Object)b))));
        MatcherAssert.assertThat((Object)((Object)array[2]), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)((Object)c))));
        MatcherAssert.assertThat((Object)((Object)array[3]), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)((Object)d))));
        MatcherAssert.assertThat((Object)((Object)array[4]), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)((Object)e))));
    }

    @Test
    public void testComposedName() {
        TestConstant a = (TestConstant)pool.valueOf(Object.class, "A");
        MatcherAssert.assertThat((Object)a.name(), (Matcher)CoreMatchers.is((Object)"java.lang.Object#A"));
    }

    static final class TestConstant
    extends AbstractConstant<TestConstant> {
        TestConstant(int id, String name) {
            super(id, name);
        }
    }
}

