/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.NetUtil;
import io.netty.util.internal.StringUtil;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NetUtilTest {
    private static final Map<String, String> validIpV4Hosts = new TestMap("192.168.1.0", "c0a80100", "10.255.255.254", "0afffffe", "172.18.5.4", "ac120504", "0.0.0.0", "00000000", "127.0.0.1", "7f000001", "255.255.255.255", "ffffffff", "1.2.3.4", "01020304");
    private static final Map<String, String> invalidIpV4Hosts = new TestMap("1.256.3.4", null, "256.0.0.1", null, "1.1.1.1.1", null, "x.255.255.255", null, "0.1:0.0", null, "0.1.0.0:", null, "127.0.0.", null, "1.2..4", null, "192.0.1", null, "192.0.1.1.1", null, "192.0.1.a", null, "19a.0.1.1", null, "a.0.1.1", null, ".0.1.1", null, "127.0.0", null, "192.0.1.256", null, "0.0.200.259", null, "1.1.-1.1", null, "1.1. 1.1", null, "1.1.1.1 ", null, "1.1.+1.1", null, "0.0x1.0.255", null, "0.01x.0.255", null, "0.x01.0.255", null, "0.-.0.0", null, "0..0.0", null, "0.A.0.0", null, "0.1111.0.0", null, "...", null);
    private static final Map<String, String> validIpV6Hosts = new TestMap("::ffff:5.6.7.8", "00000000000000000000ffff05060708", "fdf8:f53b:82e4::53", "fdf8f53b82e400000000000000000053", "fe80::200:5aee:feaa:20a2", "fe8000000000000002005aeefeaa20a2", "2001::1", "20010000000000000000000000000001", "2001:0000:4136:e378:8000:63bf:3fff:fdd2", "200100004136e378800063bf3ffffdd2", "2001:0002:6c::430", "20010002006c00000000000000000430", "2001:10:240:ab::a", "20010010024000ab000000000000000a", "2002:cb0a:3cdd:1::1", "2002cb0a3cdd00010000000000000001", "2001:db8:8:4::2", "20010db8000800040000000000000002", "ff01:0:0:0:0:0:0:2", "ff010000000000000000000000000002", "[fdf8:f53b:82e4::53]", "fdf8f53b82e400000000000000000053", "[fe80::200:5aee:feaa:20a2]", "fe8000000000000002005aeefeaa20a2", "[2001::1]", "20010000000000000000000000000001", "[2001:0000:4136:e378:8000:63bf:3fff:fdd2]", "200100004136e378800063bf3ffffdd2", "0:1:2:3:4:5:6:789a", "0000000100020003000400050006789a", "0:1:2:3::f", "0000000100020003000000000000000f", "0:0:0:0:0:0:10.0.0.1", "00000000000000000000ffff0a000001", "0:0:0:0:0::10.0.0.1", "00000000000000000000ffff0a000001", "0:0:0:0::10.0.0.1", "00000000000000000000ffff0a000001", "::0:0:0:0:0:10.0.0.1", "00000000000000000000ffff0a000001", "0::0:0:0:0:10.0.0.1", "00000000000000000000ffff0a000001", "0:0::0:0:0:10.0.0.1", "00000000000000000000ffff0a000001", "0:0:0::0:0:10.0.0.1", "00000000000000000000ffff0a000001", "0:0:0:0::0:10.0.0.1", "00000000000000000000ffff0a000001", "0:0:0:0:0:ffff:10.0.0.1", "00000000000000000000ffff0a000001", "::ffff:192.168.0.1", "00000000000000000000ffffc0a80001", "[::1%1]", "00000000000000000000000000000001", "[::1%eth0]", "00000000000000000000000000000001", "[::1%%]", "00000000000000000000000000000001", "0:0:0:0:0:ffff:10.0.0.1%", "00000000000000000000ffff0a000001", "0:0:0:0:0:ffff:10.0.0.1%1", "00000000000000000000ffff0a000001", "[0:0:0:0:0:ffff:10.0.0.1%1]", "00000000000000000000ffff0a000001", "[0:0:0:0:0::10.0.0.1%1]", "00000000000000000000ffff0a000001", "[::0:0:0:0:ffff:10.0.0.1%1]", "00000000000000000000ffff0a000001", "::0:0:0:0:ffff:10.0.0.1%1", "00000000000000000000ffff0a000001", "::1%1", "00000000000000000000000000000001", "::1%eth0", "00000000000000000000000000000001", "::1%%", "00000000000000000000000000000001", "0:0:0:0:0:0:0::", "00000000000000000000000000000000", "0:0:0:0:0:0::", "00000000000000000000000000000000", "0:0:0:0:0::", "00000000000000000000000000000000", "0:0:0:0::", "00000000000000000000000000000000", "0:0:0::", "00000000000000000000000000000000", "0:0::", "00000000000000000000000000000000", "0::", "00000000000000000000000000000000", "::", "00000000000000000000000000000000", "::0", "00000000000000000000000000000000", "::0:0", "00000000000000000000000000000000", "::0:0:0", "00000000000000000000000000000000", "::0:0:0:0", "00000000000000000000000000000000", "::0:0:0:0:0", "00000000000000000000000000000000", "::0:0:0:0:0:0", "00000000000000000000000000000000", "::0:0:0:0:0:0:0", "00000000000000000000000000000000");
    private static final Map<String, String> invalidIpV6Hosts = new TestMap("Obvious Garbage", null, "0:1:2:3:4:5:6:7:8", null, "0:1:2:3:4:5:6", null, "0:1:2:3:4:5:6:x", null, "0:1:2:3:4:5:6::7", null, "0:1:2:3:4:5:6:7::", null, "::0:1:2:3:4:5:6:7", null, "1:2:3:4:5:6:7:", null, ":1:2:3:4:5:6:7", null, "0:1:2:3:4:5::7:", null, "0:1:2:3:4::7:", null, "0:1:2:3::7:", null, "0:1:2::7:", null, "0:1::7:", null, "0::7:", null, "::0:1:2:3:4:5:7:", null, "::0:1:2:3:4:7:", null, "::0:1:2:3:7:", null, "::0:1:2:7:", null, "::0:1:7:", null, "::7:", null, ":1:2:3:4:5:6:7:", null, ":1:2:3:4:5:6:", null, ":1:2:3:4:5:", null, ":1:2:3:4:", null, ":1:2:3:", null, ":1:2:", null, ":1:", null, ":1::2:3:4:5:6:7", null, ":1::3:4:5:6:7", null, ":1::4:5:6:7", null, ":1::5:6:7", null, ":1::6:7", null, ":1::7", null, ":1:2:3:4:5:6::7", null, ":1:3:4:5:6::7", null, ":1:4:5:6::7", null, ":1:5:6::7", null, ":1:6::7", null, ":1::", null, ":1:2:3:4:5:6:7::", null, ":1:3:4:5:6:7::", null, ":1:4:5:6:7::", null, ":1:5:6:7::", null, ":1:6:7::", null, ":1:7::", null, "1::2:3:4:5:6::", null, "::1:2:3:4:5::6", null, "::1:2:3:4:5:6::", null, "::1:2:3:4:5::", null, "::1:2:3:4::", null, "::1:2:3::", null, "::1:2::", null, "::0::", null, "12::0::12", null, "0::1:2:3:4:5:6:7", null, "0:1:2:3:4:5:6:789abcdef", null, "0:1:2:3::x", null, "0:1:2:::3", null, "0:1:2:3::abcde", null, "0:1", null, "0:0:0:0:0:x:10.0.0.1", null, "0:0:0:0:0:0:10.0.0.x", null, "0:0:0:0:0:00000:10.0.0.1", null, "0:0:0:0:0:0:0:10.0.0.1", null, "0:0:0:0:0:10.0.0.1", null, "0:0:0:0:0:0:10.0.0.0.1", null, "0:0:0:0:0:0:10.0.1", null, "0:0:0:0:0:0:10..0.0.1", null, "0:0:0:0:0:0:.0.0.1", null, "0:0:0:0:0:0:.10.0.0.1", null, "0:0:0:0:0:0:10.0.0.", null, "0:0:0:0:0:0:10.0.0.1.", null, "::fffx:192.168.0.1", null, "::ffff:192.168.0.x", null, ":::ffff:192.168.0.1", null, "::fffff:192.168.0.1", null, "::ffff:1923.168.0.1", null, ":ffff:192.168.0.1", null, "::ffff:192.168.0.1.2", null, "::ffff:192.168.0", null, "::ffff:192.168..0.1", null, "x:0:0:0:0:0:10.0.0.1", null, "0:0:0:0:0:0:x.0.0.1", null, "00000:0:0:0:0:0:10.0.0.1", null, "0:0:0:0:0:0:10.0.0.1000", null, "0:0:0:0:0:0:0:10.0.0.1", null, "0:0:0:0:0:10.0.0.1", null, "0:0:0:0:0:10.0.0.1:", null, ":0:0:0:0:0:10.0.0.1", null, "0:0:0:0::10.0.0.1:", null, ":0:0:0:0::10.0.0.1", null, "0:0:0:0:0:0:10.0.0.0.1", null, "0:0:0:0:0:0:10.0.1", null, "0:0:0:0:0:0:10.0.0..1", null, "", null, ":", null, ":::", null, "2001:0:4136:e378:8000:63bf:3fff:fdd2:", null, ":aaaa:bbbb:cccc:dddd:eeee:ffff:1111:2222", null, "1234:2345:3456:4567:5678:6789::X890", null, "::ffff:255.255.255.255.", null, "::ffff:0.0.1111.0", null, "::ffff:0.0..0", null, "::ffff:127.0.0.", null, "::ffff:127.0.0.a", null, "::ffff:a.0.0.1", null, "::ffff:127.a.0.1", null, "::ffff:127.0.a.1", null, "::ffff:1.2.4", null, "::ffff:192.168.0.1.255", null, ":ffff:192.168.0.1.255", null, "::ffff:255.255:255.255.", null, "0:0:0::0:0:00f.0.0.1", null, "0:0:0:0:0:fff:1.0.0.1", null, "0:0:0:0:0:ff00:1.0.0.1", null, "0:0:0:0:0:ff:1.0.0.1", null, "0:0:0:0:0:fffff:1.0.0.1", null, "0:0:0:0:0:0:ffff:1.0.0.1", null, "::0:0:0:0:0:ffff:1.0.0.1", null, "0:0:0:0:0:0::1.0.0.1", null, "0:0:0:0:0:00000:1.0.0.1", null, "0:0:0:0:ffff:1.0.0.1", null, "ffff:192.168.0.1", null, "0:0:0:0:0:ffff::10.0.0.1", null, "0:0:0:0:ffff::10.0.0.1", null, "0:0:0:ffff::10.0.0.1", null, "0:0:ffff::10.0.0.1", null, "0:ffff::10.0.0.1", null, "ffff::10.0.0.1", null, "1:0:0:0:0:ffff:10.0.0.1", null, "0:0:0:0:ffff:ffff:1.0.0.1", null, "::1:2:3:4:5:6.7.8.9", null, "0:0:0:0:0:0:ffff:10.0.0.1", null, ":1.2.3.4", null, "::.2.3.4", null, "::ffff:0.1.2.", null);
    private static final Map<byte[], String> ipv6ToAddressStrings = new HashMap<byte[], String>(){
        private static final long serialVersionUID = 2999763170377573184L;
        {
            this.put(new byte[]{32, 1, 13, -72, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, "2001:db8::1");
            this.put(new byte[]{32, 1, 13, -72, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 1}, "2001:db8::2:1");
            this.put(new byte[]{32, 1, 13, -72, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1}, "2001:db8:0:1:1:1:1:1");
            this.put(new byte[]{32, 1, 13, -72, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 1}, "2001:db8::2:1");
            this.put(new byte[]{32, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1}, "2001:0:0:1::1");
            this.put(new byte[]{32, 1, 13, -72, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1}, "2001:db8::1:0:0:1");
            this.put(new byte[]{32, 1, 13, -72, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0}, "2001:db8:0:0:1::");
            this.put(new byte[]{32, 1, 13, -72, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0}, "2001:db8::2:0");
            this.put(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, "::1");
            this.put(new byte[]{0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1}, "::1:0:0:0:1");
            this.put(new byte[]{0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0}, "::100:1:0:0:100:0");
            this.put(new byte[]{32, 1, 0, 0, 65, 54, -29, 120, -128, 0, 99, -65, 63, -1, -3, -46}, "2001:0:4136:e378:8000:63bf:3fff:fdd2");
            this.put(new byte[]{-86, -86, -69, -69, -52, -52, -35, -35, -18, -18, -1, -1, 17, 17, 34, 34}, "aaaa:bbbb:cccc:dddd:eeee:ffff:1111:2222");
            this.put(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, "::");
        }
    };
    private static final Map<String, String> ipv4MappedToIPv6AddressStrings = new TestMap("255.255.255.255", "::ffff:255.255.255.255", "0.0.0.0", "::ffff:0.0.0.0", "127.0.0.1", "::ffff:127.0.0.1", "1.2.3.4", "::ffff:1.2.3.4", "192.168.0.1", "::ffff:192.168.0.1", "0:0:0:0:0:0:255.254.253.252", "::ffff:255.254.253.252", "0:0:0:0:0::1.2.3.4", "::ffff:1.2.3.4", "0:0:0:0::1.2.3.4", "::ffff:1.2.3.4", "::0:0:0:0:0:1.2.3.4", "::ffff:1.2.3.4", "0::0:0:0:0:1.2.3.4", "::ffff:1.2.3.4", "0:0::0:0:0:1.2.3.4", "::ffff:1.2.3.4", "0:0:0::0:0:1.2.3.4", "::ffff:1.2.3.4", "0:0:0:0::0:1.2.3.4", "::ffff:1.2.3.4", "0:0:0:0:0::1.2.3.4", "::ffff:1.2.3.4", "::0:0:0:0:1.2.3.4", "::ffff:1.2.3.4", "0::0:0:0:1.2.3.4", "::ffff:1.2.3.4", "0:0::0:0:1.2.3.4", "::ffff:1.2.3.4", "0:0:0::0:1.2.3.4", "::ffff:1.2.3.4", "0:0:0:0::1.2.3.4", "::ffff:1.2.3.4", "::0:0:0:0:1.2.3.4", "::ffff:1.2.3.4", "0::0:0:0:1.2.3.4", "::ffff:1.2.3.4", "0:0::0:0:1.2.3.4", "::ffff:1.2.3.4", "0:0:0::0:1.2.3.4", "::ffff:1.2.3.4", "0:0:0:0::1.2.3.4", "::ffff:1.2.3.4", "::0:0:0:1.2.3.4", "::ffff:1.2.3.4", "0::0:0:1.2.3.4", "::ffff:1.2.3.4", "0:0::0:1.2.3.4", "::ffff:1.2.3.4", "0:0:0::1.2.3.4", "::ffff:1.2.3.4", "::0:0:1.2.3.4", "::ffff:1.2.3.4", "0::0:1.2.3.4", "::ffff:1.2.3.4", "0:0::1.2.3.4", "::ffff:1.2.3.4", "::0:1.2.3.4", "::ffff:1.2.3.4", "::1.2.3.4", "::ffff:1.2.3.4", "0:0:0:0:0:ffff:1.2.3.4", "::ffff:1.2.3.4", "2001:0:4136:e378:8000:63bf:3fff:fdd2", "2001:0:4136:e378:8000:63bf:3fff:fdd2", "aaaa:bbbb:cccc:dddd:eeee:ffff:1111:2222", "aaaa:bbbb:cccc:dddd:eeee:ffff:1111:2222", "0:0:0:0:0:0:0:0", "::", "0:0:0:0:0:0:0:1", "::1", "::1:0:0:0:1", "::1:0:0:0:1", "::1:ffff:ffff", "::1:ffff:ffff", "::", "::", "::1", "::1", "::ffff", "::ffff", "::ffff:0", "::ffff:0", "::ffff:ffff", "::ffff:ffff", "::0987:9876:8765", "::987:9876:8765", "::0987:9876:8765:7654", "::987:9876:8765:7654", "::0987:9876:8765:7654:6543", "::987:9876:8765:7654:6543", "::0987:9876:8765:7654:6543:5432", "::987:9876:8765:7654:6543:5432", "::0987:9876:8765:7654:6543:5432:3210", "0:987:9876:8765:7654:6543:5432:3210", "2001:db8:abcd:bcde:cdef:def1:ef12::", "2001:db8:abcd:bcde:cdef:def1:ef12:0", "2001:db8:abcd:bcde:cdef:def1::", "2001:db8:abcd:bcde:cdef:def1::", "2001:db8:abcd:bcde:cdef::", "2001:db8:abcd:bcde:cdef::", "2001:db8:abcd:bcde::", "2001:db8:abcd:bcde::", "2001:db8:abcd::", "2001:db8:abcd::", "2001:1234::", "2001:1234::", "2001::", "2001::", "0::", "::", "1234:2345::7890", "1234:2345::7890", "1234::2345:7890", "1234::2345:7890", "1234:2345:3456::7890", "1234:2345:3456::7890", "1234:2345::3456:7890", "1234:2345::3456:7890", "1234::2345:3456:7890", "1234::2345:3456:7890", "1234:2345:3456:4567::7890", "1234:2345:3456:4567::7890", "1234:2345:3456::4567:7890", "1234:2345:3456::4567:7890", "1234:2345::3456:4567:7890", "1234:2345::3456:4567:7890", "1234::2345:3456:4567:7890", "1234::2345:3456:4567:7890", "1234:2345:3456:4567:5678::7890", "1234:2345:3456:4567:5678::7890", "1234:2345:3456:4567::5678:7890", "1234:2345:3456:4567::5678:7890", "1234:2345:3456::4567:5678:7890", "1234:2345:3456::4567:5678:7890", "1234:2345::3456:4567:5678:7890", "1234:2345::3456:4567:5678:7890", "1234::2345:3456:4567:5678:7890", "1234::2345:3456:4567:5678:7890", "1234:2345:3456:4567:5678:6789::7890", "1234:2345:3456:4567:5678:6789:0:7890", "1234:2345:3456:4567:5678::6789:7890", "1234:2345:3456:4567:5678:0:6789:7890", "1234:2345:3456:4567::5678:6789:7890", "1234:2345:3456:4567:0:5678:6789:7890", "1234:2345:3456::4567:5678:6789:7890", "1234:2345:3456:0:4567:5678:6789:7890", "1234:2345::3456:4567:5678:6789:7890", "1234:2345:0:3456:4567:5678:6789:7890", "1234::2345:3456:4567:5678:6789:7890", "1234:0:2345:3456:4567:5678:6789:7890", "::ffff:255.255.255.255", "::ffff:255.255.255.255", "::ffff:0.0.0.0", "::ffff:0.0.0.0", "::ffff:127.0.0.1", "::ffff:127.0.0.1", "::ffff:1.2.3.4", "::ffff:1.2.3.4", "::ffff:192.168.0.1", "::ffff:192.168.0.1");

    @Test
    public void testLocalhost() {
        Assertions.assertNotNull((Object)NetUtil.LOCALHOST);
    }

    @Test
    public void testLoopback() {
        Assertions.assertNotNull((Object)NetUtil.LOOPBACK_IF);
    }

    @Test
    public void testIsValidIpV4Address() {
        for (String host : validIpV4Hosts.keySet()) {
            Assertions.assertTrue((boolean)NetUtil.isValidIpV4Address((String)host), (String)host);
        }
        for (String host : invalidIpV4Hosts.keySet()) {
            Assertions.assertFalse((boolean)NetUtil.isValidIpV4Address((String)host), (String)host);
        }
    }

    @Test
    public void testIsValidIpV6Address() {
        String hostMod;
        for (String host : validIpV6Hosts.keySet()) {
            Assertions.assertTrue((boolean)NetUtil.isValidIpV6Address((String)host), (String)host);
            if (host.charAt(0) == '[' || host.contains("%")) continue;
            Assertions.assertNotNull((Object)NetUtil.getByName((CharSequence)host, (boolean)true), (String)host);
            hostMod = '[' + host + ']';
            Assertions.assertTrue((boolean)NetUtil.isValidIpV6Address((String)hostMod), (String)hostMod);
            hostMod = host + '%';
            Assertions.assertTrue((boolean)NetUtil.isValidIpV6Address((String)hostMod), (String)hostMod);
            hostMod = host + "%eth1";
            Assertions.assertTrue((boolean)NetUtil.isValidIpV6Address((String)hostMod), (String)hostMod);
            hostMod = '[' + host + "%]";
            Assertions.assertTrue((boolean)NetUtil.isValidIpV6Address((String)hostMod), (String)hostMod);
            hostMod = '[' + host + "%1]";
            Assertions.assertTrue((boolean)NetUtil.isValidIpV6Address((String)hostMod), (String)hostMod);
            hostMod = '[' + host + "]%";
            Assertions.assertFalse((boolean)NetUtil.isValidIpV6Address((String)hostMod), (String)hostMod);
            hostMod = '[' + host + "]%1";
            Assertions.assertFalse((boolean)NetUtil.isValidIpV6Address((String)hostMod), (String)hostMod);
        }
        for (String host : invalidIpV6Hosts.keySet()) {
            Assertions.assertFalse((boolean)NetUtil.isValidIpV6Address((String)host), (String)host);
            Assertions.assertNull((Object)NetUtil.getByName((CharSequence)host), (String)host);
            hostMod = '[' + host + ']';
            Assertions.assertFalse((boolean)NetUtil.isValidIpV6Address((String)hostMod), (String)hostMod);
            hostMod = host + '%';
            Assertions.assertFalse((boolean)NetUtil.isValidIpV6Address((String)hostMod), (String)hostMod);
            hostMod = host + "%eth1";
            Assertions.assertFalse((boolean)NetUtil.isValidIpV6Address((String)hostMod), (String)hostMod);
            hostMod = '[' + host + "%]";
            Assertions.assertFalse((boolean)NetUtil.isValidIpV6Address((String)hostMod), (String)hostMod);
            hostMod = '[' + host + "%1]";
            Assertions.assertFalse((boolean)NetUtil.isValidIpV6Address((String)hostMod), (String)hostMod);
            hostMod = '[' + host + "]%";
            Assertions.assertFalse((boolean)NetUtil.isValidIpV6Address((String)hostMod), (String)hostMod);
            hostMod = '[' + host + "]%1";
            Assertions.assertFalse((boolean)NetUtil.isValidIpV6Address((String)hostMod), (String)hostMod);
            hostMod = host + ']';
            Assertions.assertFalse((boolean)NetUtil.isValidIpV6Address((String)hostMod), (String)hostMod);
            hostMod = '[' + host;
            Assertions.assertFalse((boolean)NetUtil.isValidIpV6Address((String)hostMod), (String)hostMod);
        }
    }

    @Test
    public void testCreateByteArrayFromIpAddressString() {
        String ip;
        for (Map.Entry<String, String> e : validIpV4Hosts.entrySet()) {
            ip = e.getKey();
            NetUtilTest.assertHexDumpEquals(e.getValue(), NetUtil.createByteArrayFromIpAddressString((String)ip), ip);
        }
        for (Map.Entry<String, String> e : invalidIpV4Hosts.entrySet()) {
            ip = e.getKey();
            NetUtilTest.assertHexDumpEquals(e.getValue(), NetUtil.createByteArrayFromIpAddressString((String)ip), ip);
        }
        for (Map.Entry<String, String> e : validIpV6Hosts.entrySet()) {
            ip = e.getKey();
            NetUtilTest.assertHexDumpEquals(e.getValue(), NetUtil.createByteArrayFromIpAddressString((String)ip), ip);
        }
        for (Map.Entry<String, String> e : invalidIpV6Hosts.entrySet()) {
            ip = e.getKey();
            NetUtilTest.assertHexDumpEquals(e.getValue(), NetUtil.createByteArrayFromIpAddressString((String)ip), ip);
        }
    }

    @Test
    public void testBytesToIpAddress() {
        for (Map.Entry<String, String> entry : validIpV4Hosts.entrySet()) {
            Assertions.assertEquals((Object)entry.getKey(), (Object)NetUtil.bytesToIpAddress((byte[])NetUtil.createByteArrayFromIpAddressString((String)entry.getKey())));
            Assertions.assertEquals((Object)entry.getKey(), (Object)NetUtil.bytesToIpAddress((byte[])NetUtil.validIpV4ToBytes((String)entry.getKey())));
        }
        for (Map.Entry<String, String> entry : ipv6ToAddressStrings.entrySet()) {
            Assertions.assertEquals((Object)entry.getValue(), (Object)NetUtil.bytesToIpAddress((byte[])((byte[])entry.getKey())));
        }
    }

    @Test
    public void testBytesToIpAddressWithOffset() {
        byte[] bytes;
        for (Map.Entry<String, String> entry : validIpV4Hosts.entrySet()) {
            bytes = NetUtilTest.copyWithOffset(NetUtil.createByteArrayFromIpAddressString((String)entry.getKey()));
            Assertions.assertEquals((Object)entry.getKey(), (Object)NetUtil.bytesToIpAddress((byte[])bytes, (int)1, (int)(bytes.length - 2)));
            byte[] bytes2 = NetUtilTest.copyWithOffset(NetUtil.createByteArrayFromIpAddressString((String)entry.getKey()));
            Assertions.assertEquals((Object)entry.getKey(), (Object)NetUtil.bytesToIpAddress((byte[])bytes2, (int)1, (int)(bytes2.length - 2)));
        }
        for (Map.Entry<String, String> entry : ipv6ToAddressStrings.entrySet()) {
            bytes = NetUtilTest.copyWithOffset((byte[])entry.getKey());
            Assertions.assertEquals((Object)entry.getValue(), (Object)NetUtil.bytesToIpAddress((byte[])bytes, (int)1, (int)(bytes.length - 2)));
        }
    }

    private static byte[] copyWithOffset(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        byte[] array = new byte[bytes.length + 2];
        System.arraycopy(bytes, 0, array, 1, bytes.length);
        return array;
    }

    @Test
    public void testIp6AddressToString() throws UnknownHostException {
        for (Map.Entry<byte[], String> testEntry : ipv6ToAddressStrings.entrySet()) {
            Assertions.assertEquals((Object)testEntry.getValue(), (Object)NetUtil.toAddressString((InetAddress)InetAddress.getByAddress(testEntry.getKey())));
        }
    }

    @Test
    public void testIp4AddressToString() throws UnknownHostException {
        for (Map.Entry<String, String> e : validIpV4Hosts.entrySet()) {
            Assertions.assertEquals((Object)e.getKey(), (Object)NetUtil.toAddressString((InetAddress)InetAddress.getByAddress(NetUtilTest.unhex(e.getValue()))));
        }
    }

    @Test
    public void testIPv4ToInt() throws UnknownHostException {
        Assertions.assertEquals((int)2130706433, (int)NetUtil.ipv4AddressToInt((Inet4Address)((Inet4Address)InetAddress.getByName("127.0.0.1"))));
        Assertions.assertEquals((int)-1062731519, (int)NetUtil.ipv4AddressToInt((Inet4Address)((Inet4Address)InetAddress.getByName("192.168.1.1"))));
    }

    @Test
    public void testIpv4MappedIp6GetByName() {
        for (Map.Entry<String, String> testEntry : ipv4MappedToIPv6AddressStrings.entrySet()) {
            String srcIp = testEntry.getKey();
            String dstIp = testEntry.getValue();
            Inet6Address inet6Address = NetUtil.getByName((CharSequence)srcIp, (boolean)true);
            Assertions.assertNotNull((Object)inet6Address, (String)(srcIp + ", " + dstIp));
            Assertions.assertEquals((Object)dstIp, (Object)NetUtil.toAddressString((InetAddress)inet6Address, (boolean)true), (String)srcIp);
        }
    }

    @Test
    public void testInvalidIpv4MappedIp6GetByName() {
        for (String host : invalidIpV4Hosts.keySet()) {
            Assertions.assertNull((Object)NetUtil.getByName((CharSequence)host, (boolean)true), (String)host);
        }
        for (String host : invalidIpV6Hosts.keySet()) {
            Assertions.assertNull((Object)NetUtil.getByName((CharSequence)host, (boolean)true), (String)host);
        }
    }

    @Test
    public void testIp6InetSocketAddressToString() throws UnknownHostException {
        for (Map.Entry<byte[], String> testEntry : ipv6ToAddressStrings.entrySet()) {
            Assertions.assertEquals((Object)('[' + testEntry.getValue() + "]:9999"), (Object)NetUtil.toSocketAddressString((InetSocketAddress)new InetSocketAddress(InetAddress.getByAddress(testEntry.getKey()), 9999)));
        }
    }

    @Test
    public void testIp4SocketAddressToString() throws UnknownHostException {
        for (Map.Entry<String, String> e : validIpV4Hosts.entrySet()) {
            Assertions.assertEquals((Object)(e.getKey() + ":9999"), (Object)NetUtil.toSocketAddressString((InetSocketAddress)new InetSocketAddress(InetAddress.getByAddress(NetUtilTest.unhex(e.getValue())), 9999)));
        }
    }

    private static void assertHexDumpEquals(String expected, byte[] actual, String message) {
        Assertions.assertEquals((Object)expected, (Object)NetUtilTest.hex(actual), (String)message);
    }

    private static String hex(byte[] value) {
        if (value == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(value.length << 1);
        for (byte b : value) {
            String hex = StringUtil.byteToHexString((int)b);
            if (hex.length() == 1) {
                buf.append('0');
            }
            buf.append(hex);
        }
        return buf.toString();
    }

    private static byte[] unhex(String value) {
        return value != null ? StringUtil.decodeHexDump((CharSequence)value) : null;
    }

    private static final class TestMap
    extends HashMap<String, String> {
        private static final long serialVersionUID = -298642816998608473L;

        TestMap(String ... values) {
            for (int i = 0; i < values.length; i += 2) {
                String key = values[i];
                String value = values[i + 1];
                this.put(key, value);
            }
        }
    }
}

