/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.ReflectionUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;

final class SunMiscUnsafeAccess {
    private static final InternalLogger logger;
    private static final String SUN_MISC_UNSAFE_CLASS_NAME = "sun.misc.Unsafe";
    private static final Throwable EXPLICIT_NO_UNSAFE_CAUSE;
    private static final Throwable UNSAFE_UNAVAILABILITY_CAUSE;
    private static final MethodHandle UNSAFE_ALLOCATE_MEMORY_HANDLE;
    private static final MethodHandle UNSAFE_COPY_MEMORY_WITH_OBJECT_HANDLE;
    private static final MethodHandle UNSAFE_COPY_MEMORY_WITH_LONG_HANDLE;
    private static final MethodHandle UNSAFE_OBJECT_FIELD_OFFSET_HANDLE;
    private static final MethodHandle UNSAFE_REALLOCATE_MEMORY_HANDLE;
    private static final MethodHandle UNSAFE_FREE_MEMORY_HANDLE;
    private static final MethodHandle UNSAFE_SET_MEMORY_WITH_LONG_HANDLE;
    private static final MethodHandle UNSAFE_SET_MEMORY_WITH_OBJECT_HANDLE;
    private static final MethodHandle UNSAFE_GET_BYTE_WITH_LONG_HANDLE;
    private static final MethodHandle UNSAFE_GET_BYTE_WITH_OBJECT_HANDLE;
    private static final MethodHandle UNSAFE_GET_CHAR_WITH_OBJECT_HANDLE;
    private static final MethodHandle UNSAFE_GET_SHORT_WITH_LONG_HANDLE;
    private static final MethodHandle UNSAFE_GET_SHORT_WITH_OBJECT_HANDLE;
    private static final MethodHandle UNSAFE_GET_INT_WITH_LONG_HANDLE;
    private static final MethodHandle UNSAFE_GET_INT_WITH_OBJECT_HANDLE;
    private static final MethodHandle UNSAFE_GET_INT_VOLATILE_WITH_OBJECT_HANDLE;
    private static final MethodHandle UNSAFE_GET_LONG_WITH_LONG_HANDLE;
    private static final MethodHandle UNSAFE_GET_LONG_WITH_OBJECT_HANDLE;
    private static final MethodHandle UNSAFE_GET_OBJECT_WITH_OBJECT_HANDLE;
    private static final MethodHandle UNSAFE_PUT_BYTE_WITH_LONG_HANDLE;
    private static final MethodHandle UNSAFE_PUT_BYTE_WITH_OBJECT_HANDLE;
    private static final MethodHandle UNSAFE_PUT_SHORT_WITH_LONG_HANDLE;
    private static final MethodHandle UNSAFE_PUT_SHORT_WITH_OBJECT_HANDLE;
    private static final MethodHandle UNSAFE_PUT_INT_WITH_LONG_HANDLE;
    private static final MethodHandle UNSAFE_PUT_INT_WITH_OBJECT_HANDLE;
    private static final MethodHandle UNSAFE_PUT_ORDERED_INT_WITH_OBJECT_HANDLE;
    private static final MethodHandle UNSAFE_PUT_LONG_WITH_LONG_HANDLE;
    private static final MethodHandle UNSAFE_PUT_LONG_WITH_OBJECT_HANDLE;
    private static final MethodHandle UNSAFE_PUT_OBJECT_WITH_OBJECT_HANDLE;
    private static final MethodHandle UNSAFE_ADDRESS_SIZE_HANDLE;
    private static final MethodHandle UNSAFE_STORE_FENCE_HANDLE;
    private static final MethodHandle UNSAFE_ARRAY_BASE_OFFSET_HANDLE;
    private static final MethodHandle UNSAFE_ARRAY_INDEX_SCALE_HANDLE;
    private static final MethodHandle UNSAFE_STATIC_FIELD_OFFSET_HANDLE;
    private static final MethodHandle UNSAFE_STATIC_FIELD_BASE_HANDLE;
    private static final MethodHandle UNSAFE_GET_BOOLEAN_WITH_OBJECT_HANDLE;
    static final Object UNSAFE;

    static boolean isExplicitNoUnsafe() {
        return EXPLICIT_NO_UNSAFE_CAUSE != null;
    }

    private static Throwable explicitNoUnsafeCause0() {
        boolean noUnsafe = SystemPropertyUtil.getBoolean("io.netty.noUnsafe", false);
        logger.debug("-Dio.netty.noUnsafe: {}", (Object)noUnsafe);
        String unsafeMemoryAccess = SystemPropertyUtil.get("sun.misc.unsafe.memory.access", "<unspecified>");
        if (!"allow".equals(unsafeMemoryAccess) && !"<unspecified>".equals(unsafeMemoryAccess)) {
            logger.debug("--sun-misc-unsafe-memory-access={}", (Object)unsafeMemoryAccess);
            noUnsafe = true;
        }
        if (noUnsafe) {
            logger.debug("{}: unavailable (io.netty.noUnsafe)", (Object)SUN_MISC_UNSAFE_CLASS_NAME);
            return new UnsupportedOperationException("sun.misc.Unsafe: unavailable (io.netty.noUnsafe)");
        }
        String unsafePropName = SystemPropertyUtil.contains("io.netty.tryUnsafe") ? "io.netty.tryUnsafe" : "org.jboss.netty.tryUnsafe";
        if (!SystemPropertyUtil.getBoolean(unsafePropName, true)) {
            String msg = "{}: unavailable ({})";
            logger.debug(msg, (Object)SUN_MISC_UNSAFE_CLASS_NAME, (Object)unsafePropName);
            return new UnsupportedOperationException(msg);
        }
        return null;
    }

    static int arrayIndexScale(Class<?> arrayClass) {
        try {
            return UNSAFE_ARRAY_INDEX_SCALE_HANDLE.invokeExact(arrayClass);
        }
        catch (Throwable cause) {
            SunMiscUnsafeAccess.rethrowIfPossible(cause);
            throw new IllegalStateException(cause);
        }
    }

    static int arrayBaseOffset(Class<?> arrayClass) {
        try {
            return UNSAFE_ARRAY_BASE_OFFSET_HANDLE.invokeExact(arrayClass);
        }
        catch (Throwable cause) {
            SunMiscUnsafeAccess.rethrowIfPossible(cause);
            throw new IllegalStateException(cause);
        }
    }

    static void storeFence() {
        try {
            UNSAFE_STORE_FENCE_HANDLE.invokeExact();
        }
        catch (Throwable cause) {
            SunMiscUnsafeAccess.rethrowIfPossible(cause);
            throw new IllegalStateException(cause);
        }
    }

    static long objectFieldOffset(Field field) {
        try {
            return UNSAFE_OBJECT_FIELD_OFFSET_HANDLE.invokeExact(field);
        }
        catch (Throwable cause) {
            SunMiscUnsafeAccess.rethrowIfPossible(cause);
            throw new IllegalStateException(cause);
        }
    }

    static long staticFieldOffset(Field f) {
        try {
            return UNSAFE_STATIC_FIELD_OFFSET_HANDLE.invokeExact(f);
        }
        catch (Throwable cause) {
            SunMiscUnsafeAccess.rethrowIfPossible(cause);
            throw new IllegalStateException(cause);
        }
    }

    static Object staticFieldBase(Field f) {
        try {
            return UNSAFE_STATIC_FIELD_BASE_HANDLE.invokeExact(f);
        }
        catch (Throwable cause) {
            SunMiscUnsafeAccess.rethrowIfPossible(cause);
            throw new IllegalStateException(cause);
        }
    }

    static boolean getBoolean(Object o, long offset) {
        try {
            return UNSAFE_GET_BOOLEAN_WITH_OBJECT_HANDLE.invokeExact(o, offset);
        }
        catch (Throwable cause) {
            SunMiscUnsafeAccess.rethrowIfPossible(cause);
            throw new IllegalStateException(cause);
        }
    }

    static Object getObject(Object object, long fieldOffset) {
        try {
            return UNSAFE_GET_OBJECT_WITH_OBJECT_HANDLE.invokeExact(object, fieldOffset);
        }
        catch (Throwable cause) {
            SunMiscUnsafeAccess.rethrowIfPossible(cause);
            throw new IllegalStateException(cause);
        }
    }

    static long getLong(Object object, long fieldOffset) {
        try {
            return UNSAFE_GET_LONG_WITH_OBJECT_HANDLE.invokeExact(object, fieldOffset);
        }
        catch (Throwable cause) {
            SunMiscUnsafeAccess.rethrowIfPossible(cause);
            throw new IllegalStateException(cause);
        }
    }

    static byte getByte(long address) {
        try {
            return UNSAFE_GET_BYTE_WITH_LONG_HANDLE.invokeExact(address);
        }
        catch (Throwable cause) {
            SunMiscUnsafeAccess.rethrowIfPossible(cause);
            throw new IllegalStateException(cause);
        }
    }

    static short getShort(long address) {
        try {
            return UNSAFE_GET_SHORT_WITH_LONG_HANDLE.invokeExact(address);
        }
        catch (Throwable cause) {
            SunMiscUnsafeAccess.rethrowIfPossible(cause);
            throw new IllegalStateException(cause);
        }
    }

    static int getInt(long address) {
        try {
            return UNSAFE_GET_INT_WITH_LONG_HANDLE.invokeExact(address);
        }
        catch (Throwable cause) {
            SunMiscUnsafeAccess.rethrowIfPossible(cause);
            throw new IllegalStateException(cause);
        }
    }

    static long getLong(long address) {
        try {
            return UNSAFE_GET_LONG_WITH_LONG_HANDLE.invokeExact(address);
        }
        catch (Throwable cause) {
            SunMiscUnsafeAccess.rethrowIfPossible(cause);
            throw new IllegalStateException(cause);
        }
    }

    static byte getByte(Object o, long offset) {
        try {
            return UNSAFE_GET_BYTE_WITH_OBJECT_HANDLE.invokeExact(o, offset);
        }
        catch (Throwable cause) {
            SunMiscUnsafeAccess.rethrowIfPossible(cause);
            throw new IllegalStateException(cause);
        }
    }

    static short getShort(Object o, long offset) {
        try {
            return UNSAFE_GET_SHORT_WITH_OBJECT_HANDLE.invokeExact(o, offset);
        }
        catch (Throwable cause) {
            SunMiscUnsafeAccess.rethrowIfPossible(cause);
            throw new IllegalStateException(cause);
        }
    }

    static char getChar(Object o, long offset) {
        try {
            return UNSAFE_GET_CHAR_WITH_OBJECT_HANDLE.invokeExact(o, offset);
        }
        catch (Throwable cause) {
            SunMiscUnsafeAccess.rethrowIfPossible(cause);
            throw new IllegalStateException(cause);
        }
    }

    static int getInt(Object o, long offset) {
        try {
            return UNSAFE_GET_INT_WITH_OBJECT_HANDLE.invokeExact(o, offset);
        }
        catch (Throwable cause) {
            SunMiscUnsafeAccess.rethrowIfPossible(cause);
            throw new IllegalStateException(cause);
        }
    }

    static int getIntVolatile(Object o, long address) {
        try {
            return UNSAFE_GET_INT_VOLATILE_WITH_OBJECT_HANDLE.invokeExact(o, address);
        }
        catch (Throwable cause) {
            SunMiscUnsafeAccess.rethrowIfPossible(cause);
            throw new IllegalStateException(cause);
        }
    }

    static void putIntOrdered(Object o, long address, int newValue) {
        try {
            UNSAFE_PUT_ORDERED_INT_WITH_OBJECT_HANDLE.invokeExact(o, address, newValue);
        }
        catch (Throwable cause) {
            SunMiscUnsafeAccess.rethrowIfPossible(cause);
            throw new IllegalStateException(cause);
        }
    }

    static void putByte(long address, byte value) {
        try {
            UNSAFE_PUT_BYTE_WITH_LONG_HANDLE.invokeExact(address, value);
        }
        catch (Throwable cause) {
            SunMiscUnsafeAccess.rethrowIfPossible(cause);
            throw new IllegalStateException(cause);
        }
    }

    static void putShort(long address, short value) {
        try {
            UNSAFE_PUT_SHORT_WITH_LONG_HANDLE.invokeExact(address, value);
        }
        catch (Throwable cause) {
            SunMiscUnsafeAccess.rethrowIfPossible(cause);
            throw new IllegalStateException(cause);
        }
    }

    static void putInt(long address, int value) {
        try {
            UNSAFE_PUT_INT_WITH_LONG_HANDLE.invokeExact(address, value);
        }
        catch (Throwable cause) {
            SunMiscUnsafeAccess.rethrowIfPossible(cause);
            throw new IllegalStateException(cause);
        }
    }

    static void putLong(long address, long value) {
        try {
            UNSAFE_PUT_LONG_WITH_LONG_HANDLE.invokeExact(address, value);
        }
        catch (Throwable cause) {
            SunMiscUnsafeAccess.rethrowIfPossible(cause);
            throw new IllegalStateException(cause);
        }
    }

    static void putByte(Object o, long offset, byte value) {
        try {
            UNSAFE_PUT_BYTE_WITH_OBJECT_HANDLE.invokeExact(o, offset, value);
        }
        catch (Throwable cause) {
            SunMiscUnsafeAccess.rethrowIfPossible(cause);
            throw new IllegalStateException(cause);
        }
    }

    static void putShort(Object o, long offset, short value) {
        try {
            UNSAFE_PUT_SHORT_WITH_OBJECT_HANDLE.invokeExact(o, offset, value);
        }
        catch (Throwable cause) {
            SunMiscUnsafeAccess.rethrowIfPossible(cause);
            throw new IllegalStateException(cause);
        }
    }

    static void putInt(Object o, long offset, int value) {
        try {
            UNSAFE_PUT_INT_WITH_OBJECT_HANDLE.invokeExact(o, offset, value);
        }
        catch (Throwable cause) {
            SunMiscUnsafeAccess.rethrowIfPossible(cause);
            throw new IllegalStateException(cause);
        }
    }

    static void putLong(Object o, long offset, long value) {
        try {
            UNSAFE_PUT_LONG_WITH_OBJECT_HANDLE.invokeExact(o, offset, value);
        }
        catch (Throwable cause) {
            SunMiscUnsafeAccess.rethrowIfPossible(cause);
            throw new IllegalStateException(cause);
        }
    }

    static void putObject(Object o, long offset, Object value) {
        try {
            UNSAFE_PUT_OBJECT_WITH_OBJECT_HANDLE.invokeExact(o, offset, value);
        }
        catch (Throwable cause) {
            SunMiscUnsafeAccess.rethrowIfPossible(cause);
            throw new IllegalStateException(cause);
        }
    }

    static void copyMemory(Object srcBase, long srcOffset, Object destBase, long destOffset, long bytes) {
        try {
            UNSAFE_COPY_MEMORY_WITH_OBJECT_HANDLE.invokeExact(srcBase, srcOffset, destBase, destOffset, bytes);
        }
        catch (Throwable cause) {
            SunMiscUnsafeAccess.rethrowIfPossible(cause);
            throw new IllegalStateException(cause);
        }
    }

    static void copyMemory(long srcAddress, long destAddress, long bytes) {
        try {
            UNSAFE_COPY_MEMORY_WITH_LONG_HANDLE.invokeExact(srcAddress, destAddress, bytes);
        }
        catch (Throwable cause) {
            SunMiscUnsafeAccess.rethrowIfPossible(cause);
            throw new IllegalStateException(cause);
        }
    }

    static void setMemory(long address, long bytes, byte value) {
        try {
            UNSAFE_SET_MEMORY_WITH_LONG_HANDLE.invokeExact(address, bytes, value);
        }
        catch (Throwable cause) {
            SunMiscUnsafeAccess.rethrowIfPossible(cause);
            throw new IllegalStateException(cause);
        }
    }

    static void setMemory(Object o, long offset, long bytes, byte value) {
        try {
            UNSAFE_SET_MEMORY_WITH_OBJECT_HANDLE.invokeExact(o, offset, bytes, value);
        }
        catch (Throwable cause) {
            SunMiscUnsafeAccess.rethrowIfPossible(cause);
            throw new IllegalStateException(cause);
        }
    }

    static int addressSize() {
        try {
            return UNSAFE_ADDRESS_SIZE_HANDLE.invokeExact();
        }
        catch (Throwable cause) {
            SunMiscUnsafeAccess.rethrowIfPossible(cause);
            throw new IllegalStateException(cause);
        }
    }

    static long allocateMemory(long size) {
        try {
            return UNSAFE_ALLOCATE_MEMORY_HANDLE.invokeExact(size);
        }
        catch (Throwable cause) {
            SunMiscUnsafeAccess.rethrowIfPossible(cause);
            throw new IllegalStateException(cause);
        }
    }

    static void freeMemory(long address) {
        try {
            UNSAFE_FREE_MEMORY_HANDLE.invokeExact(address);
        }
        catch (Throwable cause) {
            SunMiscUnsafeAccess.rethrowIfPossible(cause);
            throw new IllegalStateException(cause);
        }
    }

    static long reallocateMemory(long address, long newSize) {
        try {
            return UNSAFE_REALLOCATE_MEMORY_HANDLE.invokeExact(address, newSize);
        }
        catch (Throwable cause) {
            SunMiscUnsafeAccess.rethrowIfPossible(cause);
            throw new IllegalStateException(cause);
        }
    }

    private static void rethrowIfPossible(Throwable cause) {
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
    }

    static boolean isAvailabile() {
        return UNSAFE_UNAVAILABILITY_CAUSE == null && UNSAFE != null;
    }

    static Throwable unavailabilityCause() {
        return UNSAFE_UNAVAILABILITY_CAUSE;
    }

    private SunMiscUnsafeAccess() {
    }

    static {
        Object unsafe;
        logger = InternalLoggerFactory.getInstance(SunMiscUnsafeAccess.class);
        EXPLICIT_NO_UNSAFE_CAUSE = SunMiscUnsafeAccess.explicitNoUnsafeCause0();
        final MethodHandles.Lookup lookup = MethodHandles.lookup();
        Throwable unsafeUnavailabilityCause = null;
        MethodHandle allocateMemoryHandle = null;
        MethodHandle copyMemoryWithLongHandle = null;
        MethodHandle copyMemoryWithObjectHandle = null;
        MethodHandle objectFieldOffsetHandle = null;
        MethodHandle staticFieldOffsetHandle = null;
        MethodHandle staticFieldBaseHandle = null;
        MethodHandle arrayBaseOffsetHandle = null;
        MethodHandle arrayIndexScaleHandle = null;
        MethodHandle reallocateMemoryHandle = null;
        MethodHandle freeMemoryHandle = null;
        MethodHandle setMemoryWithLongHandle = null;
        MethodHandle setMemoryWithObjectHandle = null;
        MethodHandle getBooleanWithObjectHandle = null;
        MethodHandle getByteWithLongHandle = null;
        MethodHandle getByteWithObjectHandle = null;
        MethodHandle getCharWithObjectHandle = null;
        MethodHandle getShortWithLongHandle = null;
        MethodHandle getShortWithObjectHandle = null;
        MethodHandle getIntWithLongHandle = null;
        MethodHandle getIntWithObjectHandle = null;
        MethodHandle getIntVolatileWithObjectHandle = null;
        MethodHandle getLongWithLongHandle = null;
        MethodHandle getLongWithObjectHandle = null;
        MethodHandle getObjectWithObjectHandle = null;
        MethodHandle putByteWithLongHandle = null;
        MethodHandle putByteWithObjectHandle = null;
        MethodHandle putShortWithLongHandle = null;
        MethodHandle putShortWithObjectHandle = null;
        MethodHandle putIntWithLongHandle = null;
        MethodHandle putIntWithObjectHandle = null;
        MethodHandle putOrderedIntWithObjectHandle = null;
        MethodHandle putLongWithLongHandle = null;
        MethodHandle putLongWithObjectHandle = null;
        MethodHandle putObjectWithObjectHandle = null;
        MethodHandle addressSizeHandle = null;
        MethodHandle storeFenceHandle = null;
        unsafeUnavailabilityCause = EXPLICIT_NO_UNSAFE_CAUSE;
        if (unsafeUnavailabilityCause != null) {
            unsafe = null;
        } else {
            Object maybeUnsafe = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        Class<?> unsafeClass = Class.forName(SunMiscUnsafeAccess.SUN_MISC_UNSAFE_CLASS_NAME);
                        Field unsafeField = unsafeClass.getDeclaredField("theUnsafe");
                        Throwable cause = ReflectionUtil.trySetAccessible(unsafeField, false);
                        if (cause != null) {
                            return cause;
                        }
                        return unsafeField.get(null);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | SecurityException e) {
                        return e;
                    }
                    catch (NoClassDefFoundError e) {
                        return e;
                    }
                }
            });
            if (maybeUnsafe instanceof Throwable) {
                unsafe = null;
                unsafeUnavailabilityCause = (Throwable)maybeUnsafe;
                if (logger.isTraceEnabled()) {
                    logger.debug("{}: unavailable", (Object)SUN_MISC_UNSAFE_CLASS_NAME, maybeUnsafe);
                } else {
                    logger.debug("{}.theUnsafe: unavailable: {}", (Object)SUN_MISC_UNSAFE_CLASS_NAME, (Object)unsafeUnavailabilityCause.getMessage());
                }
            } else {
                unsafe = maybeUnsafe;
                logger.debug("sun.misc.Unsafe.theUnsafe: available");
            }
            if (unsafe != null) {
                final Object finalUnsafe = unsafe;
                Object maybeException = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            Class<?> cls = finalUnsafe.getClass();
                            ArrayList<MethodHandle> methodHandles = new ArrayList<MethodHandle>();
                            MethodHandle allocateMemoryHandle = lookup.findVirtual(cls, "allocateMemory", MethodType.methodType(Long.TYPE, Long.TYPE)).bindTo(finalUnsafe);
                            methodHandles.add(allocateMemoryHandle);
                            methodHandles.add(lookup.findVirtual(cls, "copyMemory", MethodType.methodType(Void.TYPE, Long.TYPE, Long.TYPE, Long.TYPE)).bindTo(finalUnsafe));
                            methodHandles.add(lookup.findVirtual(cls, "copyMemory", MethodType.methodType(Void.TYPE, Object.class, Long.TYPE, Object.class, Long.TYPE, Long.TYPE)).bindTo(finalUnsafe));
                            methodHandles.add(lookup.findVirtual(cls, "objectFieldOffset", MethodType.methodType(Long.TYPE, Field.class)).bindTo(finalUnsafe));
                            methodHandles.add(lookup.findVirtual(cls, "staticFieldOffset", MethodType.methodType(Long.TYPE, Field.class)).bindTo(finalUnsafe));
                            methodHandles.add(lookup.findVirtual(cls, "staticFieldBase", MethodType.methodType(Object.class, Field.class)).bindTo(finalUnsafe));
                            methodHandles.add(lookup.findVirtual(cls, "arrayBaseOffset", MethodType.methodType(Integer.TYPE, Class.class)).bindTo(finalUnsafe));
                            methodHandles.add(lookup.findVirtual(cls, "arrayIndexScale", MethodType.methodType(Integer.TYPE, Class.class)).bindTo(finalUnsafe));
                            methodHandles.add(lookup.findVirtual(cls, "reallocateMemory", MethodType.methodType(Long.TYPE, Long.TYPE, Long.TYPE)).bindTo(finalUnsafe));
                            MethodHandle freeMemoryHandle = lookup.findVirtual(cls, "freeMemory", MethodType.methodType(Void.TYPE, Long.TYPE)).bindTo(finalUnsafe);
                            methodHandles.add(freeMemoryHandle);
                            methodHandles.add(lookup.findVirtual(cls, "setMemory", MethodType.methodType(Void.TYPE, Long.TYPE, Long.TYPE, Byte.TYPE)).bindTo(finalUnsafe));
                            methodHandles.add(lookup.findVirtual(cls, "setMemory", MethodType.methodType(Void.TYPE, Object.class, Long.TYPE, Long.TYPE, Byte.TYPE)).bindTo(finalUnsafe));
                            methodHandles.add(lookup.findVirtual(cls, "getBoolean", MethodType.methodType(Boolean.TYPE, Object.class, Long.TYPE)).bindTo(finalUnsafe));
                            methodHandles.add(lookup.findVirtual(cls, "getByte", MethodType.methodType(Byte.TYPE, Long.TYPE)).bindTo(finalUnsafe));
                            methodHandles.add(lookup.findVirtual(cls, "getByte", MethodType.methodType(Byte.TYPE, Object.class, Long.TYPE)).bindTo(finalUnsafe));
                            methodHandles.add(lookup.findVirtual(cls, "getChar", MethodType.methodType(Character.TYPE, Object.class, Long.TYPE)).bindTo(finalUnsafe));
                            methodHandles.add(lookup.findVirtual(cls, "getShort", MethodType.methodType(Short.TYPE, Long.TYPE)).bindTo(finalUnsafe));
                            methodHandles.add(lookup.findVirtual(cls, "getShort", MethodType.methodType(Short.TYPE, Object.class, Long.TYPE)).bindTo(finalUnsafe));
                            methodHandles.add(lookup.findVirtual(cls, "getInt", MethodType.methodType(Integer.TYPE, Long.TYPE)).bindTo(finalUnsafe));
                            methodHandles.add(lookup.findVirtual(cls, "getInt", MethodType.methodType(Integer.TYPE, Object.class, Long.TYPE)).bindTo(finalUnsafe));
                            methodHandles.add(lookup.findVirtual(cls, "getIntVolatile", MethodType.methodType(Integer.TYPE, Object.class, Long.TYPE)).bindTo(finalUnsafe));
                            methodHandles.add(lookup.findVirtual(cls, "getLong", MethodType.methodType(Long.TYPE, Long.TYPE)).bindTo(finalUnsafe));
                            methodHandles.add(lookup.findVirtual(cls, "getLong", MethodType.methodType(Long.TYPE, Object.class, Long.TYPE)).bindTo(finalUnsafe));
                            methodHandles.add(lookup.findVirtual(cls, "getObject", MethodType.methodType(Object.class, Object.class, Long.TYPE)).bindTo(finalUnsafe));
                            methodHandles.add(lookup.findVirtual(cls, "putByte", MethodType.methodType(Void.TYPE, Long.TYPE, Byte.TYPE)).bindTo(finalUnsafe));
                            methodHandles.add(lookup.findVirtual(cls, "putByte", MethodType.methodType(Void.TYPE, Object.class, Long.TYPE, Byte.TYPE)).bindTo(finalUnsafe));
                            methodHandles.add(lookup.findVirtual(cls, "putShort", MethodType.methodType(Void.TYPE, Long.TYPE, Short.TYPE)).bindTo(finalUnsafe));
                            methodHandles.add(lookup.findVirtual(cls, "putShort", MethodType.methodType(Void.TYPE, Object.class, Long.TYPE, Short.TYPE)).bindTo(finalUnsafe));
                            methodHandles.add(lookup.findVirtual(cls, "putInt", MethodType.methodType(Void.TYPE, Long.TYPE, Integer.TYPE)).bindTo(finalUnsafe));
                            methodHandles.add(lookup.findVirtual(cls, "putInt", MethodType.methodType(Void.TYPE, Object.class, Long.TYPE, Integer.TYPE)).bindTo(finalUnsafe));
                            methodHandles.add(lookup.findVirtual(cls, "putOrderedInt", MethodType.methodType(Void.TYPE, Object.class, Long.TYPE, Integer.TYPE)).bindTo(finalUnsafe));
                            MethodHandle putLongHandle = lookup.findVirtual(cls, "putLong", MethodType.methodType(Void.TYPE, Long.TYPE, Long.TYPE)).bindTo(finalUnsafe);
                            methodHandles.add(putLongHandle);
                            methodHandles.add(lookup.findVirtual(cls, "putLong", MethodType.methodType(Void.TYPE, Object.class, Long.TYPE, Long.TYPE)).bindTo(finalUnsafe));
                            methodHandles.add(lookup.findVirtual(cls, "putObject", MethodType.methodType(Void.TYPE, Object.class, Long.TYPE, Object.class)).bindTo(finalUnsafe));
                            methodHandles.add(lookup.findVirtual(cls, "addressSize", MethodType.methodType(Integer.TYPE)).bindTo(finalUnsafe));
                            methodHandles.add(lookup.findVirtual(cls, "storeFence", MethodType.methodType(Void.TYPE)).bindTo(finalUnsafe));
                            long address = allocateMemoryHandle.invokeExact(8L);
                            putLongHandle.invokeExact(address, 42L);
                            freeMemoryHandle.invokeExact(address);
                            return methodHandles;
                        }
                        catch (Throwable cause) {
                            return cause;
                        }
                    }
                });
                if (maybeException instanceof Throwable) {
                    unsafe = null;
                    unsafeUnavailabilityCause = (Throwable)maybeException;
                    if (logger.isTraceEnabled()) {
                        logger.debug("{} method unavailable:", (Object)SUN_MISC_UNSAFE_CLASS_NAME, (Object)unsafeUnavailabilityCause);
                    } else {
                        logger.debug("{} method unavailable: {}", (Object)SUN_MISC_UNSAFE_CLASS_NAME, (Object)((Throwable)maybeException).getMessage());
                    }
                } else {
                    logger.debug("{} base methods: all available", (Object)SUN_MISC_UNSAFE_CLASS_NAME);
                    List handles = (List)maybeException;
                    int idx = 0;
                    allocateMemoryHandle = (MethodHandle)handles.get(idx++);
                    copyMemoryWithLongHandle = (MethodHandle)handles.get(idx++);
                    copyMemoryWithObjectHandle = (MethodHandle)handles.get(idx++);
                    objectFieldOffsetHandle = (MethodHandle)handles.get(idx++);
                    staticFieldOffsetHandle = (MethodHandle)handles.get(idx++);
                    staticFieldBaseHandle = (MethodHandle)handles.get(idx++);
                    arrayBaseOffsetHandle = (MethodHandle)handles.get(idx++);
                    arrayIndexScaleHandle = (MethodHandle)handles.get(idx++);
                    reallocateMemoryHandle = (MethodHandle)handles.get(idx++);
                    freeMemoryHandle = (MethodHandle)handles.get(idx++);
                    setMemoryWithLongHandle = (MethodHandle)handles.get(idx++);
                    setMemoryWithObjectHandle = (MethodHandle)handles.get(idx++);
                    getBooleanWithObjectHandle = (MethodHandle)handles.get(idx++);
                    getByteWithLongHandle = (MethodHandle)handles.get(idx++);
                    getByteWithObjectHandle = (MethodHandle)handles.get(idx++);
                    getCharWithObjectHandle = (MethodHandle)handles.get(idx++);
                    getShortWithLongHandle = (MethodHandle)handles.get(idx++);
                    getShortWithObjectHandle = (MethodHandle)handles.get(idx++);
                    getIntWithLongHandle = (MethodHandle)handles.get(idx++);
                    getIntWithObjectHandle = (MethodHandle)handles.get(idx++);
                    getIntVolatileWithObjectHandle = (MethodHandle)handles.get(idx++);
                    getLongWithLongHandle = (MethodHandle)handles.get(idx++);
                    getLongWithObjectHandle = (MethodHandle)handles.get(idx++);
                    getObjectWithObjectHandle = (MethodHandle)handles.get(idx++);
                    putByteWithLongHandle = (MethodHandle)handles.get(idx++);
                    putByteWithObjectHandle = (MethodHandle)handles.get(idx++);
                    putShortWithLongHandle = (MethodHandle)handles.get(idx++);
                    putShortWithObjectHandle = (MethodHandle)handles.get(idx++);
                    putIntWithLongHandle = (MethodHandle)handles.get(idx++);
                    putIntWithObjectHandle = (MethodHandle)handles.get(idx++);
                    putOrderedIntWithObjectHandle = (MethodHandle)handles.get(idx++);
                    putLongWithLongHandle = (MethodHandle)handles.get(idx++);
                    putLongWithObjectHandle = (MethodHandle)handles.get(idx++);
                    putObjectWithObjectHandle = (MethodHandle)handles.get(idx++);
                    addressSizeHandle = (MethodHandle)handles.get(idx++);
                    storeFenceHandle = (MethodHandle)handles.get(idx);
                }
            }
        }
        UNSAFE_ALLOCATE_MEMORY_HANDLE = allocateMemoryHandle;
        UNSAFE_COPY_MEMORY_WITH_LONG_HANDLE = copyMemoryWithLongHandle;
        UNSAFE_COPY_MEMORY_WITH_OBJECT_HANDLE = copyMemoryWithObjectHandle;
        UNSAFE_OBJECT_FIELD_OFFSET_HANDLE = objectFieldOffsetHandle;
        UNSAFE_REALLOCATE_MEMORY_HANDLE = reallocateMemoryHandle;
        UNSAFE_FREE_MEMORY_HANDLE = freeMemoryHandle;
        UNSAFE_SET_MEMORY_WITH_LONG_HANDLE = setMemoryWithLongHandle;
        UNSAFE_SET_MEMORY_WITH_OBJECT_HANDLE = setMemoryWithObjectHandle;
        UNSAFE_GET_BYTE_WITH_LONG_HANDLE = getByteWithLongHandle;
        UNSAFE_GET_BYTE_WITH_OBJECT_HANDLE = getByteWithObjectHandle;
        UNSAFE_GET_CHAR_WITH_OBJECT_HANDLE = getCharWithObjectHandle;
        UNSAFE_GET_SHORT_WITH_LONG_HANDLE = getShortWithLongHandle;
        UNSAFE_GET_SHORT_WITH_OBJECT_HANDLE = getShortWithObjectHandle;
        UNSAFE_GET_INT_WITH_LONG_HANDLE = getIntWithLongHandle;
        UNSAFE_GET_INT_WITH_OBJECT_HANDLE = getIntWithObjectHandle;
        UNSAFE_GET_INT_VOLATILE_WITH_OBJECT_HANDLE = getIntVolatileWithObjectHandle;
        UNSAFE_GET_LONG_WITH_LONG_HANDLE = getLongWithLongHandle;
        UNSAFE_GET_LONG_WITH_OBJECT_HANDLE = getLongWithObjectHandle;
        UNSAFE_GET_OBJECT_WITH_OBJECT_HANDLE = getObjectWithObjectHandle;
        UNSAFE_PUT_BYTE_WITH_LONG_HANDLE = putByteWithLongHandle;
        UNSAFE_PUT_BYTE_WITH_OBJECT_HANDLE = putByteWithObjectHandle;
        UNSAFE_PUT_SHORT_WITH_LONG_HANDLE = putShortWithLongHandle;
        UNSAFE_PUT_SHORT_WITH_OBJECT_HANDLE = putShortWithObjectHandle;
        UNSAFE_PUT_INT_WITH_LONG_HANDLE = putIntWithLongHandle;
        UNSAFE_PUT_INT_WITH_OBJECT_HANDLE = putIntWithObjectHandle;
        UNSAFE_PUT_ORDERED_INT_WITH_OBJECT_HANDLE = putOrderedIntWithObjectHandle;
        UNSAFE_PUT_LONG_WITH_LONG_HANDLE = putLongWithLongHandle;
        UNSAFE_PUT_LONG_WITH_OBJECT_HANDLE = putLongWithObjectHandle;
        UNSAFE_PUT_OBJECT_WITH_OBJECT_HANDLE = putObjectWithObjectHandle;
        UNSAFE_ADDRESS_SIZE_HANDLE = addressSizeHandle;
        UNSAFE_STORE_FENCE_HANDLE = storeFenceHandle;
        UNSAFE_ARRAY_BASE_OFFSET_HANDLE = arrayBaseOffsetHandle;
        UNSAFE_ARRAY_INDEX_SCALE_HANDLE = arrayIndexScaleHandle;
        UNSAFE_STATIC_FIELD_OFFSET_HANDLE = staticFieldOffsetHandle;
        UNSAFE_STATIC_FIELD_BASE_HANDLE = staticFieldBaseHandle;
        UNSAFE_GET_BOOLEAN_WITH_OBJECT_HANDLE = getBooleanWithObjectHandle;
        UNSAFE_UNAVAILABILITY_CAUSE = unsafeUnavailabilityCause;
        UNSAFE = unsafe;
    }
}

