/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.discard;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DiscardClientHandler
extends SimpleChannelInboundHandler<Object> {
    private static final Logger logger = Logger.getLogger(DiscardClientHandler.class.getName());
    private final int messageSize;
    private ByteBuf content;
    private ChannelHandlerContext ctx;
    long counter;
    private final ChannelFutureListener trafficGenerator = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isSuccess()) {
                DiscardClientHandler.this.generateTraffic();
            }
        }
    };

    public DiscardClientHandler(int messageSize) {
        if (messageSize <= 0) {
            throw new IllegalArgumentException("messageSize: " + messageSize);
        }
        this.messageSize = messageSize;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
        this.content = ctx.alloc().directBuffer(this.messageSize).writeZero(this.messageSize);
        this.generateTraffic();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.content.release();
    }

    public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.log(Level.WARNING, "Unexpected exception from downstream.", cause);
        ctx.close();
    }

    private void generateTraffic() {
        this.ctx.writeAndFlush((Object)this.content.duplicate().retain()).addListener((GenericFutureListener)this.trafficGenerator);
    }
}

