/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.upload;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.example.http.upload.HttpUploadClientHandler;
import io.netty.example.securechat.SecureChatSslContextFactory;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import javax.net.ssl.SSLEngine;

public class HttpUploadClientIntializer
extends ChannelInitializer<SocketChannel> {
    private final boolean ssl;

    public HttpUploadClientIntializer(boolean ssl) {
        this.ssl = ssl;
    }

    public void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        if (this.ssl) {
            SSLEngine engine = SecureChatSslContextFactory.getClientContext().createSSLEngine();
            engine.setUseClientMode(true);
            pipeline.addLast("ssl", (ChannelHandler)new SslHandler(engine));
        }
        pipeline.addLast("codec", (ChannelHandler)new HttpClientCodec());
        pipeline.addLast("inflater", (ChannelHandler)new HttpContentDecompressor());
        pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        pipeline.addLast("handler", (ChannelHandler)new HttpUploadClientHandler());
    }
}

