/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.spdy.client;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.spdy.SpdyFrame;
import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public class SpdyFrameLogger
extends ChannelDuplexHandler {
    protected final InternalLogger logger;
    private final InternalLogLevel level;

    public SpdyFrameLogger(InternalLogLevel level) {
        if (level == null) {
            throw new NullPointerException("level");
        }
        this.logger = InternalLoggerFactory.getInstance(((Object)((Object)this)).getClass());
        this.level = level;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (SpdyFrameLogger.acceptMessage(msg)) {
            this.log((SpdyFrame)msg, Direction.INBOUND);
        }
        ctx.fireChannelRead(msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (SpdyFrameLogger.acceptMessage(msg)) {
            this.log((SpdyFrame)msg, Direction.OUTBOUND);
        }
        ctx.write(msg, promise);
    }

    private static boolean acceptMessage(Object msg) {
        return msg instanceof SpdyFrame;
    }

    private void log(SpdyFrame msg, Direction d) {
        if (this.logger.isEnabled(this.level)) {
            StringBuilder b = new StringBuilder("\n----------------").append(d.name()).append("--------------------\n");
            b.append(msg);
            b.append("\n------------------------------------");
            this.logger.log(this.level, b.toString());
        }
    }

    private static enum Direction {
        INBOUND,
        OUTBOUND;

    }
}

