/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.factorial;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.example.factorial.FactorialClientHandler;
import io.netty.example.factorial.FactorialClientInitializer;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public final class FactorialClient {
    static final boolean SSL = System.getProperty("ssl") != null;
    static final String HOST = System.getProperty("host", "127.0.0.1");
    static final int PORT = Integer.parseInt(System.getProperty("port", "8322"));
    static final int COUNT = Integer.parseInt(System.getProperty("count", "1000"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        SslContext sslCtx = SSL ? SslContext.newClientContext((TrustManagerFactory)InsecureTrustManagerFactory.INSTANCE) : null;
        NioEventLoopGroup group = new NioEventLoopGroup();
        try {
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)b.group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new FactorialClientInitializer(sslCtx));
            ChannelFuture f = b.connect(HOST, PORT).sync();
            FactorialClientHandler handler = (FactorialClientHandler)f.channel().pipeline().last();
            System.err.format("Factorial of %,d is: %,d", COUNT, handler.getFactorial());
        }
        finally {
            group.shutdownGracefully();
        }
    }
}

