/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.snoop;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderUtil;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.ServerCookieDecoder;
import io.netty.handler.codec.http.ServerCookieEncoder;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HttpSnoopServerHandler
extends SimpleChannelInboundHandler<Object> {
    private HttpRequest request;
    private final StringBuilder buf = new StringBuilder();

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpRequest) {
            QueryStringDecoder queryStringDecoder;
            Map params;
            this.request = (HttpRequest)msg;
            HttpRequest request = this.request;
            if (HttpHeaderUtil.is100ContinueExpected((HttpMessage)request)) {
                HttpSnoopServerHandler.send100Continue(ctx);
            }
            this.buf.setLength(0);
            this.buf.append("WELCOME TO THE WILD WILD WEB SERVER\r\n");
            this.buf.append("===================================\r\n");
            this.buf.append("VERSION: ").append(request.protocolVersion()).append("\r\n");
            this.buf.append("HOSTNAME: ").append(request.headers().get((CharSequence)HttpHeaderNames.HOST, "unknown")).append("\r\n");
            this.buf.append("REQUEST_URI: ").append(request.uri()).append("\r\n\r\n");
            HttpHeaders headers = request.headers();
            if (!headers.isEmpty()) {
                for (Map.Entry h : headers) {
                    CharSequence key = (CharSequence)h.getKey();
                    CharSequence value = (CharSequence)h.getValue();
                    this.buf.append("HEADER: ").append(key).append(" = ").append(value).append("\r\n");
                }
                this.buf.append("\r\n");
            }
            if (!(params = (queryStringDecoder = new QueryStringDecoder(request.uri())).parameters()).isEmpty()) {
                for (Map.Entry p : params.entrySet()) {
                    String key = (String)p.getKey();
                    List vals = (List)p.getValue();
                    for (String val : vals) {
                        this.buf.append("PARAM: ").append(key).append(" = ").append(val).append("\r\n");
                    }
                }
                this.buf.append("\r\n");
            }
            HttpSnoopServerHandler.appendDecoderResult(this.buf, (HttpObject)request);
        }
        if (msg instanceof HttpContent) {
            HttpContent httpContent = (HttpContent)msg;
            ByteBuf content = httpContent.content();
            if (content.isReadable()) {
                this.buf.append("CONTENT: ");
                this.buf.append(content.toString(CharsetUtil.UTF_8));
                this.buf.append("\r\n");
                HttpSnoopServerHandler.appendDecoderResult(this.buf, (HttpObject)this.request);
            }
            if (msg instanceof LastHttpContent) {
                this.buf.append("END OF CONTENT\r\n");
                LastHttpContent trailer = (LastHttpContent)msg;
                if (!trailer.trailingHeaders().isEmpty()) {
                    this.buf.append("\r\n");
                    for (CharSequence name : trailer.trailingHeaders().names()) {
                        for (CharSequence value : trailer.trailingHeaders().getAll(name)) {
                            this.buf.append("TRAILING HEADER: ");
                            this.buf.append(name).append(" = ").append(value).append("\r\n");
                        }
                    }
                    this.buf.append("\r\n");
                }
                if (!this.writeResponse((HttpObject)trailer, ctx)) {
                    ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                }
            }
        }
    }

    private static void appendDecoderResult(StringBuilder buf, HttpObject o) {
        DecoderResult result = o.decoderResult();
        if (result.isSuccess()) {
            return;
        }
        buf.append(".. WITH DECODER FAILURE: ");
        buf.append(result.cause());
        buf.append("\r\n");
    }

    private boolean writeResponse(HttpObject currentObj, ChannelHandlerContext ctx) {
        String cookieString;
        boolean keepAlive = HttpHeaderUtil.isKeepAlive((HttpMessage)this.request);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, currentObj.decoderResult().isSuccess() ? HttpResponseStatus.OK : HttpResponseStatus.BAD_REQUEST, Unpooled.copiedBuffer((CharSequence)this.buf.toString(), (Charset)CharsetUtil.UTF_8));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain; charset=UTF-8");
        if (keepAlive) {
            response.headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, response.content().readableBytes());
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
        if ((cookieString = this.request.headers().get((CharSequence)HttpHeaderNames.COOKIE)) != null) {
            Set cookies = ServerCookieDecoder.decode((String)cookieString);
            if (!cookies.isEmpty()) {
                for (Cookie cookie : cookies) {
                    response.headers().add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)ServerCookieEncoder.encode((Cookie)cookie));
                }
            }
        } else {
            response.headers().add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)ServerCookieEncoder.encode((String)"key1", (String)"value1"));
            response.headers().add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)ServerCookieEncoder.encode((String)"key2", (String)"value2"));
        }
        ctx.write((Object)response);
        return keepAlive;
    }

    private static void send100Continue(ChannelHandlerContext ctx) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE);
        ctx.write((Object)response);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }
}

