/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.uptime;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.example.uptime.UptimeClientHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;

public final class UptimeClient {
    static final String HOST = System.getProperty("host", "127.0.0.1");
    static final int PORT = Integer.parseInt(System.getProperty("port", "8080"));
    static final int RECONNECT_DELAY = Integer.parseInt(System.getProperty("reconnectDelay", "5"));
    static final int READ_TIMEOUT = Integer.parseInt(System.getProperty("readTimeout", "10"));
    private static final UptimeClientHandler handler = new UptimeClientHandler();

    public static void main(String[] args) throws Exception {
        UptimeClient.configureBootstrap(new Bootstrap()).connect();
    }

    private static Bootstrap configureBootstrap(Bootstrap b) {
        return UptimeClient.configureBootstrap(b, (EventLoopGroup)new NioEventLoopGroup());
    }

    static Bootstrap configureBootstrap(Bootstrap b, EventLoopGroup g) {
        ((Bootstrap)((Bootstrap)b.group(g)).channel(NioSocketChannel.class)).remoteAddress(HOST, PORT).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(READ_TIMEOUT, 0, 0), handler});
            }
        });
        return b;
    }

    static void connect(Bootstrap b) {
        b.connect().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.cause() != null) {
                    handler.startTime = -1L;
                    handler.println("Failed to connect: " + future.cause());
                }
            }
        });
    }
}

