/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http2.client;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http2.HttpUtil;
import io.netty.util.CharsetUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class HttpResponseHandler
extends SimpleChannelInboundHandler<FullHttpResponse> {
    private SortedMap<Integer, ChannelPromise> streamidPromiseMap = new TreeMap<Integer, ChannelPromise>();

    public ChannelPromise put(int streamId, ChannelPromise promise) {
        return this.streamidPromiseMap.put(streamId, promise);
    }

    public void awaitResponses(long timeout, TimeUnit unit) {
        Iterator<Map.Entry<Integer, ChannelPromise>> itr = this.streamidPromiseMap.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<Integer, ChannelPromise> entry = itr.next();
            ChannelPromise promise = entry.getValue();
            if (!promise.awaitUninterruptibly(timeout, unit)) {
                throw new IllegalStateException("Timed out waiting for response on stream id " + entry.getKey());
            }
            if (!promise.isSuccess()) {
                throw new RuntimeException(promise.cause());
            }
            System.out.println("---Stream id: " + entry.getKey() + " received---");
            itr.remove();
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse msg) throws Exception {
        Integer streamId = msg.headers().getInt((CharSequence)HttpUtil.ExtensionHeaderNames.STREAM_ID.text());
        if (streamId == null) {
            System.err.println("HttpResponseHandler unexpected message received: " + msg);
            return;
        }
        ChannelPromise promise = (ChannelPromise)this.streamidPromiseMap.get(streamId);
        if (promise == null) {
            System.err.println("Message received for unknown stream id " + streamId);
        } else {
            ByteBuf content = msg.content();
            if (content.isReadable()) {
                int contentLength = content.readableBytes();
                byte[] arr = new byte[contentLength];
                content.readBytes(arr);
                System.out.println(new String(arr, 0, contentLength, CharsetUtil.UTF_8));
            }
            promise.setSuccess();
        }
    }
}

