/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http2.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameAdapter;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2InboundFrameLogger;
import io.netty.handler.codec.http2.Http2OutboundFrameLogger;
import io.netty.handler.logging.LogLevel;
import io.netty.util.AsciiString;
import io.netty.util.ByteString;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;

public class HelloWorldHttp2Handler
extends Http2ConnectionHandler {
    private static final Http2FrameLogger logger = new Http2FrameLogger(LogLevel.INFO, HelloWorldHttp2Handler.class);
    static final ByteBuf RESPONSE_BYTES = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.copiedBuffer((CharSequence)"Hello World", (Charset)CharsetUtil.UTF_8));

    public HelloWorldHttp2Handler() {
        this((Http2Connection)new DefaultHttp2Connection(true), (Http2FrameReader)new Http2InboundFrameLogger((Http2FrameReader)new DefaultHttp2FrameReader(), logger), (Http2FrameWriter)new Http2OutboundFrameLogger((Http2FrameWriter)new DefaultHttp2FrameWriter(), logger), new SimpleHttp2FrameListener());
    }

    private HelloWorldHttp2Handler(Http2Connection connection, Http2FrameReader frameReader, Http2FrameWriter frameWriter, SimpleHttp2FrameListener listener) {
        super(connection, frameReader, frameWriter, (Http2FrameListener)listener);
        listener.encoder(this.encoder());
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof HttpServerUpgradeHandler.UpgradeEvent) {
            Http2Headers headers = new DefaultHttp2Headers().status((ByteString)HttpResponseStatus.OK.codeAsText()).set((ByteString)new AsciiString((CharSequence)"Http-To-Http2-Upgrade"), (ByteString)new AsciiString((CharSequence)"true"));
            this.encoder().writeHeaders(ctx, 1, headers, 0, true, ctx.newPromise());
        }
        super.userEventTriggered(ctx, evt);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
        cause.printStackTrace();
        ctx.close();
    }

    private static class SimpleHttp2FrameListener
    extends Http2FrameAdapter {
        private Http2ConnectionEncoder encoder;

        private SimpleHttp2FrameListener() {
        }

        public void encoder(Http2ConnectionEncoder encoder) {
            this.encoder = encoder;
        }

        public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
            int processed = data.readableBytes() + padding;
            if (endOfStream) {
                this.sendResponse(ctx, streamId, data.retain());
            }
            return processed;
        }

        public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
            if (endStream) {
                this.sendResponse(ctx, streamId, RESPONSE_BYTES.duplicate());
            }
        }

        private void sendResponse(ChannelHandlerContext ctx, int streamId, ByteBuf payload) {
            Http2Headers headers = new DefaultHttp2Headers().status((ByteString)HttpResponseStatus.OK.codeAsText());
            this.encoder.writeHeaders(ctx, streamId, headers, 0, false, ctx.newPromise());
            this.encoder.writeData(ctx, streamId, payload, 0, true, ctx.newPromise());
            ctx.flush();
        }
    }
}

