/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http2.server;

import io.netty.channel.ChannelHandler;
import io.netty.example.http2.server.HelloWorldHttp1Handler;
import io.netty.example.http2.server.HelloWorldHttp2Handler;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2OrHttpChooser;
import javax.net.ssl.SSLEngine;

public class Http2OrHttpHandler
extends Http2OrHttpChooser {
    private static final int MAX_CONTENT_LENGTH = 102400;

    public Http2OrHttpHandler() {
        this(102400);
    }

    public Http2OrHttpHandler(int maxHttpContentLength) {
        super(maxHttpContentLength);
    }

    protected Http2OrHttpChooser.SelectedProtocol getProtocol(SSLEngine engine) {
        String[] protocol = engine.getSession().getProtocol().split(":");
        if (protocol != null && protocol.length > 1) {
            Http2OrHttpChooser.SelectedProtocol selectedProtocol = Http2OrHttpChooser.SelectedProtocol.protocol((String)protocol[1]);
            System.err.println("Selected Protocol is " + selectedProtocol);
            return selectedProtocol;
        }
        return Http2OrHttpChooser.SelectedProtocol.UNKNOWN;
    }

    protected ChannelHandler createHttp1RequestHandler() {
        return new HelloWorldHttp1Handler();
    }

    protected Http2ConnectionHandler createHttp2RequestHandler() {
        return new HelloWorldHttp2Handler();
    }
}

