/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.dns.tcp;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.dns.DefaultDnsQuery;
import io.netty.handler.codec.dns.DefaultDnsQuestion;
import io.netty.handler.codec.dns.DefaultDnsResponse;
import io.netty.handler.codec.dns.DnsOpCode;
import io.netty.handler.codec.dns.DnsQuery;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRawRecord;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.handler.codec.dns.DnsSection;
import io.netty.handler.codec.dns.TcpDnsQueryEncoder;
import io.netty.handler.codec.dns.TcpDnsResponseDecoder;
import io.netty.util.NetUtil;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public final class TcpDnsClient {
    private static final String QUERY_DOMAIN = "www.example.com";
    private static final int DNS_SERVER_PORT = 53;
    private static final String DNS_SERVER_HOST = "8.8.8.8";

    private TcpDnsClient() {
    }

    private static void handleQueryResp(DefaultDnsResponse msg) {
        if (msg.count(DnsSection.QUESTION) > 0) {
            DnsQuestion question = (DnsQuestion)msg.recordAt(DnsSection.QUESTION, 0);
            System.out.printf("name: %s%n", question.name());
        }
        int count = msg.count(DnsSection.ANSWER);
        for (int i = 0; i < count; ++i) {
            DnsRecord record = msg.recordAt(DnsSection.ANSWER, i);
            if (record.type() != DnsRecordType.A) continue;
            DnsRawRecord raw = (DnsRawRecord)record;
            System.out.println(NetUtil.bytesToIpAddress((byte[])ByteBufUtil.getBytes((ByteBuf)raw.content())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        NioEventLoopGroup group = new NioEventLoopGroup();
        try {
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)b.group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new ChannelHandler[]{new TcpDnsQueryEncoder()}).addLast(new ChannelHandler[]{new TcpDnsResponseDecoder()}).addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<DefaultDnsResponse>(){

                        protected void channelRead0(ChannelHandlerContext ctx, DefaultDnsResponse msg) {
                            try {
                                TcpDnsClient.handleQueryResp(msg);
                            }
                            finally {
                                ctx.close();
                            }
                        }
                    }});
                }
            });
            Channel ch = b.connect(DNS_SERVER_HOST, 53).sync().channel();
            int randomID = new Random().nextInt(59000) + 1000;
            DnsQuery query = new DefaultDnsQuery(randomID, DnsOpCode.QUERY).setRecord(DnsSection.QUESTION, (DnsRecord)new DefaultDnsQuestion(QUERY_DOMAIN, DnsRecordType.A));
            ch.writeAndFlush((Object)query).sync();
            boolean success = ch.closeFuture().await(10L, TimeUnit.SECONDS);
            if (!success) {
                System.err.println("dns query timeout!");
                ch.close().sync();
            }
        }
        finally {
            group.shutdownGracefully();
        }
    }
}

