/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.helloworld;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.GenericFutureListener;

public class HttpHelloWorldServerHandler
extends ChannelInboundHandlerAdapter {
    private static final byte[] CONTENT = new byte[]{72, 101, 108, 108, 111, 32, 87, 111, 114, 108, 100};
    private static final AsciiString CONTENT_TYPE = AsciiString.cached((String)"Content-Type");
    private static final AsciiString CONTENT_LENGTH = AsciiString.cached((String)"Content-Length");
    private static final AsciiString CONNECTION = AsciiString.cached((String)"Connection");
    private static final AsciiString KEEP_ALIVE = AsciiString.cached((String)"keep-alive");

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)msg;
            boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)req);
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])CONTENT));
            response.headers().set((CharSequence)CONTENT_TYPE, (Object)"text/plain");
            response.headers().setInt((CharSequence)CONTENT_LENGTH, response.content().readableBytes());
            if (!keepAlive) {
                ctx.write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            } else {
                response.headers().set((CharSequence)CONNECTION, (Object)KEEP_ALIVE);
                ctx.write((Object)response);
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }
}

