/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.memcache.binary;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.memcache.binary.DefaultBinaryMemcacheRequest;
import io.netty.handler.codec.memcache.binary.DefaultFullBinaryMemcacheRequest;
import io.netty.handler.codec.memcache.binary.FullBinaryMemcacheResponse;
import io.netty.util.CharsetUtil;

public class MemcacheClientHandler
extends ChannelHandlerAdapter {
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        String command = (String)msg;
        if (command.startsWith("get ")) {
            String key = command.substring("get ".length());
            DefaultBinaryMemcacheRequest req = new DefaultBinaryMemcacheRequest(key);
            req.setOpcode((byte)0);
            req.setKeyLength((short)key.length());
            req.setTotalBodyLength(key.length());
            ctx.write((Object)req, promise);
        } else if (command.startsWith("set ")) {
            String[] parts = command.split(" ", 3);
            if (parts.length < 3) {
                throw new IllegalArgumentException("Malformed Command: " + command);
            }
            String key = parts[1];
            String value = parts[2];
            ByteBuf content = Unpooled.wrappedBuffer((byte[])value.getBytes(CharsetUtil.UTF_8));
            ByteBuf extras = ctx.alloc().buffer(8);
            extras.writeZero(8);
            DefaultFullBinaryMemcacheRequest req = new DefaultFullBinaryMemcacheRequest(key, extras, content);
            req.setOpcode((byte)1);
            req.setKeyLength((short)key.length());
            req.setExtrasLength((byte)8);
            req.setTotalBodyLength(key.length() + 8 + value.length());
            ctx.write((Object)req, promise);
        } else {
            throw new IllegalStateException("Unknown Message: " + msg);
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        FullBinaryMemcacheResponse res = (FullBinaryMemcacheResponse)msg;
        System.out.println(res.content().toString(CharsetUtil.UTF_8));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }
}

