/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.telnet;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.util.Date;

@ChannelHandler.Sharable
public class TelnetServerHandler
extends SimpleChannelInboundHandler<String> {
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.write((Object)("Welcome to " + InetAddress.getLocalHost().getHostName() + "!\r\n"));
        ctx.write((Object)("It is " + new Date() + " now.\r\n"));
        ctx.flush();
    }

    public void messageReceived(ChannelHandlerContext ctx, String request) {
        String response;
        boolean close = false;
        if (request.isEmpty()) {
            response = "Please type something.\r\n";
        } else if ("bye".equals(request.toLowerCase())) {
            response = "Have a good day!\r\n";
            close = true;
        } else {
            response = "Did you say '" + request + "'?\r\n";
        }
        ChannelFuture future = ctx.write((Object)response);
        if (close) {
            future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }
}

