/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.udt.echo.bytes;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.udt.UdtChannel;
import io.netty.channel.udt.nio.NioUdtProvider;
import io.netty.example.udt.echo.bytes.ByteEchoClientHandler;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.DefaultExecutorServiceFactory;
import io.netty.util.concurrent.ExecutorServiceFactory;

public final class ByteEchoClient {
    static final String HOST = System.getProperty("host", "127.0.0.1");
    static final int PORT = Integer.parseInt(System.getProperty("port", "8007"));
    static final int SIZE = Integer.parseInt(System.getProperty("size", "256"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        DefaultExecutorServiceFactory connectFactory = new DefaultExecutorServiceFactory("connect");
        NioEventLoopGroup connectGroup = new NioEventLoopGroup(1, (ExecutorServiceFactory)connectFactory, NioUdtProvider.BYTE_PROVIDER);
        try {
            Bootstrap boot = new Bootstrap();
            ((Bootstrap)((Bootstrap)boot.group((EventLoopGroup)connectGroup)).channelFactory(NioUdtProvider.BYTE_CONNECTOR)).handler((ChannelHandler)new ChannelInitializer<UdtChannel>(){

                public void initChannel(UdtChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.INFO), new ByteEchoClientHandler()});
                }
            });
            ChannelFuture f = boot.connect(HOST, PORT).sync();
            f.channel().closeFuture().sync();
        }
        finally {
            connectGroup.shutdownGracefully();
        }
    }
}

