/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.proxy;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LineBasedFrameDecoder;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.HttpProxyServer;
import io.netty.handler.proxy.ProxyConnectException;
import io.netty.handler.proxy.ProxyConnectionEvent;
import io.netty.handler.proxy.ProxyHandler;
import io.netty.handler.proxy.ProxyServer;
import io.netty.handler.proxy.Socks4ProxyHandler;
import io.netty.handler.proxy.Socks4ProxyServer;
import io.netty.handler.proxy.Socks5ProxyHandler;
import io.netty.handler.proxy.Socks5ProxyServer;
import io.netty.handler.proxy.TestMode;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.NoopAddressResolverGroup;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.SocketUtils;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class ProxyHandlerTest {
    private static final InternalLogger logger;
    private static final InetSocketAddress DESTINATION;
    private static final InetSocketAddress BAD_DESTINATION;
    private static final String USERNAME = "testUser";
    private static final String PASSWORD = "testPassword";
    private static final String BAD_USERNAME = "badUser";
    private static final String BAD_PASSWORD = "badPassword";
    static final EventLoopGroup group;
    static final SslContext serverSslCtx;
    static final SslContext clientSslCtx;
    static final ProxyServer deadHttpProxy;
    static final ProxyServer interHttpProxy;
    static final ProxyServer anonHttpProxy;
    static final ProxyServer httpProxy;
    static final ProxyServer deadHttpsProxy;
    static final ProxyServer interHttpsProxy;
    static final ProxyServer anonHttpsProxy;
    static final ProxyServer httpsProxy;
    static final ProxyServer deadSocks4Proxy;
    static final ProxyServer interSocks4Proxy;
    static final ProxyServer anonSocks4Proxy;
    static final ProxyServer socks4Proxy;
    static final ProxyServer deadSocks5Proxy;
    static final ProxyServer interSocks5Proxy;
    static final ProxyServer anonSocks5Proxy;
    static final ProxyServer socks5Proxy;
    private static final Collection<ProxyServer> allProxies;
    private static final long reproducibleSeed = 0L;

    public static List<Object[]> testItems() {
        List<TestItem> items = Arrays.asList(new SuccessTestItem("Anonymous HTTP proxy: successful connection, AUTO_READ on", DESTINATION, true, new ChannelHandler[]{new HttpProxyHandler((SocketAddress)anonHttpProxy.address())}), new SuccessTestItem("Anonymous HTTP proxy: successful connection, AUTO_READ off", DESTINATION, false, new ChannelHandler[]{new HttpProxyHandler((SocketAddress)anonHttpProxy.address())}), new FailureTestItem("Anonymous HTTP proxy: rejected connection", BAD_DESTINATION, "status: 403", new ChannelHandler[]{new HttpProxyHandler((SocketAddress)anonHttpProxy.address())}), new FailureTestItem("HTTP proxy: rejected anonymous connection", DESTINATION, "status: 401", new ChannelHandler[]{new HttpProxyHandler((SocketAddress)httpProxy.address())}), new SuccessTestItem("HTTP proxy: successful connection, AUTO_READ on", DESTINATION, true, new ChannelHandler[]{new HttpProxyHandler((SocketAddress)httpProxy.address(), USERNAME, PASSWORD)}), new SuccessTestItem("HTTP proxy: successful connection, AUTO_READ off", DESTINATION, false, new ChannelHandler[]{new HttpProxyHandler((SocketAddress)httpProxy.address(), USERNAME, PASSWORD)}), new FailureTestItem("HTTP proxy: rejected connection", BAD_DESTINATION, "status: 403", new ChannelHandler[]{new HttpProxyHandler((SocketAddress)httpProxy.address(), USERNAME, PASSWORD)}), new FailureTestItem("HTTP proxy: authentication failure", DESTINATION, "status: 401", new ChannelHandler[]{new HttpProxyHandler((SocketAddress)httpProxy.address(), BAD_USERNAME, BAD_PASSWORD)}), new TimeoutTestItem("HTTP proxy: timeout", new ChannelHandler[]{new HttpProxyHandler((SocketAddress)deadHttpProxy.address())}), new SuccessTestItem("Anonymous HTTPS proxy: successful connection, AUTO_READ on", DESTINATION, true, new ChannelHandler[]{clientSslCtx.newHandler((ByteBufAllocator)PooledByteBufAllocator.DEFAULT), new HttpProxyHandler((SocketAddress)anonHttpsProxy.address())}), new SuccessTestItem("Anonymous HTTPS proxy: successful connection, AUTO_READ off", DESTINATION, false, new ChannelHandler[]{clientSslCtx.newHandler((ByteBufAllocator)PooledByteBufAllocator.DEFAULT), new HttpProxyHandler((SocketAddress)anonHttpsProxy.address())}), new FailureTestItem("Anonymous HTTPS proxy: rejected connection", BAD_DESTINATION, "status: 403", new ChannelHandler[]{clientSslCtx.newHandler((ByteBufAllocator)PooledByteBufAllocator.DEFAULT), new HttpProxyHandler((SocketAddress)anonHttpsProxy.address())}), new FailureTestItem("HTTPS proxy: rejected anonymous connection", DESTINATION, "status: 401", new ChannelHandler[]{clientSslCtx.newHandler((ByteBufAllocator)PooledByteBufAllocator.DEFAULT), new HttpProxyHandler((SocketAddress)httpsProxy.address())}), new SuccessTestItem("HTTPS proxy: successful connection, AUTO_READ on", DESTINATION, true, new ChannelHandler[]{clientSslCtx.newHandler((ByteBufAllocator)PooledByteBufAllocator.DEFAULT), new HttpProxyHandler((SocketAddress)httpsProxy.address(), USERNAME, PASSWORD)}), new SuccessTestItem("HTTPS proxy: successful connection, AUTO_READ off", DESTINATION, false, new ChannelHandler[]{clientSslCtx.newHandler((ByteBufAllocator)PooledByteBufAllocator.DEFAULT), new HttpProxyHandler((SocketAddress)httpsProxy.address(), USERNAME, PASSWORD)}), new FailureTestItem("HTTPS proxy: rejected connection", BAD_DESTINATION, "status: 403", new ChannelHandler[]{clientSslCtx.newHandler((ByteBufAllocator)PooledByteBufAllocator.DEFAULT), new HttpProxyHandler((SocketAddress)httpsProxy.address(), USERNAME, PASSWORD)}), new FailureTestItem("HTTPS proxy: authentication failure", DESTINATION, "status: 401", new ChannelHandler[]{clientSslCtx.newHandler((ByteBufAllocator)PooledByteBufAllocator.DEFAULT), new HttpProxyHandler((SocketAddress)httpsProxy.address(), BAD_USERNAME, BAD_PASSWORD)}), new TimeoutTestItem("HTTPS proxy: timeout", new ChannelHandler[]{clientSslCtx.newHandler((ByteBufAllocator)PooledByteBufAllocator.DEFAULT), new HttpProxyHandler((SocketAddress)deadHttpsProxy.address())}), new SuccessTestItem("Anonymous SOCKS4: successful connection, AUTO_READ on", DESTINATION, true, new ChannelHandler[]{new Socks4ProxyHandler((SocketAddress)anonSocks4Proxy.address())}), new SuccessTestItem("Anonymous SOCKS4: successful connection, AUTO_READ off", DESTINATION, false, new ChannelHandler[]{new Socks4ProxyHandler((SocketAddress)anonSocks4Proxy.address())}), new FailureTestItem("Anonymous SOCKS4: rejected connection", BAD_DESTINATION, "status: REJECTED_OR_FAILED", new ChannelHandler[]{new Socks4ProxyHandler((SocketAddress)anonSocks4Proxy.address())}), new FailureTestItem("SOCKS4: rejected anonymous connection", DESTINATION, "status: IDENTD_AUTH_FAILURE", new ChannelHandler[]{new Socks4ProxyHandler((SocketAddress)socks4Proxy.address())}), new SuccessTestItem("SOCKS4: successful connection, AUTO_READ on", DESTINATION, true, new ChannelHandler[]{new Socks4ProxyHandler((SocketAddress)socks4Proxy.address(), USERNAME)}), new SuccessTestItem("SOCKS4: successful connection, AUTO_READ off", DESTINATION, false, new ChannelHandler[]{new Socks4ProxyHandler((SocketAddress)socks4Proxy.address(), USERNAME)}), new FailureTestItem("SOCKS4: rejected connection", BAD_DESTINATION, "status: REJECTED_OR_FAILED", new ChannelHandler[]{new Socks4ProxyHandler((SocketAddress)socks4Proxy.address(), USERNAME)}), new FailureTestItem("SOCKS4: authentication failure", DESTINATION, "status: IDENTD_AUTH_FAILURE", new ChannelHandler[]{new Socks4ProxyHandler((SocketAddress)socks4Proxy.address(), BAD_USERNAME)}), new TimeoutTestItem("SOCKS4: timeout", new ChannelHandler[]{new Socks4ProxyHandler((SocketAddress)deadSocks4Proxy.address())}), new SuccessTestItem("Anonymous SOCKS5: successful connection, AUTO_READ on", DESTINATION, true, new ChannelHandler[]{new Socks5ProxyHandler((SocketAddress)anonSocks5Proxy.address())}), new SuccessTestItem("Anonymous SOCKS5: successful connection, AUTO_READ off", DESTINATION, false, new ChannelHandler[]{new Socks5ProxyHandler((SocketAddress)anonSocks5Proxy.address())}), new FailureTestItem("Anonymous SOCKS5: rejected connection", BAD_DESTINATION, "status: FORBIDDEN", new ChannelHandler[]{new Socks5ProxyHandler((SocketAddress)anonSocks5Proxy.address())}), new FailureTestItem("SOCKS5: rejected anonymous connection", DESTINATION, "unexpected authMethod: PASSWORD", new ChannelHandler[]{new Socks5ProxyHandler((SocketAddress)socks5Proxy.address())}), new SuccessTestItem("SOCKS5: successful connection to anonymous server, AUTO_READ on", DESTINATION, true, new ChannelHandler[]{new Socks5ProxyHandler((SocketAddress)anonSocks5Proxy.address(), USERNAME, PASSWORD)}), new SuccessTestItem("SOCKS5: successful connection, AUTO_READ on", DESTINATION, true, new ChannelHandler[]{new Socks5ProxyHandler((SocketAddress)socks5Proxy.address(), USERNAME, PASSWORD)}), new SuccessTestItem("SOCKS5: successful connection, AUTO_READ off", DESTINATION, false, new ChannelHandler[]{new Socks5ProxyHandler((SocketAddress)socks5Proxy.address(), USERNAME, PASSWORD)}), new FailureTestItem("SOCKS5: rejected connection", BAD_DESTINATION, "status: FORBIDDEN", new ChannelHandler[]{new Socks5ProxyHandler((SocketAddress)socks5Proxy.address(), USERNAME, PASSWORD)}), new FailureTestItem("SOCKS5: authentication failure", DESTINATION, "authStatus: FAILURE", new ChannelHandler[]{new Socks5ProxyHandler((SocketAddress)socks5Proxy.address(), BAD_USERNAME, BAD_PASSWORD)}), new TimeoutTestItem("SOCKS5: timeout", new ChannelHandler[]{new Socks5ProxyHandler((SocketAddress)deadSocks5Proxy.address())}), new SuccessTestItem("Single-chain: successful connection, AUTO_READ on", DESTINATION, true, new ChannelHandler[]{new Socks5ProxyHandler((SocketAddress)interSocks5Proxy.address()), new Socks4ProxyHandler((SocketAddress)interSocks4Proxy.address()), clientSslCtx.newHandler((ByteBufAllocator)PooledByteBufAllocator.DEFAULT), new HttpProxyHandler((SocketAddress)interHttpsProxy.address()), new HttpProxyHandler((SocketAddress)interHttpProxy.address()), new HttpProxyHandler((SocketAddress)anonHttpProxy.address())}), new SuccessTestItem("Single-chain: successful connection, AUTO_READ off", DESTINATION, false, new ChannelHandler[]{new Socks5ProxyHandler((SocketAddress)interSocks5Proxy.address()), new Socks4ProxyHandler((SocketAddress)interSocks4Proxy.address()), clientSslCtx.newHandler((ByteBufAllocator)PooledByteBufAllocator.DEFAULT), new HttpProxyHandler((SocketAddress)interHttpsProxy.address()), new HttpProxyHandler((SocketAddress)interHttpProxy.address()), new HttpProxyHandler((SocketAddress)anonHttpProxy.address())}), new SuccessTestItem("Double-chain: successful connection, AUTO_READ on", DESTINATION, true, new ChannelHandler[]{new Socks5ProxyHandler((SocketAddress)interSocks5Proxy.address()), new Socks4ProxyHandler((SocketAddress)interSocks4Proxy.address()), clientSslCtx.newHandler((ByteBufAllocator)PooledByteBufAllocator.DEFAULT), new HttpProxyHandler((SocketAddress)interHttpsProxy.address()), new HttpProxyHandler((SocketAddress)interHttpProxy.address()), new Socks5ProxyHandler((SocketAddress)interSocks5Proxy.address()), new Socks4ProxyHandler((SocketAddress)interSocks4Proxy.address()), clientSslCtx.newHandler((ByteBufAllocator)PooledByteBufAllocator.DEFAULT), new HttpProxyHandler((SocketAddress)interHttpsProxy.address()), new HttpProxyHandler((SocketAddress)interHttpProxy.address()), new HttpProxyHandler((SocketAddress)anonHttpProxy.address())}), new SuccessTestItem("Double-chain: successful connection, AUTO_READ off", DESTINATION, false, new ChannelHandler[]{new Socks5ProxyHandler((SocketAddress)interSocks5Proxy.address()), new Socks4ProxyHandler((SocketAddress)interSocks4Proxy.address()), clientSslCtx.newHandler((ByteBufAllocator)PooledByteBufAllocator.DEFAULT), new HttpProxyHandler((SocketAddress)interHttpsProxy.address()), new HttpProxyHandler((SocketAddress)interHttpProxy.address()), new Socks5ProxyHandler((SocketAddress)interSocks5Proxy.address()), new Socks4ProxyHandler((SocketAddress)interSocks4Proxy.address()), clientSslCtx.newHandler((ByteBufAllocator)PooledByteBufAllocator.DEFAULT), new HttpProxyHandler((SocketAddress)interHttpsProxy.address()), new HttpProxyHandler((SocketAddress)interHttpProxy.address()), new HttpProxyHandler((SocketAddress)anonHttpProxy.address())}));
        ArrayList<Object[]> params = new ArrayList<Object[]>(items.size());
        for (TestItem i : items) {
            params.add(new Object[]{i});
        }
        long seed = System.currentTimeMillis();
        logger.debug("Seed used: {}\n", (Object)seed);
        Collections.shuffle(params, new Random(seed));
        return params;
    }

    @AfterAll
    public static void stopServers() {
        for (ProxyServer p : allProxies) {
            p.stop();
        }
    }

    @BeforeEach
    public void clearServerExceptions() throws Exception {
        for (ProxyServer p : allProxies) {
            p.clearExceptions();
        }
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"testItems"})
    public void test(TestItem testItem) throws Exception {
        testItem.test();
    }

    @AfterEach
    public void checkServerExceptions() throws Exception {
        for (ProxyServer p : allProxies) {
            p.checkExceptions();
        }
    }

    static {
        SslContext cctx;
        SslContext sctx;
        logger = InternalLoggerFactory.getInstance(ProxyHandlerTest.class);
        DESTINATION = InetSocketAddress.createUnresolved("destination.com", 42);
        BAD_DESTINATION = SocketUtils.socketAddress((String)"1.2.3.4", (int)5);
        group = new NioEventLoopGroup(3, (ThreadFactory)new DefaultThreadFactory("proxy", true));
        try {
            SelfSignedCertificate ssc = new SelfSignedCertificate();
            sctx = SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).build();
            cctx = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
        }
        catch (Exception e) {
            throw new Error(e);
        }
        serverSslCtx = sctx;
        clientSslCtx = cctx;
        deadHttpProxy = new HttpProxyServer(false, TestMode.UNRESPONSIVE, null);
        interHttpProxy = new HttpProxyServer(false, TestMode.INTERMEDIARY, null);
        anonHttpProxy = new HttpProxyServer(false, TestMode.TERMINAL, DESTINATION);
        httpProxy = new HttpProxyServer(false, TestMode.TERMINAL, DESTINATION, USERNAME, PASSWORD);
        deadHttpsProxy = new HttpProxyServer(true, TestMode.UNRESPONSIVE, null);
        interHttpsProxy = new HttpProxyServer(true, TestMode.INTERMEDIARY, null);
        anonHttpsProxy = new HttpProxyServer(true, TestMode.TERMINAL, DESTINATION);
        httpsProxy = new HttpProxyServer(true, TestMode.TERMINAL, DESTINATION, USERNAME, PASSWORD);
        deadSocks4Proxy = new Socks4ProxyServer(false, TestMode.UNRESPONSIVE, null);
        interSocks4Proxy = new Socks4ProxyServer(false, TestMode.INTERMEDIARY, null);
        anonSocks4Proxy = new Socks4ProxyServer(false, TestMode.TERMINAL, DESTINATION);
        socks4Proxy = new Socks4ProxyServer(false, TestMode.TERMINAL, DESTINATION, USERNAME);
        deadSocks5Proxy = new Socks5ProxyServer(false, TestMode.UNRESPONSIVE, null);
        interSocks5Proxy = new Socks5ProxyServer(false, TestMode.INTERMEDIARY, null);
        anonSocks5Proxy = new Socks5ProxyServer(false, TestMode.TERMINAL, DESTINATION);
        socks5Proxy = new Socks5ProxyServer(false, TestMode.TERMINAL, DESTINATION, USERNAME, PASSWORD);
        allProxies = Arrays.asList(deadHttpProxy, interHttpProxy, anonHttpProxy, httpProxy, deadHttpsProxy, interHttpsProxy, anonHttpsProxy, httpsProxy, deadSocks4Proxy, interSocks4Proxy, anonSocks4Proxy, socks4Proxy, deadSocks5Proxy, interSocks5Proxy, anonSocks5Proxy, socks5Proxy);
    }

    private static final class TimeoutTestItem
    extends TestItem {
        TimeoutTestItem(String name, ChannelHandler ... clientHandlers) {
            super(name, null, clientHandlers);
        }

        @Override
        protected void test() throws Exception {
            long TIMEOUT = 2000L;
            for (ChannelHandler h : this.clientHandlers) {
                if (!(h instanceof ProxyHandler)) continue;
                ((ProxyHandler)h).setConnectTimeoutMillis(2000L);
            }
            final FailureTestHandler testHandler = new FailureTestHandler();
            Bootstrap b = new Bootstrap();
            b.group(group);
            b.channel(NioSocketChannel.class);
            b.resolver((AddressResolverGroup)NoopAddressResolverGroup.INSTANCE);
            b.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(TimeoutTestItem.this.clientHandlers);
                    p.addLast(new ChannelHandler[]{new LineBasedFrameDecoder(64)});
                    p.addLast(new ChannelHandler[]{testHandler});
                }
            });
            ChannelFuture cf = b.connect((SocketAddress)DESTINATION).channel().closeFuture();
            boolean finished = cf.await(4000L, TimeUnit.MILLISECONDS);
            finished &= testHandler.latch.await(4000L, TimeUnit.MILLISECONDS);
            logger.debug("Recorded exceptions: {}", testHandler.exceptions);
            this.assertProxyHandlers(false);
            MatcherAssert.assertThat((Object)testHandler.exceptions.size(), (Matcher)CoreMatchers.is((Object)1));
            Throwable e = testHandler.exceptions.poll();
            MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ProxyConnectException.class)));
            MatcherAssert.assertThat((Object)String.valueOf(e), (Matcher)CoreMatchers.containsString((String)"timeout"));
            MatcherAssert.assertThat((Object)finished, (Matcher)CoreMatchers.is((Object)true));
        }
    }

    private static final class FailureTestItem
    extends TestItem {
        private final String expectedMessage;

        FailureTestItem(String name, InetSocketAddress destination, String expectedMessage, ChannelHandler ... clientHandlers) {
            super(name, destination, clientHandlers);
            this.expectedMessage = expectedMessage;
        }

        @Override
        protected void test() throws Exception {
            final FailureTestHandler testHandler = new FailureTestHandler();
            Bootstrap b = new Bootstrap();
            b.group(group);
            b.channel(NioSocketChannel.class);
            b.resolver((AddressResolverGroup)NoopAddressResolverGroup.INSTANCE);
            b.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(FailureTestItem.this.clientHandlers);
                    p.addLast(new ChannelHandler[]{new LineBasedFrameDecoder(64)});
                    p.addLast(new ChannelHandler[]{testHandler});
                }
            });
            boolean finished = b.connect((SocketAddress)this.destination).channel().closeFuture().await(10L, TimeUnit.SECONDS);
            finished &= testHandler.latch.await(10L, TimeUnit.SECONDS);
            logger.debug("Recorded exceptions: {}", testHandler.exceptions);
            this.assertProxyHandlers(false);
            MatcherAssert.assertThat((Object)testHandler.exceptions.size(), (Matcher)CoreMatchers.is((Object)1));
            Throwable e = testHandler.exceptions.poll();
            MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ProxyConnectException.class)));
            MatcherAssert.assertThat((Object)String.valueOf(e), (Matcher)CoreMatchers.containsString((String)this.expectedMessage));
            MatcherAssert.assertThat((Object)finished, (Matcher)CoreMatchers.is((Object)true));
        }
    }

    private static final class SuccessTestItem
    extends TestItem {
        private final int expectedEventCount;
        private final boolean autoRead;

        SuccessTestItem(String name, InetSocketAddress destination, boolean autoRead, ChannelHandler ... clientHandlers) {
            super(name, destination, clientHandlers);
            int expectedEventCount = 0;
            for (ChannelHandler h : clientHandlers) {
                if (!(h instanceof ProxyHandler)) continue;
                ++expectedEventCount;
            }
            this.expectedEventCount = expectedEventCount;
            this.autoRead = autoRead;
        }

        @Override
        protected void test() throws Exception {
            final SuccessTestHandler testHandler = new SuccessTestHandler();
            Bootstrap b = new Bootstrap();
            b.group(group);
            b.channel(NioSocketChannel.class);
            b.option(ChannelOption.AUTO_READ, (Object)this.autoRead);
            b.resolver((AddressResolverGroup)NoopAddressResolverGroup.INSTANCE);
            b.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(SuccessTestItem.this.clientHandlers);
                    p.addLast(new ChannelHandler[]{new LineBasedFrameDecoder(64)});
                    p.addLast(new ChannelHandler[]{testHandler});
                }
            });
            boolean finished = b.connect((SocketAddress)this.destination).channel().closeFuture().await(10L, TimeUnit.SECONDS);
            logger.debug("Received messages: {}", testHandler.received);
            if (testHandler.exceptions.isEmpty()) {
                logger.debug("No recorded exceptions on the client side.");
            } else {
                for (Throwable t : testHandler.exceptions) {
                    logger.debug("Recorded exception on the client side: {}", t);
                }
            }
            this.assertProxyHandlers(true);
            MatcherAssert.assertThat((Object)testHandler.received.toArray(), (Matcher)CoreMatchers.is((Object)new Object[]{"0", "1", "2", "3"}));
            MatcherAssert.assertThat((Object)testHandler.exceptions.toArray(), (Matcher)CoreMatchers.is((Object)EmptyArrays.EMPTY_OBJECTS));
            MatcherAssert.assertThat((Object)testHandler.eventCount, (Matcher)CoreMatchers.is((Object)this.expectedEventCount));
            MatcherAssert.assertThat((Object)finished, (Matcher)CoreMatchers.is((Object)true));
        }
    }

    private static abstract class TestItem {
        final String name;
        final InetSocketAddress destination;
        final ChannelHandler[] clientHandlers;

        protected TestItem(String name, InetSocketAddress destination, ChannelHandler ... clientHandlers) {
            this.name = name;
            this.destination = destination;
            this.clientHandlers = clientHandlers;
        }

        abstract void test() throws Exception;

        protected void assertProxyHandlers(boolean success) {
            ProxyHandler ph;
            for (ChannelHandler h : this.clientHandlers) {
                if (!(h instanceof ProxyHandler)) continue;
                ph = (ProxyHandler)h;
                String type = StringUtil.simpleClassName((Object)ph);
                Future f = ph.connectFuture();
                if (!f.isDone()) {
                    logger.warn("{}: not done", (Object)type);
                    continue;
                }
                if (f.isSuccess()) {
                    if (success) {
                        logger.debug("{}: success", (Object)type);
                        continue;
                    }
                    logger.warn("{}: success", (Object)type);
                    continue;
                }
                if (success) {
                    logger.warn("{}: failure", (Object)type, (Object)f.cause());
                    continue;
                }
                logger.debug("{}: failure", (Object)type, (Object)f.cause());
            }
            for (ChannelHandler h : this.clientHandlers) {
                if (!(h instanceof ProxyHandler)) continue;
                ph = (ProxyHandler)h;
                MatcherAssert.assertThat((Object)ph.connectFuture().isDone(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)ph.connectFuture().isSuccess(), (Matcher)CoreMatchers.is((Object)success));
            }
        }

        public String toString() {
            return this.name;
        }
    }

    private static final class FailureTestHandler
    extends SimpleChannelInboundHandler<Object> {
        final Queue<Throwable> exceptions = new LinkedBlockingQueue<Throwable>();
        final CountDownLatch latch = new CountDownLatch(2);

        private FailureTestHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            ctx.writeAndFlush((Object)Unpooled.copiedBuffer((CharSequence)"A\n", (Charset)CharsetUtil.US_ASCII)).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    FailureTestHandler.this.latch.countDown();
                    if (!(future.cause() instanceof ProxyConnectException)) {
                        FailureTestHandler.this.exceptions.add((Throwable)((Object)new AssertionError((Object)("Unexpected failure cause for initial write: " + future.cause()))));
                    }
                }
            });
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            this.latch.countDown();
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof ProxyConnectionEvent) {
                Assertions.fail((String)("Unexpected event: " + evt));
            }
        }

        protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
            Assertions.fail((String)("Unexpected message: " + msg));
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            this.exceptions.add(cause);
            ctx.close();
        }
    }

    private static final class SuccessTestHandler
    extends SimpleChannelInboundHandler<Object> {
        final Queue<String> received = new LinkedBlockingQueue<String>();
        final Queue<Throwable> exceptions = new LinkedBlockingQueue<Throwable>();
        volatile int eventCount;

        private SuccessTestHandler() {
        }

        private static void readIfNeeded(ChannelHandlerContext ctx) {
            if (!ctx.channel().config().isAutoRead()) {
                ctx.read();
            }
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            ctx.writeAndFlush((Object)Unpooled.copiedBuffer((CharSequence)"A\n", (Charset)CharsetUtil.US_ASCII));
            SuccessTestHandler.readIfNeeded(ctx);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof ProxyConnectionEvent) {
                ++this.eventCount;
                if (this.eventCount == 1) {
                    ctx.writeAndFlush((Object)Unpooled.copiedBuffer((CharSequence)"B\n", (Charset)CharsetUtil.US_ASCII));
                }
                SuccessTestHandler.readIfNeeded(ctx);
            }
        }

        protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
            String str = ((ByteBuf)msg).toString(CharsetUtil.US_ASCII);
            this.received.add(str);
            if ("2".equals(str)) {
                ctx.writeAndFlush((Object)Unpooled.copiedBuffer((CharSequence)"C\n", (Charset)CharsetUtil.US_ASCII));
            }
            SuccessTestHandler.readIfNeeded(ctx);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            this.exceptions.add(cause);
            ctx.close();
        }
    }
}

