/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl.ocsp;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.ocsp.OcspResponse;
import io.netty.handler.ssl.ocsp.OcspServerCertificateValidator;
import io.netty.handler.ssl.ocsp.OcspValidationEvent;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class OcspServerCertificateValidatorTest {
    OcspServerCertificateValidatorTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void connectUsingHttpAndValidateCertificateUsingOcspTest() throws Exception {
        final AtomicBoolean ocspStatus = new AtomicBoolean();
        NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup();
        try {
            final CountDownLatch latch = new CountDownLatch(1);
            final SslContext sslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ChannelPipeline pipeline = ch.pipeline();
                    pipeline.addLast(new ChannelHandler[]{sslContext.newHandler(ch.alloc(), "netty.io", 443)});
                    pipeline.addLast(new ChannelHandler[]{new OcspServerCertificateValidator(false)});
                    pipeline.addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<Object>(){

                        protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
                        }

                        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                            if (evt instanceof OcspValidationEvent) {
                                OcspValidationEvent event = (OcspValidationEvent)evt;
                                ocspStatus.set(event.response().status() == OcspResponse.Status.VALID);
                                ctx.channel().close();
                                latch.countDown();
                            }
                        }
                    }});
                }
            });
            ChannelFuture channelFuture = bootstrap.connect("netty.io", 443);
            channelFuture.sync();
            latch.await(1L, TimeUnit.MINUTES);
            Assertions.assertTrue((boolean)ocspStatus.get());
            channelFuture.channel().closeFuture().sync();
        }
        finally {
            eventLoopGroup.shutdownGracefully();
        }
    }
}

