/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.traffic;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundByteHandler;
import io.netty.channel.ChannelOutboundByteHandler;
import io.netty.channel.ChannelPromise;
import io.netty.handler.traffic.TrafficCounter;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.util.concurrent.TimeUnit;

public abstract class AbstractTrafficShapingHandler
extends ChannelDuplexHandler
implements ChannelInboundByteHandler,
ChannelOutboundByteHandler {
    public static final long DEFAULT_CHECK_INTERVAL = 1000L;
    private static final long MINIMAL_WAIT = 10L;
    protected TrafficCounter trafficCounter;
    private long writeLimit;
    private long readLimit;
    protected long checkInterval = 1000L;
    private static final AttributeKey<Boolean> READ_SUSPENDED = new AttributeKey("readSuspended");
    private static final AttributeKey<Runnable> REOPEN_TASK = new AttributeKey("reopenTask");
    private static final AttributeKey<Runnable> BUFFER_UPDATE_TASK = new AttributeKey("bufferUpdateTask");

    void setTrafficCounter(TrafficCounter newTrafficCounter) {
        this.trafficCounter = newTrafficCounter;
    }

    protected AbstractTrafficShapingHandler(long writeLimit, long readLimit, long checkInterval) {
        this.writeLimit = writeLimit;
        this.readLimit = readLimit;
        this.checkInterval = checkInterval;
    }

    protected AbstractTrafficShapingHandler(long writeLimit, long readLimit) {
        this(writeLimit, readLimit, 1000L);
    }

    protected AbstractTrafficShapingHandler() {
        this(0L, 0L, 1000L);
    }

    protected AbstractTrafficShapingHandler(long checkInterval) {
        this(0L, 0L, checkInterval);
    }

    public void configure(long newWriteLimit, long newReadLimit, long newCheckInterval) {
        this.configure(newWriteLimit, newReadLimit);
        this.configure(newCheckInterval);
    }

    public void configure(long newWriteLimit, long newReadLimit) {
        this.writeLimit = newWriteLimit;
        this.readLimit = newReadLimit;
        if (this.trafficCounter != null) {
            this.trafficCounter.resetAccounting(System.currentTimeMillis() + 1L);
        }
    }

    public void configure(long newCheckInterval) {
        this.checkInterval = newCheckInterval;
        if (this.trafficCounter != null) {
            this.trafficCounter.configure(this.checkInterval);
        }
    }

    protected void doAccounting(TrafficCounter counter) {
    }

    private static long getTimeToWait(long limit, long bytes, long lastTime, long curtime) {
        long interval = curtime - lastTime;
        if (interval == 0L) {
            return 0L;
        }
        return (bytes * 1000L / limit - interval / 10L) * 10L;
    }

    public ByteBuf newInboundBuffer(ChannelHandlerContext ctx) throws Exception {
        return ctx.nextInboundByteBuffer();
    }

    public void discardInboundReadBytes(ChannelHandlerContext ctx) throws Exception {
    }

    public void freeInboundBuffer(ChannelHandlerContext ctx) throws Exception {
    }

    public ByteBuf newOutboundBuffer(ChannelHandlerContext ctx) throws Exception {
        return ctx.nextOutboundByteBuffer();
    }

    public void discardOutboundReadBytes(ChannelHandlerContext ctx) throws Exception {
    }

    public void freeOutboundBuffer(ChannelHandlerContext ctx) throws Exception {
    }

    public void inboundBufferUpdated(final ChannelHandlerContext ctx) throws Exception {
        ByteBuf buf = ctx.inboundByteBuffer();
        long curtime = System.currentTimeMillis();
        long size = buf.readableBytes();
        if (this.trafficCounter != null) {
            this.trafficCounter.bytesRecvFlowControl(size);
            if (this.readLimit == 0L) {
                ctx.fireInboundBufferUpdated();
                return;
            }
            long wait = AbstractTrafficShapingHandler.getTimeToWait(this.readLimit, this.trafficCounter.currentReadBytes(), this.trafficCounter.lastTime(), curtime);
            if (wait >= 10L) {
                if (!((Boolean)ctx.attr(READ_SUSPENDED).get()).booleanValue()) {
                    ctx.attr(READ_SUSPENDED).set((Object)true);
                    Attribute attr = ctx.attr(REOPEN_TASK);
                    Runnable reopenTask = (Runnable)attr.get();
                    if (reopenTask == null) {
                        reopenTask = new ReopenReadTimerTask(ctx);
                        attr.set((Object)reopenTask);
                    }
                    ctx.executor().schedule(reopenTask, wait, TimeUnit.MILLISECONDS);
                } else {
                    Attribute attr = ctx.attr(BUFFER_UPDATE_TASK);
                    Runnable bufferUpdateTask = (Runnable)attr.get();
                    if (bufferUpdateTask == null) {
                        bufferUpdateTask = new Runnable(){

                            @Override
                            public void run() {
                                ctx.fireInboundBufferUpdated();
                            }
                        };
                        attr.set((Object)bufferUpdateTask);
                    }
                    ctx.executor().schedule(bufferUpdateTask, wait, TimeUnit.MILLISECONDS);
                    return;
                }
            }
        }
        ctx.fireInboundBufferUpdated();
    }

    public void read(ChannelHandlerContext ctx) {
        if (!((Boolean)ctx.attr(READ_SUSPENDED).get()).booleanValue()) {
            ctx.read();
        }
    }

    public void flush(final ChannelHandlerContext ctx, final ChannelPromise promise) throws Exception {
        long curtime = System.currentTimeMillis();
        long size = ctx.outboundByteBuffer().readableBytes();
        if (this.trafficCounter != null) {
            this.trafficCounter.bytesWriteFlowControl(size);
            if (this.writeLimit == 0L) {
                ctx.flush(promise);
                return;
            }
            long wait = AbstractTrafficShapingHandler.getTimeToWait(this.writeLimit, this.trafficCounter.currentWrittenBytes(), this.trafficCounter.lastTime(), curtime);
            if (wait >= 10L) {
                ctx.executor().schedule(new Runnable(){

                    @Override
                    public void run() {
                        ctx.flush(promise);
                    }
                }, wait, TimeUnit.MILLISECONDS);
                return;
            }
        }
        ctx.flush(promise);
    }

    public TrafficCounter trafficCounter() {
        return this.trafficCounter;
    }

    public void beforeRemove(ChannelHandlerContext ctx) {
        if (this.trafficCounter != null) {
            this.trafficCounter.stop();
        }
    }

    public String toString() {
        return "TrafficShaping with Write Limit: " + this.writeLimit + " Read Limit: " + this.readLimit + " and Counter: " + (this.trafficCounter != null ? this.trafficCounter.toString() : "none");
    }

    private static final class ReopenReadTimerTask
    implements Runnable {
        final ChannelHandlerContext ctx;

        ReopenReadTimerTask(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public void run() {
            this.ctx.attr(READ_SUSPENDED).set((Object)false);
            this.ctx.read();
        }
    }
}

