/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.NotSslRecordException;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslUtils;
import io.netty.util.AsyncMapping;
import io.netty.util.CharsetUtil;
import io.netty.util.DomainNameMapping;
import io.netty.util.Mapping;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.IDN;
import java.net.SocketAddress;
import java.util.List;
import java.util.Locale;

public class SniHandler
extends ByteToMessageDecoder
implements ChannelOutboundHandler {
    private static final int MAX_SSL_RECORDS = 4;
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SniHandler.class);
    private static final Selection EMPTY_SELECTION = new Selection(null, null);
    private final AsyncMapping<String, SslContext> mapping;
    private boolean handshakeFailed;
    private boolean suppressRead;
    private boolean readPending;
    private volatile Selection selection = EMPTY_SELECTION;

    public SniHandler(Mapping<? super String, ? extends SslContext> mapping) {
        this(new AsyncMappingAdapter(mapping));
    }

    public SniHandler(DomainNameMapping<? extends SslContext> mapping) {
        this((Mapping<? super String, ? extends SslContext>)mapping);
    }

    public SniHandler(AsyncMapping<? super String, ? extends SslContext> mapping) {
        this.mapping = (AsyncMapping)ObjectUtil.checkNotNull(mapping, (String)"mapping");
    }

    public String hostname() {
        return this.selection.hostname;
    }

    public SslContext sslContext() {
        return this.selection.context;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (!this.suppressRead && !this.handshakeFailed && in.readableBytes() >= 5) {
            block15: {
                int writerIndex = in.writerIndex();
                int readerIndex = in.readerIndex();
                try {
                    block6: for (int i = 0; i < 4; ++i) {
                        short command = in.getUnsignedByte(readerIndex);
                        switch (command) {
                            case 20: 
                            case 21: {
                                int len = SslUtils.getEncryptedPacketLength(in, readerIndex);
                                if (len == -1) {
                                    this.handshakeFailed = true;
                                    NotSslRecordException e = new NotSslRecordException("not an SSL/TLS record: " + ByteBufUtil.hexDump((ByteBuf)in));
                                    in.skipBytes(in.readableBytes());
                                    ctx.fireExceptionCaught((Throwable)e);
                                    SslUtils.notifyHandshakeFailure(ctx, e);
                                    return;
                                }
                                if (writerIndex - readerIndex - 5 < len) {
                                    return;
                                }
                                readerIndex += len;
                                continue block6;
                            }
                            case 22: {
                                short majorVersion = in.getUnsignedByte(readerIndex + 1);
                                if (majorVersion == 3) {
                                    int packetLength = in.getUnsignedShort(readerIndex + 3) + 5;
                                    if (in.readableBytes() < packetLength) {
                                        return;
                                    }
                                    int offset = readerIndex + 43;
                                    short sessionIdLength = in.getUnsignedByte(offset);
                                    int cipherSuitesLength = in.getUnsignedShort(offset += sessionIdLength + 1);
                                    short compressionMethodLength = in.getUnsignedByte(offset += cipherSuitesLength + 2);
                                    int extensionsLength = in.getUnsignedShort(offset += compressionMethodLength + 1);
                                    int extensionsLimit = (offset += 2) + extensionsLength;
                                    while (offset < extensionsLimit) {
                                        int extensionType = in.getUnsignedShort(offset);
                                        int extensionLength = in.getUnsignedShort(offset += 2);
                                        offset += 2;
                                        if (extensionType == 0) {
                                            short serverNameType = in.getUnsignedByte(offset + 2);
                                            if (serverNameType == 0) {
                                                int serverNameLength = in.getUnsignedShort(offset + 3);
                                                String hostname = in.toString(offset + 5, serverNameLength, CharsetUtil.UTF_8);
                                                this.select(ctx, IDN.toASCII(hostname, 1).toLowerCase(Locale.US));
                                                return;
                                            }
                                            break block15;
                                        }
                                        offset += extensionLength;
                                    }
                                }
                            }
                            default: {
                                break block15;
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    if (!logger.isDebugEnabled()) break block15;
                    logger.debug("Unexpected client hello packet: " + ByteBufUtil.hexDump((ByteBuf)in), e);
                }
            }
            this.select(ctx, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void select(final ChannelHandlerContext ctx, final String hostname) {
        Future future = this.mapping.map((Object)hostname, ctx.executor().newPromise());
        if (future.isDone()) {
            if (!future.isSuccess()) throw new DecoderException("failed to get the SslContext for " + hostname, future.cause());
            this.replaceHandler(ctx, new Selection((SslContext)future.getNow(), hostname));
            return;
        } else {
            this.suppressRead = true;
            future.addListener((GenericFutureListener)new FutureListener<SslContext>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void operationComplete(Future<SslContext> future) throws Exception {
                    try {
                        SniHandler.this.suppressRead = false;
                        if (future.isSuccess()) {
                            SniHandler.this.replaceHandler(ctx, new Selection((SslContext)future.getNow(), hostname));
                        } else {
                            ctx.fireExceptionCaught((Throwable)new DecoderException("failed to get the SslContext for " + hostname, future.cause()));
                        }
                    }
                    finally {
                        if (SniHandler.this.readPending) {
                            SniHandler.this.readPending = false;
                            ctx.read();
                        }
                    }
                }
            });
        }
    }

    private void replaceHandler(ChannelHandlerContext ctx, Selection selection) {
        this.selection = selection;
        SslHandler sslHandler = selection.context.newHandler(ctx.alloc());
        ctx.pipeline().replace((ChannelHandler)this, SslHandler.class.getName(), (ChannelHandler)sslHandler);
    }

    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.bind(localAddress, promise);
    }

    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.connect(remoteAddress, localAddress, promise);
    }

    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.disconnect(promise);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.close(promise);
    }

    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.deregister(promise);
    }

    public void read(ChannelHandlerContext ctx) throws Exception {
        if (this.suppressRead) {
            this.readPending = true;
        } else {
            ctx.read();
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        ctx.write(msg, promise);
    }

    public void flush(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    private static final class Selection {
        final SslContext context;
        final String hostname;

        Selection(SslContext context, String hostname) {
            this.context = context;
            this.hostname = hostname;
        }
    }

    private static final class AsyncMappingAdapter
    implements AsyncMapping<String, SslContext> {
        private final Mapping<? super String, ? extends SslContext> mapping;

        private AsyncMappingAdapter(Mapping<? super String, ? extends SslContext> mapping) {
            this.mapping = (Mapping)ObjectUtil.checkNotNull(mapping, (String)"mapping");
        }

        public Future<SslContext> map(String input, Promise<SslContext> promise) {
            SslContext context;
            try {
                context = (SslContext)this.mapping.map((Object)input);
            }
            catch (Throwable cause) {
                return promise.setFailure(cause);
            }
            return promise.setSuccess((Object)context);
        }
    }
}

