/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.EnhancingX509ExtendedTrustManager;
import io.netty.util.internal.EmptyArrays;
import java.math.BigInteger;
import java.net.Socket;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class EnhancedX509ExtendedTrustManagerTest {
    private static final X509Certificate TEST_CERT = new X509Certificate(){

        @Override
        public Collection<List<?>> getSubjectAlternativeNames() {
            return Arrays.asList(Arrays.asList(1, new Object()), Arrays.asList(2, "some.netty.io"));
        }

        @Override
        public void checkValidity() {
        }

        @Override
        public void checkValidity(Date date) {
        }

        @Override
        public int getVersion() {
            return 0;
        }

        @Override
        public BigInteger getSerialNumber() {
            return null;
        }

        @Override
        public Principal getIssuerDN() {
            return null;
        }

        @Override
        public Principal getSubjectDN() {
            return null;
        }

        @Override
        public Date getNotBefore() {
            return null;
        }

        @Override
        public Date getNotAfter() {
            return null;
        }

        @Override
        public byte[] getTBSCertificate() {
            return EmptyArrays.EMPTY_BYTES;
        }

        @Override
        public byte[] getSignature() {
            return EmptyArrays.EMPTY_BYTES;
        }

        @Override
        public String getSigAlgName() {
            return null;
        }

        @Override
        public String getSigAlgOID() {
            return null;
        }

        @Override
        public byte[] getSigAlgParams() {
            return EmptyArrays.EMPTY_BYTES;
        }

        @Override
        public boolean[] getIssuerUniqueID() {
            return new boolean[0];
        }

        @Override
        public boolean[] getSubjectUniqueID() {
            return new boolean[0];
        }

        @Override
        public boolean[] getKeyUsage() {
            return new boolean[0];
        }

        @Override
        public int getBasicConstraints() {
            return 0;
        }

        @Override
        public byte[] getEncoded() {
            return EmptyArrays.EMPTY_BYTES;
        }

        @Override
        public void verify(PublicKey key) {
        }

        @Override
        public void verify(PublicKey key, String sigProvider) {
        }

        @Override
        public String toString() {
            return null;
        }

        @Override
        public PublicKey getPublicKey() {
            return null;
        }

        @Override
        public boolean hasUnsupportedCriticalExtension() {
            return false;
        }

        @Override
        public Set<String> getCriticalExtensionOIDs() {
            return null;
        }

        @Override
        public Set<String> getNonCriticalExtensionOIDs() {
            return null;
        }

        @Override
        public byte[] getExtensionValue(String oid) {
            return EmptyArrays.EMPTY_BYTES;
        }
    };
    private static final EnhancingX509ExtendedTrustManager MATCHING_MANAGER = new EnhancingX509ExtendedTrustManager((X509TrustManager)new X509ExtendedTrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) {
            Assertions.fail();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            throw new CertificateException("No subject alternative DNS name matching netty.io.");
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) {
            Assertions.fail();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            throw new CertificateException("No subject alternative DNS name matching netty.io.");
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
            Assertions.fail();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new CertificateException("No subject alternative DNS name matching netty.io.");
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    });
    private static final EnhancingX509ExtendedTrustManager NON_MATCHING_MANAGER = new EnhancingX509ExtendedTrustManager((X509TrustManager)new X509ExtendedTrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            Assertions.fail();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            throw new CertificateException();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            Assertions.fail();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            throw new CertificateException();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            Assertions.fail();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new CertificateException();
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    });

    static List<Executable> throwingMatchingExecutables() {
        return Arrays.asList(new Executable(){

            public void execute() throws Throwable {
                MATCHING_MANAGER.checkServerTrusted(new X509Certificate[]{TEST_CERT}, null);
            }
        }, new Executable(){

            public void execute() throws Throwable {
                MATCHING_MANAGER.checkServerTrusted(new X509Certificate[]{TEST_CERT}, null, (SSLEngine)null);
            }
        }, new Executable(){

            public void execute() throws Throwable {
                MATCHING_MANAGER.checkServerTrusted(new X509Certificate[]{TEST_CERT}, null, (Socket)null);
            }
        });
    }

    static List<Executable> throwingNonMatchingExecutables() {
        return Arrays.asList(new Executable(){

            public void execute() throws Throwable {
                NON_MATCHING_MANAGER.checkServerTrusted(new X509Certificate[]{TEST_CERT}, null);
            }
        }, new Executable(){

            public void execute() throws Throwable {
                NON_MATCHING_MANAGER.checkServerTrusted(new X509Certificate[]{TEST_CERT}, null, (SSLEngine)null);
            }
        }, new Executable(){

            public void execute() throws Throwable {
                NON_MATCHING_MANAGER.checkServerTrusted(new X509Certificate[]{TEST_CERT}, null, (Socket)null);
            }
        });
    }

    @ParameterizedTest
    @MethodSource(value={"throwingMatchingExecutables"})
    void testEnhanceException(Executable executable) {
        CertificateException exception = (CertificateException)Assertions.assertThrows(CertificateException.class, (Executable)executable);
        Assertions.assertInstanceOf(CertificateException.class, (Object)exception.getCause());
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"some.netty.io"));
    }

    @ParameterizedTest
    @MethodSource(value={"throwingNonMatchingExecutables"})
    void testNotEnhanceException(Executable executable) {
        CertificateException exception = (CertificateException)Assertions.assertThrows(CertificateException.class, (Executable)executable);
        Assertions.assertNull((Object)exception.getCause());
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"some.netty.io")));
    }
}

