/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.Conscrypt;
import io.netty.handler.ssl.DelegatingSslContext;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkAlpnApplicationProtocolNegotiator;
import io.netty.handler.ssl.JdkAlpnSslUtils;
import io.netty.handler.ssl.JdkApplicationProtocolNegotiator;
import io.netty.handler.ssl.JdkBaseApplicationProtocolNegotiator;
import io.netty.handler.ssl.JdkSslClientContext;
import io.netty.handler.ssl.JdkSslServerContext;
import io.netty.handler.ssl.JettyAlpnSslEngine;
import io.netty.handler.ssl.JettyNpnSslEngine;
import io.netty.handler.ssl.SSLEngineTest;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.util.internal.EmptyArrays;
import java.security.Provider;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLHandshakeException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.opentest4j.TestAbortedException;

public class JdkSslEngineTest
extends SSLEngineTest {
    private static final String PREFERRED_APPLICATION_LEVEL_PROTOCOL = "my-protocol-http2";
    private static final String FALLBACK_APPLICATION_LEVEL_PROTOCOL = "my-protocol-http1_1";
    private static final String APPLICATION_LEVEL_PROTOCOL_NOT_COMPATIBLE = "my-protocol-FOO";
    private Provider provider;

    public JdkSslEngineTest() {
        super(SslProvider.isTlsv13Supported((SslProvider)SslProvider.JDK));
    }

    List<JdkSSLEngineTestParam> newJdkParams() {
        List<SSLEngineTest.SSLEngineTestParam> params = this.newTestParams();
        ArrayList<JdkSSLEngineTestParam> jdkParams = new ArrayList<JdkSSLEngineTestParam>();
        for (ProviderType providerType : ProviderType.values()) {
            for (SSLEngineTest.SSLEngineTestParam param : params) {
                jdkParams.add(new JdkSSLEngineTestParam(providerType, param));
            }
        }
        return jdkParams;
    }

    @MethodSource(value={"newJdkParams"})
    @ParameterizedTest
    public void testTlsExtension(JdkSSLEngineTestParam param) throws Exception {
        try {
            param.providerType.activate(this);
            ApplicationProtocolConfig apn = JdkSslEngineTest.failingNegotiator(param.providerType.protocol(), PREFERRED_APPLICATION_LEVEL_PROTOCOL);
            this.setupHandlers(param, apn);
            this.runTest();
        }
        catch (SkipTestException e) {
            throw new TestAbortedException("Not expected", (Throwable)e);
        }
    }

    @MethodSource(value={"newJdkParams"})
    @ParameterizedTest
    public void testTlsExtensionNoCompatibleProtocolsNoHandshakeFailure(JdkSSLEngineTestParam param) throws Exception {
        try {
            param.providerType.activate(this);
            ApplicationProtocolConfig clientApn = JdkSslEngineTest.acceptingNegotiator(param.providerType.protocol(), PREFERRED_APPLICATION_LEVEL_PROTOCOL);
            ApplicationProtocolConfig serverApn = JdkSslEngineTest.acceptingNegotiator(param.providerType.protocol(), APPLICATION_LEVEL_PROTOCOL_NOT_COMPATIBLE);
            this.setupHandlers(param, serverApn, clientApn);
            this.runTest(null);
        }
        catch (SkipTestException e) {
            throw new TestAbortedException("Not expected", (Throwable)e);
        }
    }

    @MethodSource(value={"newJdkParams"})
    @ParameterizedTest
    public void testTlsExtensionNoCompatibleProtocolsClientHandshakeFailure(JdkSSLEngineTestParam param) throws Exception {
        try {
            param.providerType.activate(this);
            if (param.providerType == ProviderType.NPN_JETTY) {
                ApplicationProtocolConfig clientApn = JdkSslEngineTest.failingNegotiator(param.providerType.protocol(), PREFERRED_APPLICATION_LEVEL_PROTOCOL);
                ApplicationProtocolConfig serverApn = JdkSslEngineTest.acceptingNegotiator(param.providerType.protocol(), APPLICATION_LEVEL_PROTOCOL_NOT_COMPATIBLE);
                this.setupHandlers(param, serverApn, clientApn);
                Assertions.assertTrue((boolean)this.clientLatch.await(2L, TimeUnit.SECONDS));
                Assertions.assertTrue((boolean)(this.clientException instanceof SSLHandshakeException));
            } else {
                SelfSignedCertificate ssc = new SelfSignedCertificate();
                JdkAlpnApplicationProtocolNegotiator clientApn = new JdkAlpnApplicationProtocolNegotiator(true, true, new String[]{PREFERRED_APPLICATION_LEVEL_PROTOCOL});
                JdkAlpnApplicationProtocolNegotiator serverApn = new JdkAlpnApplicationProtocolNegotiator(new JdkApplicationProtocolNegotiator.ProtocolSelectorFactory(){

                    public JdkApplicationProtocolNegotiator.ProtocolSelector newSelector(SSLEngine engine, Set<String> supportedProtocols) {
                        return new JdkApplicationProtocolNegotiator.ProtocolSelector(){

                            public void unsupported() {
                            }

                            public String select(List<String> protocols) {
                                return JdkSslEngineTest.APPLICATION_LEVEL_PROTOCOL_NOT_COMPATIBLE;
                            }
                        };
                    }
                }, JdkBaseApplicationProtocolNegotiator.FAIL_SELECTION_LISTENER_FACTORY, new String[]{APPLICATION_LEVEL_PROTOCOL_NOT_COMPATIBLE});
                JdkSslServerContext serverSslCtx = new JdkSslServerContext(param.providerType.provider(), ssc.certificate(), ssc.privateKey(), null, null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, (JdkApplicationProtocolNegotiator)serverApn, 0L, 0L, null);
                JdkSslClientContext clientSslCtx = new JdkSslClientContext(param.providerType.provider(), null, InsecureTrustManagerFactory.INSTANCE, null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, (JdkApplicationProtocolNegotiator)clientApn, 0L, 0L);
                this.setupHandlers(param.type(), param.delegate(), (SslContext)new TestDelegatingSslContext(param, (SslContext)serverSslCtx), (SslContext)new TestDelegatingSslContext(param, (SslContext)clientSslCtx));
                Assertions.assertTrue((boolean)this.clientLatch.await(2L, TimeUnit.SECONDS));
                Assertions.assertTrue((this.clientException instanceof SSLHandshakeException || this.clientException == null ? 1 : 0) != 0);
            }
        }
        catch (SkipTestException e) {
            throw new TestAbortedException("Not expected", (Throwable)e);
        }
    }

    @MethodSource(value={"newJdkParams"})
    @ParameterizedTest
    public void testTlsExtensionNoCompatibleProtocolsServerHandshakeFailure(JdkSSLEngineTestParam param) throws Exception {
        try {
            param.providerType.activate(this);
            ApplicationProtocolConfig clientApn = JdkSslEngineTest.acceptingNegotiator(param.providerType.protocol(), PREFERRED_APPLICATION_LEVEL_PROTOCOL);
            ApplicationProtocolConfig serverApn = JdkSslEngineTest.failingNegotiator(param.providerType.protocol(), APPLICATION_LEVEL_PROTOCOL_NOT_COMPATIBLE);
            this.setupHandlers(param, serverApn, clientApn);
            Assertions.assertTrue((boolean)this.serverLatch.await(2L, TimeUnit.SECONDS));
            Assertions.assertTrue((boolean)(this.serverException instanceof SSLHandshakeException));
        }
        catch (SkipTestException e) {
            throw new TestAbortedException("Not expected", (Throwable)e);
        }
    }

    @MethodSource(value={"newJdkParams"})
    @ParameterizedTest
    public void testAlpnCompatibleProtocolsDifferentClientOrder(JdkSSLEngineTestParam param) throws Exception {
        try {
            param.providerType.activate(this);
            if (param.providerType == ProviderType.NPN_JETTY) {
                throw JdkSslEngineTest.tlsExtensionNotFound(param.providerType.protocol());
            }
            ApplicationProtocolConfig clientApn = JdkSslEngineTest.acceptingNegotiator(ApplicationProtocolConfig.Protocol.ALPN, FALLBACK_APPLICATION_LEVEL_PROTOCOL, PREFERRED_APPLICATION_LEVEL_PROTOCOL);
            ApplicationProtocolConfig serverApn = JdkSslEngineTest.failingNegotiator(ApplicationProtocolConfig.Protocol.ALPN, PREFERRED_APPLICATION_LEVEL_PROTOCOL, FALLBACK_APPLICATION_LEVEL_PROTOCOL);
            this.setupHandlers(param, serverApn, clientApn);
            Assertions.assertNull((Object)this.serverException);
            this.runTest(PREFERRED_APPLICATION_LEVEL_PROTOCOL);
        }
        catch (SkipTestException e) {
            throw new TestAbortedException("Not expected", (Throwable)e);
        }
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testEnablingAnAlreadyDisabledSslProtocol(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        this.testEnablingAnAlreadyDisabledSslProtocol(param, new String[0], new String[]{"TLSv1.2"});
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    @Disabled
    public void testMutualAuthValidClientCertChainTooLongFailOptionalClientAuth(SSLEngineTest.SSLEngineTestParam param) throws Exception {
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    @Disabled
    public void testMutualAuthValidClientCertChainTooLongFailRequireClientAuth(SSLEngineTest.SSLEngineTestParam param) throws Exception {
    }

    @Override
    protected boolean mySetupMutualAuthServerIsValidException(Throwable cause) {
        return super.mySetupMutualAuthServerIsValidException(cause) || JdkSslEngineTest.causedBySSLException(cause);
    }

    private void runTest() throws Exception {
        this.runTest(PREFERRED_APPLICATION_LEVEL_PROTOCOL);
    }

    @Override
    protected SslProvider sslClientProvider() {
        return SslProvider.JDK;
    }

    @Override
    protected SslProvider sslServerProvider() {
        return SslProvider.JDK;
    }

    @Override
    protected Provider clientSslContextProvider() {
        return this.provider;
    }

    @Override
    protected Provider serverSslContextProvider() {
        return this.provider;
    }

    private static ApplicationProtocolConfig failingNegotiator(ApplicationProtocolConfig.Protocol protocol, String ... supportedProtocols) {
        return new ApplicationProtocolConfig(protocol, ApplicationProtocolConfig.SelectorFailureBehavior.FATAL_ALERT, ApplicationProtocolConfig.SelectedListenerFailureBehavior.FATAL_ALERT, supportedProtocols);
    }

    private static ApplicationProtocolConfig acceptingNegotiator(ApplicationProtocolConfig.Protocol protocol, String ... supportedProtocols) {
        return new ApplicationProtocolConfig(protocol, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, supportedProtocols);
    }

    private static SkipTestException tlsExtensionNotFound(ApplicationProtocolConfig.Protocol protocol) {
        throw new SkipTestException(protocol + " not on classpath");
    }

    private static final class TestDelegatingSslContext
    extends DelegatingSslContext {
        private final SSLEngineTest.SSLEngineTestParam param;

        TestDelegatingSslContext(SSLEngineTest.SSLEngineTestParam param, SslContext ctx) {
            super(ctx);
            this.param = param;
        }

        protected void initEngine(SSLEngine engine) {
            engine.setEnabledProtocols(this.param.protocols().toArray(EmptyArrays.EMPTY_STRINGS));
            engine.setEnabledCipherSuites(this.param.ciphers().toArray(EmptyArrays.EMPTY_STRINGS));
        }
    }

    private static final class SkipTestException
    extends RuntimeException {
        private static final long serialVersionUID = 9214869217774035223L;

        SkipTestException(String message) {
            super(message);
        }
    }

    private static final class JdkSSLEngineTestParam
    extends SSLEngineTest.SSLEngineTestParam {
        final ProviderType providerType;

        JdkSSLEngineTestParam(ProviderType providerType, SSLEngineTest.SSLEngineTestParam param) {
            super(param.type(), param.combo(), param.delegate());
            this.providerType = providerType;
        }

        @Override
        public String toString() {
            return "JdkSSLEngineTestParam{type=" + (Object)((Object)this.type()) + ", protocolCipherCombo=" + this.combo() + ", delegate=" + this.delegate() + ", providerType=" + (Object)((Object)this.providerType) + '}';
        }
    }

    public static enum ProviderType {
        NPN_JETTY{

            @Override
            boolean isAvailable() {
                return JettyNpnSslEngine.isAvailable();
            }

            @Override
            ApplicationProtocolConfig.Protocol protocol() {
                return ApplicationProtocolConfig.Protocol.NPN;
            }

            @Override
            Provider provider() {
                return null;
            }
        }
        ,
        ALPN_JETTY{

            @Override
            boolean isAvailable() {
                return JettyAlpnSslEngine.isAvailable();
            }

            @Override
            ApplicationProtocolConfig.Protocol protocol() {
                return ApplicationProtocolConfig.Protocol.ALPN;
            }

            @Override
            Provider provider() {
                return null;
            }
        }
        ,
        ALPN_JAVA{

            @Override
            boolean isAvailable() {
                return JdkAlpnSslUtils.supportsAlpn();
            }

            @Override
            ApplicationProtocolConfig.Protocol protocol() {
                return ApplicationProtocolConfig.Protocol.ALPN;
            }

            @Override
            Provider provider() {
                return null;
            }
        }
        ,
        ALPN_CONSCRYPT{
            private Provider provider;

            @Override
            boolean isAvailable() {
                return Conscrypt.isAvailable();
            }

            @Override
            ApplicationProtocolConfig.Protocol protocol() {
                return ApplicationProtocolConfig.Protocol.ALPN;
            }

            @Override
            Provider provider() {
                try {
                    if (this.provider == null) {
                        this.provider = (Provider)Class.forName("org.conscrypt.OpenSSLProvider").getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    return this.provider;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        };


        abstract boolean isAvailable();

        abstract ApplicationProtocolConfig.Protocol protocol();

        abstract Provider provider();

        final void activate(JdkSslEngineTest instance) {
            if (!this.isAvailable()) {
                throw JdkSslEngineTest.tlsExtensionNotFound(this.protocol());
            }
            instance.provider = this.provider();
        }
    }
}

