/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.handler.ssl.OpenSslCachingKeyMaterialProvider;
import io.netty.handler.ssl.OpenSslCachingX509KeyManagerFactory;
import io.netty.handler.ssl.OpenSslKeyMaterial;
import io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import io.netty.handler.ssl.OpenSslKeyMaterialProviderTest;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OpenSslCachingKeyMaterialProviderTest
extends OpenSslKeyMaterialProviderTest {
    @Override
    protected KeyManagerFactory newKeyManagerFactory() throws Exception {
        return new OpenSslCachingX509KeyManagerFactory(super.newKeyManagerFactory());
    }

    @Override
    protected OpenSslKeyMaterialProvider newMaterialProvider(KeyManagerFactory factory, String password) {
        return new OpenSslCachingKeyMaterialProvider(ReferenceCountedOpenSslContext.chooseX509KeyManager((KeyManager[])factory.getKeyManagers()), password, Integer.MAX_VALUE);
    }

    @Override
    protected void assertRelease(OpenSslKeyMaterial material) {
        Assertions.assertFalse((boolean)material.release());
    }

    @Test
    public void testMaterialCached() throws Exception {
        OpenSslKeyMaterialProvider provider = this.newMaterialProvider(this.newKeyManagerFactory(), "example");
        OpenSslKeyMaterial material = provider.chooseKeyMaterial((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, "1");
        Assertions.assertNotNull((Object)material);
        Assertions.assertNotEquals((long)0L, (long)material.certificateChainAddress());
        Assertions.assertNotEquals((long)0L, (long)material.privateKeyAddress());
        Assertions.assertEquals((int)2, (int)material.refCnt());
        OpenSslKeyMaterial material2 = provider.chooseKeyMaterial((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, "1");
        Assertions.assertNotNull((Object)material2);
        Assertions.assertEquals((long)material.certificateChainAddress(), (long)material2.certificateChainAddress());
        Assertions.assertEquals((long)material.privateKeyAddress(), (long)material2.privateKeyAddress());
        Assertions.assertEquals((int)3, (int)material.refCnt());
        Assertions.assertEquals((int)3, (int)material2.refCnt());
        Assertions.assertFalse((boolean)material.release());
        Assertions.assertFalse((boolean)material2.release());
        provider.destroy();
        Assertions.assertEquals((int)0, (int)material.refCnt());
        Assertions.assertEquals((int)0, (int)material2.refCnt());
    }

    @Test
    public void testCacheForSunX509() throws Exception {
        OpenSslCachingX509KeyManagerFactory factory = new OpenSslCachingX509KeyManagerFactory(super.newKeyManagerFactory("SunX509"));
        OpenSslKeyMaterialProvider provider = factory.newProvider("example");
        MatcherAssert.assertThat((Object)provider, (Matcher)CoreMatchers.instanceOf(OpenSslCachingKeyMaterialProvider.class));
    }

    @Test
    public void testNotCacheForX509() throws Exception {
        OpenSslCachingX509KeyManagerFactory factory = new OpenSslCachingX509KeyManagerFactory(super.newKeyManagerFactory("PKIX"));
        OpenSslKeyMaterialProvider provider = factory.newProvider("example");
        MatcherAssert.assertThat((Object)provider, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(OpenSslCachingKeyMaterialProvider.class)));
    }
}

