/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslCertificateException;
import io.netty.internal.tcnative.CertificateVerifier;
import java.lang.reflect.Field;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class OpenSslCertificateExceptionTest {
    @BeforeAll
    public static void ensureOpenSsl() {
        OpenSsl.ensureAvailability();
    }

    @Test
    public void testValidErrorCode() throws Exception {
        Field[] fields;
        for (Field field : fields = CertificateVerifier.class.getFields()) {
            if (!field.isAccessible()) continue;
            int errorCode = field.getInt(null);
            OpenSslCertificateException exception = new OpenSslCertificateException(errorCode);
            Assertions.assertEquals((int)errorCode, (int)exception.errorCode());
        }
    }

    @Test
    public void testNonValidErrorCode() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                new OpenSslCertificateException(Integer.MIN_VALUE);
            }
        });
    }

    @Test
    public void testCanBeInstancedWhenOpenSslIsNotAvailable() {
        new OpenSslCertificateException(0);
    }
}

