/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.pcap;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.pcap.DiscardingStatsOutputStream;
import io.netty.handler.pcap.PcapWriteHandler;
import io.netty.handler.pcap.State;
import io.netty.util.CharsetUtil;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.Promise;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class PcapWriteHandlerTest {
    @Test
    public void udpV4SharedOutputStreamTest() throws InterruptedException {
        PcapWriteHandlerTest.udpV4(true);
    }

    @Test
    public void udpV4NonOutputStream() throws InterruptedException {
        PcapWriteHandlerTest.udpV4(false);
    }

    private static void udpV4(boolean sharedOutputStream) throws InterruptedException {
        ByteBuf byteBuf = Unpooled.buffer();
        InetSocketAddress serverAddr = new InetSocketAddress("127.0.0.1", 0);
        InetSocketAddress clientAddr = new InetSocketAddress("127.0.0.1", 0);
        NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup(2);
        Bootstrap server = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)eventLoopGroup)).channel(NioDatagramChannel.class)).handler((ChannelHandler)new SimpleChannelInboundHandler<DatagramPacket>(){

            protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket msg) {
            }
        });
        ChannelFuture channelFutureServer = server.bind((SocketAddress)serverAddr).sync();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channelFutureServer.isSuccess());
        Bootstrap client = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)eventLoopGroup)).channel(NioDatagramChannel.class)).handler((ChannelHandler)PcapWriteHandler.builder().sharedOutputStream(sharedOutputStream).build((OutputStream)new ByteBufOutputStream(byteBuf)));
        ChannelFuture channelFutureClient = client.connect(channelFutureServer.channel().localAddress(), (SocketAddress)clientAddr).sync();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channelFutureClient.isSuccess());
        Channel clientChannel = channelFutureClient.channel();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)clientChannel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])"Meow".getBytes())).sync().isSuccess());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)eventLoopGroup.shutdownGracefully().sync().isSuccess());
        PcapWriteHandlerTest.verifyUdpCapture(!sharedOutputStream, byteBuf, (InetSocketAddress)clientChannel.remoteAddress(), (InetSocketAddress)clientChannel.localAddress());
    }

    @Test
    public void embeddedUdp() {
        ByteBuf pcapBuffer = Unpooled.buffer();
        ByteBuf payload = Unpooled.wrappedBuffer((byte[])"Meow".getBytes());
        InetSocketAddress serverAddr = new InetSocketAddress("1.1.1.1", 1234);
        InetSocketAddress clientAddr = new InetSocketAddress("2.2.2.2", 3456);
        EmbeddedChannel embeddedChannel = new EmbeddedChannel(new ChannelHandler[]{PcapWriteHandler.builder().forceUdpChannel(clientAddr, serverAddr).build((OutputStream)new ByteBufOutputStream(pcapBuffer))});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)embeddedChannel.writeOutbound(new Object[]{payload}));
        org.junit.jupiter.api.Assertions.assertEquals((Object)payload, (Object)embeddedChannel.readOutbound());
        PcapWriteHandlerTest.verifyUdpCapture(true, pcapBuffer, serverAddr, clientAddr);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)embeddedChannel.finishAndReleaseAll());
    }

    @Test
    public void tcpV4SharedOutputStreamTest() throws Exception {
        PcapWriteHandlerTest.tcpV4(true);
    }

    @Test
    public void tcpV4NonOutputStream() throws Exception {
        PcapWriteHandlerTest.tcpV4(false);
    }

    private static void tcpV4(final boolean sharedOutputStream) throws Exception {
        final ByteBuf byteBuf = Unpooled.buffer();
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup clientGroup = new NioEventLoopGroup();
        ServerBootstrap sb = new ServerBootstrap();
        final Promise dataReadPromise = bossGroup.next().newPromise();
        ((ServerBootstrap)((ServerBootstrap)sb.group((EventLoopGroup)bossGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)100)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new ChannelHandler[]{PcapWriteHandler.builder().sharedOutputStream(sharedOutputStream).build((OutputStream)new ByteBufOutputStream(byteBuf))});
                p.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void channelRead(ChannelHandlerContext ctx, Object msg) {
                        ctx.write(msg);
                    }

                    public void channelReadComplete(ChannelHandlerContext ctx) {
                        ctx.flush();
                        dataReadPromise.setSuccess((Object)true);
                    }

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                        ctx.close();
                    }
                }});
            }
        });
        ChannelFuture serverChannelFuture = sb.bind((SocketAddress)new InetSocketAddress("127.0.0.1", 0)).sync();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)serverChannelFuture.isSuccess());
        Bootstrap cb = new Bootstrap();
        final Promise dataWrittenPromise = clientGroup.next().newPromise();
        ((Bootstrap)((Bootstrap)((Bootstrap)cb.group((EventLoopGroup)clientGroup)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void channelActive(ChannelHandlerContext ctx) {
                        ctx.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])"Meow".getBytes()));
                        dataWrittenPromise.setSuccess((Object)true);
                    }

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                        ctx.close();
                    }
                }});
            }
        });
        ChannelFuture clientChannelFuture = cb.connect(serverChannelFuture.channel().localAddress()).sync();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)clientChannelFuture.isSuccess());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)dataWrittenPromise.await(5L, TimeUnit.SECONDS));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)dataReadPromise.await(5L, TimeUnit.SECONDS));
        clientChannelFuture.channel().close().sync();
        serverChannelFuture.channel().close().sync();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)clientGroup.shutdownGracefully().sync().isSuccess());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)bossGroup.shutdownGracefully().sync().isSuccess());
        PcapWriteHandlerTest.verifyTcpCapture(!sharedOutputStream, byteBuf, (InetSocketAddress)serverChannelFuture.channel().localAddress(), (InetSocketAddress)clientChannelFuture.channel().localAddress());
    }

    @Test
    public void embeddedTcp() {
        ByteBuf pcapBuffer = Unpooled.buffer();
        ByteBuf payload = Unpooled.wrappedBuffer((byte[])"Meow".getBytes());
        InetSocketAddress serverAddr = new InetSocketAddress("1.1.1.1", 1234);
        InetSocketAddress clientAddr = new InetSocketAddress("2.2.2.2", 3456);
        EmbeddedChannel embeddedChannel = new EmbeddedChannel(new ChannelHandler[]{PcapWriteHandler.builder().forceTcpChannel(serverAddr, clientAddr, true).build((OutputStream)new ByteBufOutputStream(pcapBuffer))});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)embeddedChannel.writeInbound(new Object[]{payload}));
        org.junit.jupiter.api.Assertions.assertEquals((Object)payload, (Object)embeddedChannel.readInbound());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)embeddedChannel.writeOutbound(new Object[]{payload}));
        org.junit.jupiter.api.Assertions.assertEquals((Object)payload, (Object)embeddedChannel.readOutbound());
        PcapWriteHandlerTest.verifyTcpCapture(true, pcapBuffer, serverAddr, clientAddr);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)embeddedChannel.finishAndReleaseAll());
    }

    @Test
    public void writerStateTest() throws Exception {
        ByteBuf payload = Unpooled.wrappedBuffer((byte[])"Meow".getBytes());
        InetSocketAddress serverAddr = new InetSocketAddress("1.1.1.1", 1234);
        InetSocketAddress clientAddr = new InetSocketAddress("2.2.2.2", 3456);
        PcapWriteHandler pcapWriteHandler = PcapWriteHandler.builder().forceTcpChannel(serverAddr, clientAddr, true).build(new OutputStream(){

            @Override
            public void write(int b) {
            }
        });
        org.junit.jupiter.api.Assertions.assertEquals((Object)State.INIT, (Object)pcapWriteHandler.state());
        EmbeddedChannel embeddedChannel = new EmbeddedChannel(new ChannelHandler[]{pcapWriteHandler});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)embeddedChannel.writeInbound(new Object[]{payload}));
        org.junit.jupiter.api.Assertions.assertEquals((Object)payload, (Object)embeddedChannel.readInbound());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)embeddedChannel.writeOutbound(new Object[]{payload}));
        org.junit.jupiter.api.Assertions.assertEquals((Object)payload, (Object)embeddedChannel.readOutbound());
        org.junit.jupiter.api.Assertions.assertEquals((Object)State.WRITING, (Object)pcapWriteHandler.state());
        pcapWriteHandler.pCapWriter().close();
        org.junit.jupiter.api.Assertions.assertEquals((Object)State.CLOSED, (Object)pcapWriteHandler.state());
        pcapWriteHandler.close();
        org.junit.jupiter.api.Assertions.assertEquals((Object)State.CLOSED, (Object)pcapWriteHandler.state());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)embeddedChannel.finishAndReleaseAll());
    }

    @Test
    public void pauseResumeTest() throws Exception {
        int i;
        byte[] payload = "Meow".getBytes();
        InetSocketAddress serverAddr = new InetSocketAddress("1.1.1.1", 1234);
        InetSocketAddress clientAddr = new InetSocketAddress("2.2.2.2", 3456);
        DiscardingStatsOutputStream discardingStatsOutputStream = new DiscardingStatsOutputStream();
        PcapWriteHandler pcapWriteHandler = PcapWriteHandler.builder().forceTcpChannel(serverAddr, clientAddr, true).build((OutputStream)discardingStatsOutputStream);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)discardingStatsOutputStream.writesCalled());
        EmbeddedChannel embeddedChannel = new EmbeddedChannel(new ChannelHandler[]{pcapWriteHandler});
        for (int i2 = 0; i2 < 10; ++i2) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)embeddedChannel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])payload)}));
        }
        int initialWritesCalled = discardingStatsOutputStream.writesCalled();
        Assertions.assertThat((int)initialWritesCalled).isGreaterThan(0);
        pcapWriteHandler.pause();
        org.junit.jupiter.api.Assertions.assertEquals((Object)State.PAUSED, (Object)pcapWriteHandler.state());
        for (i = 0; i < 100; ++i) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)embeddedChannel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])payload)}));
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)initialWritesCalled, (int)discardingStatsOutputStream.writesCalled());
        pcapWriteHandler.resume();
        org.junit.jupiter.api.Assertions.assertEquals((Object)State.WRITING, (Object)pcapWriteHandler.state());
        for (i = 0; i < 100; ++i) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)embeddedChannel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])payload)}));
        }
        Assertions.assertThat((int)discardingStatsOutputStream.writesCalled()).isGreaterThan(initialWritesCalled);
        pcapWriteHandler.close();
        org.junit.jupiter.api.Assertions.assertEquals((Object)State.CLOSED, (Object)pcapWriteHandler.state());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)embeddedChannel.finishAndReleaseAll());
    }

    private static void verifyGlobalHeaders(ByteBuf byteBuf) {
        org.junit.jupiter.api.Assertions.assertEquals((int)-1582119980, (int)byteBuf.readInt());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)byteBuf.readShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)byteBuf.readShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)byteBuf.readInt());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)byteBuf.readInt());
        org.junit.jupiter.api.Assertions.assertEquals((int)65535, (int)byteBuf.readInt());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)byteBuf.readInt());
    }

    private static void verifyTcpCapture(boolean verifyGlobalHeaders, ByteBuf byteBuf, InetSocketAddress serverAddr, InetSocketAddress clientAddr) {
        if (verifyGlobalHeaders) {
            PcapWriteHandlerTest.verifyGlobalHeaders(byteBuf);
        }
        byteBuf.readInt();
        byteBuf.readInt();
        org.junit.jupiter.api.Assertions.assertEquals((int)54, (int)byteBuf.readInt());
        org.junit.jupiter.api.Assertions.assertEquals((int)54, (int)byteBuf.readInt());
        ByteBuf ethernetPacket = byteBuf.readSlice(54);
        ByteBuf dstMac = ethernetPacket.readSlice(6);
        ByteBuf srcMac = ethernetPacket.readSlice(6);
        org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])new byte[]{0, 0, 94, 0, 83, -1}, (byte[])ByteBufUtil.getBytes((ByteBuf)dstMac));
        org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])new byte[]{0, 0, 94, 0, 83, 0}, (byte[])ByteBufUtil.getBytes((ByteBuf)srcMac));
        org.junit.jupiter.api.Assertions.assertEquals((int)2048, (int)ethernetPacket.readShort());
        ByteBuf ipv4Packet = ethernetPacket.readSlice(32);
        org.junit.jupiter.api.Assertions.assertEquals((int)69, (int)ipv4Packet.readByte());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ipv4Packet.readByte());
        org.junit.jupiter.api.Assertions.assertEquals((int)40, (int)ipv4Packet.readShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ipv4Packet.readShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ipv4Packet.readShort());
        org.junit.jupiter.api.Assertions.assertEquals((byte)-1, (byte)ipv4Packet.readByte());
        org.junit.jupiter.api.Assertions.assertEquals((byte)6, (byte)ipv4Packet.readByte());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ipv4Packet.readShort());
        ipv4Packet.readInt();
        org.junit.jupiter.api.Assertions.assertEquals((int)NetUtil.ipv4AddressToInt((Inet4Address)((Inet4Address)serverAddr.getAddress())), (int)ipv4Packet.readInt());
        ByteBuf tcpPacket = ipv4Packet.readSlice(12);
        org.junit.jupiter.api.Assertions.assertEquals((int)(clientAddr.getPort() & 0xFFFF), (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)(serverAddr.getPort() & 0xFFFF), (int)tcpPacket.readUnsignedShort());
    }

    private static void verifyUdpCapture(boolean verifyGlobalHeaders, ByteBuf byteBuf, InetSocketAddress remoteAddress, InetSocketAddress localAddress) {
        if (verifyGlobalHeaders) {
            PcapWriteHandlerTest.verifyGlobalHeaders(byteBuf);
        }
        byteBuf.readInt();
        byteBuf.readInt();
        org.junit.jupiter.api.Assertions.assertEquals((int)46, (int)byteBuf.readInt());
        org.junit.jupiter.api.Assertions.assertEquals((int)46, (int)byteBuf.readInt());
        ByteBuf ethernetPacket = byteBuf.readBytes(46);
        ByteBuf dstMac = ethernetPacket.readBytes(6);
        ByteBuf srcMac = ethernetPacket.readBytes(6);
        org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])new byte[]{0, 0, 94, 0, 83, -1}, (byte[])ByteBufUtil.getBytes((ByteBuf)dstMac));
        org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])new byte[]{0, 0, 94, 0, 83, 0}, (byte[])ByteBufUtil.getBytes((ByteBuf)srcMac));
        org.junit.jupiter.api.Assertions.assertEquals((int)2048, (int)ethernetPacket.readShort());
        ByteBuf ipv4Packet = ethernetPacket.readBytes(32);
        org.junit.jupiter.api.Assertions.assertEquals((int)69, (int)ipv4Packet.readByte());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ipv4Packet.readByte());
        org.junit.jupiter.api.Assertions.assertEquals((int)32, (int)ipv4Packet.readShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ipv4Packet.readShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ipv4Packet.readShort());
        org.junit.jupiter.api.Assertions.assertEquals((byte)-1, (byte)ipv4Packet.readByte());
        org.junit.jupiter.api.Assertions.assertEquals((byte)17, (byte)ipv4Packet.readByte());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ipv4Packet.readShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)NetUtil.ipv4AddressToInt((Inet4Address)((Inet4Address)localAddress.getAddress())), (int)ipv4Packet.readInt());
        org.junit.jupiter.api.Assertions.assertEquals((int)NetUtil.ipv4AddressToInt((Inet4Address)((Inet4Address)remoteAddress.getAddress())), (int)ipv4Packet.readInt());
        ByteBuf udpPacket = ipv4Packet.readBytes(12);
        org.junit.jupiter.api.Assertions.assertEquals((int)(localAddress.getPort() & 0xFFFF), (int)udpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)(remoteAddress.getPort() & 0xFFFF), (int)udpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)12, (int)udpPacket.readShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)udpPacket.readShort());
        ByteBuf payload = udpPacket.readBytes(4);
        org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])"Meow".getBytes(CharsetUtil.UTF_8), (byte[])ByteBufUtil.getBytes((ByteBuf)payload));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)dstMac.release());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)srcMac.release());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)payload.release());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)byteBuf.release());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ethernetPacket.release());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ipv4Packet.release());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)udpPacket.release());
    }
}

