/*
 * Decompiled with CFR 0.152.
 */
package io.netty.pkitesting;

import java.security.GeneralSecurityException;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Locale;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

final class Algorithms {
    private static Provider bouncyCastle;

    private Algorithms() {
    }

    static String oidForAlgorithmName(String algorithmIdentifier) {
        switch (algorithmIdentifier.toLowerCase(Locale.ROOT)) {
            case "sha256withecdsa": {
                return "1.2.840.10045.4.3.2";
            }
            case "sha384withecdsa": {
                return "1.2.840.10045.4.3.3";
            }
            case "sha256withrsa": {
                return "1.2.840.113549.1.1.11";
            }
            case "sha384withrsa": {
                return "1.2.840.113549.1.1.12";
            }
            case "ed25519": {
                return "1.3.101.112";
            }
            case "ed448": {
                return "1.3.101.113";
            }
            case "ml-dsa-44": {
                return "2.16.840.1.101.3.4.3.17";
            }
            case "ml-dsa-65": {
                return "2.16.840.1.101.3.4.3.18";
            }
            case "ml-dsa-87": {
                return "2.16.840.1.101.3.4.3.19";
            }
        }
        throw new UnsupportedOperationException("Algorithm not supported: " + algorithmIdentifier);
    }

    static KeyPairGenerator keyPairGenerator(String keyType, AlgorithmParameterSpec spec, SecureRandom rng) throws GeneralSecurityException {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(keyType);
            keyGen.initialize(spec, rng);
            return keyGen;
        }
        catch (GeneralSecurityException e) {
            try {
                KeyPairGenerator keyGen = KeyPairGenerator.getInstance(keyType, Algorithms.bouncyCastle());
                keyGen.initialize(spec, rng);
                return keyGen;
            }
            catch (GeneralSecurityException ex) {
                e.addSuppressed(ex);
                throw e;
            }
        }
    }

    static Signature signature(String algorithmIdentifier) throws NoSuchAlgorithmException {
        try {
            return Signature.getInstance(algorithmIdentifier);
        }
        catch (NoSuchAlgorithmException e) {
            try {
                return Signature.getInstance(algorithmIdentifier, Algorithms.bouncyCastle());
            }
            catch (NoSuchAlgorithmException ex) {
                e.addSuppressed(ex);
                throw e;
            }
        }
    }

    private static synchronized Provider bouncyCastle() {
        if (bouncyCastle == null) {
            bouncyCastle = new BouncyCastleProvider();
        }
        return bouncyCastle;
    }
}

