/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns.macos;

import io.netty.resolver.dns.DnsServerAddressStream;
import io.netty.resolver.dns.DnsServerAddressStreamProviders;
import io.netty.resolver.dns.macos.MacOSDnsServerAddressStreamProvider;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;

@EnabledOnOs(value={OS.MAC})
class MacOSDnsServerAddressStreamProviderTest {
    MacOSDnsServerAddressStreamProviderTest() {
    }

    @Test
    void testStream() {
        MacOSDnsServerAddressStreamProvider.ensureAvailability();
        MacOSDnsServerAddressStreamProvider provider = new MacOSDnsServerAddressStreamProvider();
        DnsServerAddressStream stream = provider.nameServerAddressStream("netty.io");
        Assertions.assertNotNull((Object)stream);
        Assertions.assertNotEquals((int)0, (int)stream.size());
        for (int i = 0; i < stream.size(); ++i) {
            Assertions.assertNotEquals((int)0, (int)stream.next().getPort());
        }
    }

    @Test
    @EnabledOnOs(value={OS.MAC})
    void testDefaultUseCorrectInstance() {
        MacOSDnsServerAddressStreamProvider.ensureAvailability();
        MatcherAssert.assertThat((Object)DnsServerAddressStreamProviders.platformDefault(), (Matcher)Matchers.instanceOf(MacOSDnsServerAddressStreamProvider.class));
    }
}

