/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.buffer.Unpooled;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.dns.DatagramDnsQuery;
import io.netty.handler.codec.dns.DefaultDnsRawRecord;
import io.netty.handler.codec.dns.DnsQuery;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.handler.codec.dns.DnsResponse;
import io.netty.handler.codec.dns.DnsSection;
import io.netty.resolver.dns.DnsNameResolver;
import io.netty.resolver.dns.DnsNameResolverException;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.OneTimeTask;
import io.netty.util.internal.ThreadLocalRandom;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;

final class DnsQueryContext {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DnsQueryContext.class);
    private final DnsNameResolver parent;
    private final Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> promise;
    private final int id;
    private final DnsQuestion question;
    private final DnsRecord optResource;
    private final InetSocketAddress nameServerAddr;
    private final boolean recursionDesired;
    private volatile ScheduledFuture<?> timeoutFuture;

    DnsQueryContext(DnsNameResolver parent, InetSocketAddress nameServerAddr, DnsQuestion question, Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> promise) {
        this.parent = parent;
        this.nameServerAddr = nameServerAddr;
        this.question = question;
        this.promise = promise;
        this.id = this.allocateId();
        this.recursionDesired = parent.isRecursionDesired();
        this.optResource = new DefaultDnsRawRecord("", DnsRecordType.OPT, parent.maxPayloadSize(), 0L, Unpooled.EMPTY_BUFFER);
    }

    private int allocateId() {
        int id = ThreadLocalRandom.current().nextInt(this.parent.promises.length());
        int maxTries = this.parent.promises.length() << 1;
        int tries = 0;
        do {
            if (this.parent.promises.compareAndSet(id, null, this)) {
                return id;
            }
            id = id + 1 & 0xFFFF;
        } while (++tries < maxTries);
        throw new IllegalStateException("query ID space exhausted: " + this.question);
    }

    void query() {
        DnsQuestion question = this.question;
        DatagramDnsQuery query = new DatagramDnsQuery(null, this.nameServerAddr, this.id);
        query.setRecursionDesired(this.recursionDesired);
        query.setRecord(DnsSection.QUESTION, (DnsRecord)question);
        query.setRecord(DnsSection.ADDITIONAL, this.optResource);
        if (logger.isDebugEnabled()) {
            logger.debug("{} WRITE: [{}: {}], {}", new Object[]{this.parent.ch, this.id, this.nameServerAddr, question});
        }
        this.sendQuery((DnsQuery)query);
    }

    private void sendQuery(final DnsQuery query) {
        if (this.parent.bindFuture.isDone()) {
            this.writeQuery(query);
        } else {
            this.parent.bindFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        DnsQueryContext.this.writeQuery(query);
                    } else {
                        DnsQueryContext.this.promise.tryFailure(future.cause());
                    }
                }
            });
        }
    }

    private void writeQuery(DnsQuery query) {
        final ChannelFuture writeFuture = this.parent.ch.writeAndFlush((Object)query);
        if (writeFuture.isDone()) {
            this.onQueryWriteCompletion(writeFuture);
        } else {
            writeFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    DnsQueryContext.this.onQueryWriteCompletion(writeFuture);
                }
            });
        }
    }

    private void onQueryWriteCompletion(ChannelFuture writeFuture) {
        if (!writeFuture.isSuccess()) {
            this.setFailure("failed to send a query", writeFuture.cause());
            return;
        }
        final long queryTimeoutMillis = this.parent.queryTimeoutMillis();
        if (queryTimeoutMillis > 0L) {
            this.timeoutFuture = this.parent.ch.eventLoop().schedule((Runnable)new OneTimeTask(){

                public void run() {
                    if (DnsQueryContext.this.promise.isDone()) {
                        return;
                    }
                    DnsQueryContext.this.setFailure("query timed out after " + queryTimeoutMillis + " milliseconds", null);
                }
            }, queryTimeoutMillis, TimeUnit.MILLISECONDS);
        }
    }

    void finish(AddressedEnvelope<? extends DnsResponse, InetSocketAddress> envelope) {
        DnsResponse res = (DnsResponse)envelope.content();
        if (res.count(DnsSection.QUESTION) != 1) {
            logger.warn("Received a DNS response with invalid number of questions: {}", envelope);
            return;
        }
        if (!this.question.equals(res.recordAt(DnsSection.QUESTION))) {
            logger.warn("Received a mismatching DNS response: {}", envelope);
            return;
        }
        this.setSuccess(envelope);
    }

    private void setSuccess(AddressedEnvelope<? extends DnsResponse, InetSocketAddress> envelope) {
        Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> promise;
        this.parent.promises.set(this.id, null);
        ScheduledFuture<?> timeoutFuture = this.timeoutFuture;
        if (timeoutFuture != null) {
            timeoutFuture.cancel(false);
        }
        if ((promise = this.promise).setUncancellable()) {
            AddressedEnvelope castResponse = envelope.retain();
            promise.setSuccess((Object)castResponse);
        }
    }

    private void setFailure(String message, Throwable cause) {
        this.parent.promises.set(this.id, null);
        StringBuilder buf = new StringBuilder(message.length() + 64);
        buf.append('[').append(this.nameServerAddr).append("] ").append(message).append(" (no stack trace available)");
        DnsNameResolverException e = cause != null ? new DnsNameResolverException(this.nameServerAddr, this.question, buf.toString(), cause) : new DnsNameResolverException(this.nameServerAddr, this.question, buf.toString());
        this.promise.tryFailure((Throwable)e);
    }
}

