/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver;

import io.netty.resolver.DefaultHostsFileEntriesResolver;
import io.netty.resolver.HostsFileEntriesProvider;
import io.netty.resolver.ResolvedAddressTypes;
import io.netty.util.NetUtil;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultHostsFileEntriesResolverTest {
    @Test
    public void testCaseInsensitivity() {
        DefaultHostsFileEntriesResolver resolver = new DefaultHostsFileEntriesResolver();
        Assertions.assertEquals((Object)resolver.normalize("localhost"), (Object)resolver.normalize("LOCALHOST"));
    }

    @Test
    public void shouldntFindWhenAddressTypeDoesntMatch() {
        HashMap<String, List<Inet4Address>> inet4Entries = new HashMap<String, List<Inet4Address>>();
        HashMap inet6Entries = new HashMap();
        inet4Entries.put("localhost", Collections.singletonList(NetUtil.LOCALHOST4));
        DefaultHostsFileEntriesResolver resolver = new DefaultHostsFileEntriesResolver(new HostsFileEntriesProvider(inet4Entries, inet6Entries));
        InetAddress address = resolver.address("localhost", ResolvedAddressTypes.IPV6_ONLY);
        Assertions.assertNull((Object)address, (String)"Should pick an IPv6 address");
    }

    @Test
    public void shouldPickIpv4WhenBothAreDefinedButIpv4IsPreferred() {
        HashMap<String, List<Inet4Address>> inet4Entries = new HashMap<String, List<Inet4Address>>();
        HashMap<String, List<Inet6Address>> inet6Entries = new HashMap<String, List<Inet6Address>>();
        inet4Entries.put("localhost", Collections.singletonList(NetUtil.LOCALHOST4));
        inet6Entries.put("localhost", Collections.singletonList(NetUtil.LOCALHOST6));
        DefaultHostsFileEntriesResolver resolver = new DefaultHostsFileEntriesResolver(new HostsFileEntriesProvider(inet4Entries, inet6Entries));
        InetAddress address = resolver.address("localhost", ResolvedAddressTypes.IPV4_PREFERRED);
        MatcherAssert.assertThat((String)"Should pick an IPv4 address", (Object)address, (Matcher)Matchers.instanceOf(Inet4Address.class));
    }

    @Test
    public void shouldPickIpv6WhenBothAreDefinedButIpv6IsPreferred() {
        HashMap<String, List<Inet4Address>> inet4Entries = new HashMap<String, List<Inet4Address>>();
        HashMap<String, List<Inet6Address>> inet6Entries = new HashMap<String, List<Inet6Address>>();
        inet4Entries.put("localhost", Collections.singletonList(NetUtil.LOCALHOST4));
        inet6Entries.put("localhost", Collections.singletonList(NetUtil.LOCALHOST6));
        DefaultHostsFileEntriesResolver resolver = new DefaultHostsFileEntriesResolver(new HostsFileEntriesProvider(inet4Entries, inet6Entries));
        InetAddress address = resolver.address("localhost", ResolvedAddressTypes.IPV6_PREFERRED);
        MatcherAssert.assertThat((String)"Should pick an IPv6 address", (Object)address, (Matcher)Matchers.instanceOf(Inet6Address.class));
    }

    @Test
    public void shouldntFindWhenAddressesTypeDoesntMatch() {
        HashMap<String, List<Inet4Address>> inet4Entries = new HashMap<String, List<Inet4Address>>();
        HashMap inet6Entries = new HashMap();
        inet4Entries.put("localhost", Collections.singletonList(NetUtil.LOCALHOST4));
        DefaultHostsFileEntriesResolver resolver = new DefaultHostsFileEntriesResolver(new HostsFileEntriesProvider(inet4Entries, inet6Entries));
        List addresses = resolver.addresses("localhost", ResolvedAddressTypes.IPV6_ONLY);
        Assertions.assertNull((Object)addresses, (String)"Should pick an IPv6 address");
    }

    @Test
    public void shouldPickIpv4FirstWhenBothAreDefinedButIpv4IsPreferred() {
        HashMap<String, List<Inet4Address>> inet4Entries = new HashMap<String, List<Inet4Address>>();
        HashMap<String, List<Inet6Address>> inet6Entries = new HashMap<String, List<Inet6Address>>();
        inet4Entries.put("localhost", Collections.singletonList(NetUtil.LOCALHOST4));
        inet6Entries.put("localhost", Collections.singletonList(NetUtil.LOCALHOST6));
        DefaultHostsFileEntriesResolver resolver = new DefaultHostsFileEntriesResolver(new HostsFileEntriesProvider(inet4Entries, inet6Entries));
        List addresses = resolver.addresses("localhost", ResolvedAddressTypes.IPV4_PREFERRED);
        Assertions.assertNotNull((Object)addresses);
        Assertions.assertEquals((int)2, (int)addresses.size());
        MatcherAssert.assertThat((String)"Should pick an IPv4 address", addresses.get(0), (Matcher)Matchers.instanceOf(Inet4Address.class));
        MatcherAssert.assertThat((String)"Should pick an IPv6 address", addresses.get(1), (Matcher)Matchers.instanceOf(Inet6Address.class));
    }

    @Test
    public void shouldPickIpv6FirstWhenBothAreDefinedButIpv6IsPreferred() {
        HashMap<String, List<Inet4Address>> inet4Entries = new HashMap<String, List<Inet4Address>>();
        HashMap<String, List<Inet6Address>> inet6Entries = new HashMap<String, List<Inet6Address>>();
        inet4Entries.put("localhost", Collections.singletonList(NetUtil.LOCALHOST4));
        inet6Entries.put("localhost", Collections.singletonList(NetUtil.LOCALHOST6));
        DefaultHostsFileEntriesResolver resolver = new DefaultHostsFileEntriesResolver(new HostsFileEntriesProvider(inet4Entries, inet6Entries));
        List addresses = resolver.addresses("localhost", ResolvedAddressTypes.IPV6_PREFERRED);
        Assertions.assertNotNull((Object)addresses);
        Assertions.assertEquals((int)2, (int)addresses.size());
        MatcherAssert.assertThat((String)"Should pick an IPv6 address", addresses.get(0), (Matcher)Matchers.instanceOf(Inet6Address.class));
        MatcherAssert.assertThat((String)"Should pick an IPv4 address", addresses.get(1), (Matcher)Matchers.instanceOf(Inet4Address.class));
    }
}

