/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver;

import io.netty.resolver.HostsFileEntriesProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

class HostsFileEntriesProviderTest {
    HostsFileEntriesProviderTest() {
    }

    @Test
    void testParse() throws IOException {
        String hostsString = "127.0.0.1 host1" + "\n" + "::1 host1" + "\n" + "\n" + "192.168.0.1\thost2" + "\n" + "#comment" + "\n" + " #comment  " + "\n" + "192.168.0.2  host3  #comment" + "\n" + "192.168.0.3  host4  host5 host6" + "\n" + "192.168.0.4  host4" + "\n" + "192.168.0.5  HOST7" + "\n" + "192.168.0.6  host7" + "\n";
        HostsFileEntriesProvider entries = HostsFileEntriesProvider.parser().parse((Reader)new BufferedReader(new StringReader(hostsString)));
        Map inet4Entries = entries.ipv4Entries();
        Map inet6Entries = entries.ipv6Entries();
        Assertions.assertEquals((int)7, (int)inet4Entries.size(), (String)"Expected 7 IPv4 entries");
        Assertions.assertEquals((int)1, (int)inet6Entries.size(), (String)"Expected 1 IPv6 entries");
        Assertions.assertEquals((int)1, (int)((List)inet4Entries.get("host1")).size());
        Assertions.assertEquals((Object)"127.0.0.1", (Object)((InetAddress)((List)inet4Entries.get("host1")).get(0)).getHostAddress());
        Assertions.assertEquals((int)1, (int)((List)inet4Entries.get("host2")).size());
        Assertions.assertEquals((Object)"192.168.0.1", (Object)((InetAddress)((List)inet4Entries.get("host2")).get(0)).getHostAddress());
        Assertions.assertEquals((int)1, (int)((List)inet4Entries.get("host3")).size());
        Assertions.assertEquals((Object)"192.168.0.2", (Object)((InetAddress)((List)inet4Entries.get("host3")).get(0)).getHostAddress());
        Assertions.assertEquals((int)2, (int)((List)inet4Entries.get("host4")).size());
        Assertions.assertEquals((Object)"192.168.0.3", (Object)((InetAddress)((List)inet4Entries.get("host4")).get(0)).getHostAddress());
        Assertions.assertEquals((Object)"192.168.0.4", (Object)((InetAddress)((List)inet4Entries.get("host4")).get(1)).getHostAddress());
        Assertions.assertEquals((int)1, (int)((List)inet4Entries.get("host5")).size());
        Assertions.assertEquals((Object)"192.168.0.3", (Object)((InetAddress)((List)inet4Entries.get("host5")).get(0)).getHostAddress());
        Assertions.assertEquals((int)1, (int)((List)inet4Entries.get("host6")).size());
        Assertions.assertEquals((Object)"192.168.0.3", (Object)((InetAddress)((List)inet4Entries.get("host6")).get(0)).getHostAddress());
        Assertions.assertNotNull(inet4Entries.get("host7"), (String)"Uppercase host doesn't resolve");
        Assertions.assertEquals((int)2, (int)((List)inet4Entries.get("host7")).size());
        Assertions.assertEquals((Object)"192.168.0.5", (Object)((InetAddress)((List)inet4Entries.get("host7")).get(0)).getHostAddress());
        Assertions.assertEquals((Object)"192.168.0.6", (Object)((InetAddress)((List)inet4Entries.get("host7")).get(1)).getHostAddress());
        Assertions.assertEquals((int)1, (int)((List)inet6Entries.get("host1")).size());
        Assertions.assertEquals((Object)"0:0:0:0:0:0:0:1", (Object)((InetAddress)((List)inet6Entries.get("host1")).get(0)).getHostAddress());
    }

    @Test
    void testCharsetInputValidation() {
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() throws IOException {
                HostsFileEntriesProvider.parser().parse((Charset[])null);
            }
        });
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() throws IOException {
                HostsFileEntriesProvider.parser().parse(new File(""), (Charset[])null);
            }
        });
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() {
                HostsFileEntriesProvider.parser().parseSilently((Charset[])null);
            }
        });
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() {
                HostsFileEntriesProvider.parser().parseSilently(new File(""), (Charset[])null);
            }
        });
    }

    @Test
    void testFileInputValidation() {
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() throws IOException {
                HostsFileEntriesProvider.parser().parse((File)null, new Charset[0]);
            }
        });
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() {
                HostsFileEntriesProvider.parser().parseSilently((File)null, new Charset[0]);
            }
        });
    }

    @Test
    void testReaderInputValidation() {
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() throws IOException {
                HostsFileEntriesProvider.parser().parse((Reader)null);
            }
        });
    }
}

