/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jni;

public final class SessionTicketKey {
    public static final int NAME_SIZE = 16;
    public static final int HMAC_KEY_SIZE = 16;
    public static final int AES_KEY_SIZE = 16;
    public static final int TICKET_KEY_SIZE = 48;
    private final byte[] name;
    private final byte[] hmacKey;
    private final byte[] aesKey;

    public SessionTicketKey(byte[] name, byte[] hmacKey, byte[] aesKey) {
        if (name == null || name.length != 16) {
            throw new IllegalArgumentException("Length of name should be 16");
        }
        if (hmacKey == null || hmacKey.length != 16) {
            throw new IllegalArgumentException("Length of hmacKey should be 16");
        }
        if (aesKey == null || aesKey.length != 16) {
            throw new IllegalArgumentException("Length of aesKey should be 16");
        }
        this.name = name;
        this.hmacKey = hmacKey;
        this.aesKey = aesKey;
    }

    public byte[] getName() {
        return this.name;
    }

    public byte[] getHmacKey() {
        return this.hmacKey;
    }

    public byte[] getAesKey() {
        return this.aesKey;
    }
}

