/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import io.netty.testsuite.util.TestUtils;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class SocketGatheringWriteTest
extends AbstractSocketTest {
    @Rule
    public final Timeout globalTimeout = new Timeout(60000);
    private static final Random random = new Random();
    static final byte[] data = new byte[0x100000];

    @AfterClass
    public static void compressHeapDumps() throws Exception {
        TestUtils.compressHeapDumps();
    }

    @Test
    public void testGatheringWrite() throws Throwable {
        this.run();
    }

    public void testGatheringWrite(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        this.testGatheringWrite0(sb, cb, data, false, true);
    }

    @Test
    public void testGatheringWriteNotAutoRead() throws Throwable {
        this.run();
    }

    public void testGatheringWriteNotAutoRead(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        this.testGatheringWrite0(sb, cb, data, false, false);
    }

    @Test
    public void testGatheringWriteWithComposite() throws Throwable {
        this.run();
    }

    public void testGatheringWriteWithCompositeNotAutoRead(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        this.testGatheringWrite0(sb, cb, data, true, false);
    }

    @Test
    public void testGatheringWriteWithCompositeNotAutoRead() throws Throwable {
        this.run();
    }

    public void testGatheringWriteWithComposite(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        this.testGatheringWrite0(sb, cb, data, true, true);
    }

    @Test
    public void testGatheringWriteBig() throws Throwable {
        this.run();
    }

    public void testGatheringWriteBig(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        byte[] bigData = new byte[0x3200000];
        random.nextBytes(bigData);
        this.testGatheringWrite0(sb, cb, bigData, false, true);
    }

    private void testGatheringWrite0(ServerBootstrap sb, Bootstrap cb, byte[] data, boolean composite, boolean autoRead) throws Throwable {
        int length;
        TestHandler sh = new TestHandler(autoRead);
        TestHandler ch = new TestHandler(autoRead);
        cb.handler((ChannelHandler)ch);
        sb.childHandler((ChannelHandler)sh);
        Channel sc = sb.bind().sync().channel();
        Channel cc = cb.connect().sync().channel();
        for (int i = 0; i < data.length; i += length) {
            length = Math.min(random.nextInt(8192), data.length - i);
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])data, (int)i, (int)length);
            if (composite && i % 2 == 0) {
                int split = buf.readableBytes() / 2;
                int size = buf.readableBytes() - split;
                int oldIndex = buf.writerIndex();
                buf.writerIndex(split);
                ByteBuf buf2 = Unpooled.buffer((int)size).writeBytes(buf, split, oldIndex - split);
                CompositeByteBuf comp = Unpooled.compositeBuffer();
                comp.addComponent(buf).addComponent(buf2).writerIndex(length);
                cc.write((Object)comp);
                continue;
            }
            cc.write((Object)buf);
        }
        ChannelFuture cf = cc.writeAndFlush((Object)Unpooled.EMPTY_BUFFER);
        Assert.assertNotEquals((Object)cc.voidPromise(), (Object)cf);
        try {
            Assert.assertTrue((boolean)cf.await(30000L));
            cf.sync();
        }
        catch (Throwable t) {
            TestUtils.dump(StringUtil.simpleClassName((Object)this));
            throw t;
        }
        while (sh.counter < data.length && sh.exception.get() == null && ch.exception.get() == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {}
        }
        sh.channel.close().sync();
        ch.channel.close().sync();
        sc.close().sync();
        if (sh.exception.get() != null && !(sh.exception.get() instanceof IOException)) {
            throw sh.exception.get();
        }
        if (sh.exception.get() != null) {
            throw sh.exception.get();
        }
        if (ch.exception.get() != null && !(ch.exception.get() instanceof IOException)) {
            throw ch.exception.get();
        }
        if (ch.exception.get() != null) {
            throw ch.exception.get();
        }
        Assert.assertEquals((long)0L, (long)ch.counter);
        Assert.assertEquals((Object)Unpooled.wrappedBuffer((byte[])data), (Object)sh.received);
    }

    static {
        random.nextBytes(data);
    }

    private static class TestHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        private final boolean autoRead;
        volatile Channel channel;
        final AtomicReference<Throwable> exception = new AtomicReference();
        volatile int counter;
        final ByteBuf received = Unpooled.buffer();

        TestHandler(boolean autoRead) {
            this.autoRead = autoRead;
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.channel = ctx.channel();
        }

        public void channelRead0(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
            this.counter += in.readableBytes();
            this.received.writeBytes(in);
        }

        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            if (!this.autoRead) {
                ctx.read();
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (this.exception.compareAndSet(null, cause)) {
                ctx.close();
            }
        }
    }
}

