/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.LineBasedFrameDecoder;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.JdkSslClientContext;
import io.netty.handler.ssl.JdkSslServerContext;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslClientContext;
import io.netty.handler.ssl.OpenSslServerContext;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLEngine;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SocketStartTlsTest
extends AbstractSocketTest {
    private static final InternalLogger logger;
    private static final LogLevel LOG_LEVEL;
    private static final File CERT_FILE;
    private static final File KEY_FILE;
    private static EventExecutorGroup executor;
    private final SslContext serverCtx;
    private final SslContext clientCtx;

    @Parameterized.Parameters(name="{index}: serverEngine = {0}, clientEngine = {1}")
    public static Collection<Object[]> data() throws Exception {
        ArrayList<Object> serverContexts = new ArrayList<Object>();
        serverContexts.add(new JdkSslServerContext(CERT_FILE, KEY_FILE));
        ArrayList<Object> clientContexts = new ArrayList<Object>();
        clientContexts.add(new JdkSslClientContext(CERT_FILE));
        boolean hasOpenSsl = OpenSsl.isAvailable();
        if (hasOpenSsl) {
            serverContexts.add(new OpenSslServerContext(CERT_FILE, KEY_FILE));
            clientContexts.add(new OpenSslClientContext(CERT_FILE));
        } else {
            logger.warn("OpenSSL is unavailable and thus will not be tested.", OpenSsl.unavailabilityCause());
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (SslContext sslContext : serverContexts) {
            for (SslContext sslContext2 : clientContexts) {
                params.add(new Object[]{sslContext, sslContext2});
            }
        }
        return params;
    }

    @BeforeClass
    public static void createExecutor() {
        executor = new DefaultEventExecutorGroup(2);
    }

    @AfterClass
    public static void shutdownExecutor() throws Exception {
        executor.shutdownGracefully().sync();
    }

    public SocketStartTlsTest(SslContext serverCtx, SslContext clientCtx) {
        this.serverCtx = serverCtx;
        this.clientCtx = clientCtx;
    }

    @Test(timeout=30000L)
    public void testStartTls() throws Throwable {
        this.run();
    }

    public void testStartTls(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        this.testStartTls(sb, cb, true);
    }

    @Test(timeout=30000L)
    public void testStartTlsNotAutoRead() throws Throwable {
        this.run();
    }

    public void testStartTlsNotAutoRead(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        this.testStartTls(sb, cb, false);
    }

    private void testStartTls(ServerBootstrap sb, Bootstrap cb, boolean autoRead) throws Throwable {
        final EventExecutorGroup executor = SocketStartTlsTest.executor;
        SSLEngine sse = this.serverCtx.newEngine((ByteBufAllocator)PooledByteBufAllocator.DEFAULT);
        SSLEngine cse = this.clientCtx.newEngine((ByteBufAllocator)PooledByteBufAllocator.DEFAULT);
        final StartTlsServerHandler sh = new StartTlsServerHandler(sse, autoRead);
        final StartTlsClientHandler ch = new StartTlsClientHandler(cse, autoRead);
        sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            public void initChannel(Channel sch) throws Exception {
                ChannelPipeline p = sch.pipeline();
                p.addLast("logger", (ChannelHandler)new LoggingHandler(LOG_LEVEL));
                p.addLast(new ChannelHandler[]{new LineBasedFrameDecoder(64), new StringDecoder(), new StringEncoder()});
                p.addLast(executor, new ChannelHandler[]{sh});
            }
        });
        cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            public void initChannel(Channel sch) throws Exception {
                ChannelPipeline p = sch.pipeline();
                p.addLast("logger", (ChannelHandler)new LoggingHandler(LOG_LEVEL));
                p.addLast(new ChannelHandler[]{new LineBasedFrameDecoder(64), new StringDecoder(), new StringEncoder()});
                p.addLast(executor, new ChannelHandler[]{ch});
            }
        });
        Channel sc = sb.bind().sync().channel();
        Channel cc = cb.connect().sync().channel();
        while (cc.isActive() && sh.exception.get() == null && ch.exception.get() == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {}
        }
        while (sh.channel.isActive() && sh.exception.get() == null && ch.exception.get() == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {}
        }
        sh.channel.close().awaitUninterruptibly();
        cc.close().awaitUninterruptibly();
        sc.close().awaitUninterruptibly();
        if (sh.exception.get() != null && !(sh.exception.get() instanceof IOException)) {
            throw sh.exception.get();
        }
        if (ch.exception.get() != null && !(ch.exception.get() instanceof IOException)) {
            throw ch.exception.get();
        }
        if (sh.exception.get() != null) {
            throw sh.exception.get();
        }
        if (ch.exception.get() != null) {
            throw ch.exception.get();
        }
    }

    static {
        SelfSignedCertificate ssc;
        logger = InternalLoggerFactory.getInstance(SocketStartTlsTest.class);
        LOG_LEVEL = LogLevel.TRACE;
        try {
            ssc = new SelfSignedCertificate();
        }
        catch (CertificateException e) {
            throw new Error(e);
        }
        CERT_FILE = ssc.certificate();
        KEY_FILE = ssc.privateKey();
    }

    private static class StartTlsServerHandler
    extends SimpleChannelInboundHandler<String> {
        private final SslHandler sslHandler;
        private final boolean autoRead;
        volatile Channel channel;
        final AtomicReference<Throwable> exception = new AtomicReference();

        StartTlsServerHandler(SSLEngine engine, boolean autoRead) {
            engine.setUseClientMode(false);
            this.sslHandler = new SslHandler(engine, true);
            this.autoRead = autoRead;
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.channel = ctx.channel();
        }

        public void channelRead0(ChannelHandlerContext ctx, String msg) throws Exception {
            if ("StartTlsRequest".equals(msg)) {
                ctx.pipeline().addAfter("logger", "ssl", (ChannelHandler)this.sslHandler);
                ctx.writeAndFlush((Object)"StartTlsResponse\n");
                return;
            }
            Assert.assertEquals((Object)"EncryptedRequest", (Object)msg);
            ctx.writeAndFlush((Object)"EncryptedResponse\n");
        }

        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            if (!this.autoRead) {
                ctx.read();
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (logger.isWarnEnabled()) {
                logger.warn("Unexpected exception from the server side", cause);
            }
            this.exception.compareAndSet(null, cause);
            ctx.close();
        }
    }

    private static class StartTlsClientHandler
    extends SimpleChannelInboundHandler<String> {
        private final SslHandler sslHandler;
        private final boolean autoRead;
        private Future<Channel> handshakeFuture;
        final AtomicReference<Throwable> exception = new AtomicReference();

        StartTlsClientHandler(SSLEngine engine, boolean autoRead) {
            engine.setUseClientMode(true);
            this.sslHandler = new SslHandler(engine);
            this.autoRead = autoRead;
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            ctx.writeAndFlush((Object)"StartTlsRequest\n");
        }

        public void channelRead0(ChannelHandlerContext ctx, String msg) throws Exception {
            if ("StartTlsResponse".equals(msg)) {
                ctx.pipeline().addAfter("logger", "ssl", (ChannelHandler)this.sslHandler);
                this.handshakeFuture = this.sslHandler.handshakeFuture();
                ctx.writeAndFlush((Object)"EncryptedRequest\n");
                return;
            }
            Assert.assertEquals((Object)"EncryptedResponse", (Object)msg);
            Assert.assertNotNull(this.handshakeFuture);
            Assert.assertTrue((boolean)this.handshakeFuture.isSuccess());
            ctx.close();
        }

        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            if (!this.autoRead) {
                ctx.read();
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (logger.isWarnEnabled()) {
                logger.warn("Unexpected exception from the client side", cause);
            }
            this.exception.compareAndSet(null, cause);
            ctx.close();
        }
    }
}

