/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;

public class SocketCancelWriteTest
extends AbstractSocketTest {
    @Test(timeout=30000L)
    public void testCancelWrite() throws Throwable {
        this.run();
    }

    public void testCancelWrite(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        TestHandler sh = new TestHandler();
        TestHandler ch = new TestHandler();
        ByteBuf a = Unpooled.buffer().writeByte(97);
        ByteBuf b = Unpooled.buffer().writeByte(98);
        ByteBuf c = Unpooled.buffer().writeByte(99);
        ByteBuf d = Unpooled.buffer().writeByte(100);
        ByteBuf e = Unpooled.buffer().writeByte(101);
        cb.handler((ChannelHandler)ch);
        sb.childHandler((ChannelHandler)sh);
        Channel sc = sb.bind().sync().channel();
        Channel cc = cb.connect(sc.localAddress()).sync().channel();
        ChannelFuture f = cc.write((Object)a);
        Assert.assertTrue((boolean)f.cancel(false));
        cc.writeAndFlush((Object)b);
        cc.write((Object)c);
        ChannelFuture f2 = cc.write((Object)d);
        Assert.assertTrue((boolean)f2.cancel(false));
        cc.writeAndFlush((Object)e);
        while (sh.counter < 3 && sh.exception.get() == null && ch.exception.get() == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        sh.channel.close().sync();
        ch.channel.close().sync();
        sc.close().sync();
        if (sh.exception.get() != null && !(sh.exception.get() instanceof IOException)) {
            throw sh.exception.get();
        }
        if (sh.exception.get() != null) {
            throw sh.exception.get();
        }
        if (ch.exception.get() != null && !(ch.exception.get() instanceof IOException)) {
            throw ch.exception.get();
        }
        if (ch.exception.get() != null) {
            throw ch.exception.get();
        }
        Assert.assertEquals((long)0L, (long)ch.counter);
        Assert.assertEquals((Object)Unpooled.wrappedBuffer((byte[])new byte[]{98, 99, 101}), (Object)sh.received);
    }

    private static class TestHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        volatile Channel channel;
        final AtomicReference<Throwable> exception = new AtomicReference();
        volatile int counter;
        final ByteBuf received = Unpooled.buffer();

        private TestHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.channel = ctx.channel();
        }

        public void channelRead0(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
            this.counter += in.readableBytes();
            this.received.writeBytes(in);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (this.exception.compareAndSet(null, cause)) {
                ctx.close();
            }
        }
    }
}

