/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SocketEchoTest
extends AbstractSocketTest {
    private static final Random random = new Random();
    static final byte[] data = new byte[0x100000];
    private static EventExecutorGroup group;

    @BeforeClass
    public static void createGroup() {
        group = new DefaultEventExecutorGroup(2);
    }

    @AfterClass
    public static void destroyGroup() throws Exception {
        group.shutdownGracefully().sync();
    }

    @Test(timeout=30000L)
    public void testSimpleEcho() throws Throwable {
        this.run();
    }

    public void testSimpleEcho(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        SocketEchoTest.testSimpleEcho0(sb, cb, false, false, true);
    }

    @Test(timeout=30000L)
    public void testSimpleEchoNotAutoRead() throws Throwable {
        this.run();
    }

    public void testSimpleEchoNotAutoRead(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        SocketEchoTest.testSimpleEcho0(sb, cb, false, false, false);
    }

    @Test
    public void testSimpleEchoWithAdditionalExecutor() throws Throwable {
        this.run();
    }

    public void testSimpleEchoWithAdditionalExecutor(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        SocketEchoTest.testSimpleEcho0(sb, cb, true, false, true);
    }

    @Test
    public void testSimpleEchoWithAdditionalExecutorNotAutoRead() throws Throwable {
        this.run();
    }

    public void testSimpleEchoWithAdditionalExecutorNotAutoRead(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        SocketEchoTest.testSimpleEcho0(sb, cb, true, false, false);
    }

    @Test
    public void testSimpleEchoWithVoidPromise() throws Throwable {
        this.run();
    }

    public void testSimpleEchoWithVoidPromise(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        SocketEchoTest.testSimpleEcho0(sb, cb, false, true, true);
    }

    @Test
    public void testSimpleEchoWithVoidPromiseNotAutoRead() throws Throwable {
        this.run();
    }

    public void testSimpleEchoWithVoidPromiseNotAutoRead(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        SocketEchoTest.testSimpleEcho0(sb, cb, false, true, false);
    }

    @Test(timeout=30000L)
    public void testSimpleEchoWithAdditionalExecutorAndVoidPromise() throws Throwable {
        this.run();
    }

    public void testSimpleEchoWithAdditionalExecutorAndVoidPromise(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        SocketEchoTest.testSimpleEcho0(sb, cb, true, true, true);
    }

    private static void testSimpleEcho0(ServerBootstrap sb, Bootstrap cb, boolean additionalExecutor, boolean voidPromise, boolean autoRead) throws Throwable {
        int length;
        final EchoHandler sh = new EchoHandler(autoRead);
        final EchoHandler ch = new EchoHandler(autoRead);
        if (additionalExecutor) {
            sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel c) throws Exception {
                    c.pipeline().addLast(group, new ChannelHandler[]{sh});
                }
            });
            cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel c) throws Exception {
                    c.pipeline().addLast(group, new ChannelHandler[]{ch});
                }
            });
        } else {
            sb.childHandler((ChannelHandler)sh);
            sb.handler((ChannelHandler)new ChannelInboundHandlerAdapter(){

                public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                    cause.printStackTrace();
                }
            });
            cb.handler((ChannelHandler)ch);
        }
        sb.childOption(ChannelOption.AUTO_READ, (Object)autoRead);
        cb.option(ChannelOption.AUTO_READ, (Object)autoRead);
        Channel sc = sb.bind().sync().channel();
        Channel cc = cb.connect(sc.localAddress()).sync().channel();
        for (int i = 0; i < data.length; i += length) {
            length = Math.min(random.nextInt(65536), data.length - i);
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])data, (int)i, (int)length);
            if (voidPromise) {
                Assert.assertEquals((Object)cc.voidPromise(), (Object)cc.writeAndFlush((Object)buf, cc.voidPromise()));
                continue;
            }
            Assert.assertNotEquals((Object)cc.voidPromise(), (Object)cc.writeAndFlush((Object)buf));
        }
        while (ch.counter < data.length && sh.exception.get() == null && ch.exception.get() == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        while (sh.counter < data.length && sh.exception.get() == null && ch.exception.get() == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        sh.channel.close().sync();
        ch.channel.close().sync();
        sc.close().sync();
        if (sh.exception.get() != null && !(sh.exception.get() instanceof IOException)) {
            throw sh.exception.get();
        }
        if (ch.exception.get() != null && !(ch.exception.get() instanceof IOException)) {
            throw ch.exception.get();
        }
        if (sh.exception.get() != null) {
            throw sh.exception.get();
        }
        if (ch.exception.get() != null) {
            throw ch.exception.get();
        }
    }

    static {
        random.nextBytes(data);
    }

    private static class EchoHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        private final boolean autoRead;
        volatile Channel channel;
        final AtomicReference<Throwable> exception = new AtomicReference();
        volatile int counter;

        EchoHandler(boolean autoRead) {
            this.autoRead = autoRead;
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.channel = ctx.channel();
            if (!this.autoRead) {
                ctx.read();
            }
        }

        public void channelRead0(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
            byte[] actual = new byte[in.readableBytes()];
            in.readBytes(actual);
            int lastIdx = this.counter;
            for (int i = 0; i < actual.length; ++i) {
                Assert.assertEquals((long)data[i + lastIdx], (long)actual[i]);
            }
            if (this.channel.parent() != null) {
                this.channel.write((Object)Unpooled.wrappedBuffer((byte[])actual));
            }
            this.counter += actual.length;
        }

        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            try {
                ctx.flush();
            }
            finally {
                if (!this.autoRead) {
                    ctx.read();
                }
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (this.exception.compareAndSet(null, cause)) {
                cause.printStackTrace();
                ctx.close();
            }
        }
    }
}

