/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalServerChannel;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import java.net.SocketAddress;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractSingleThreadEventLoopTest {
    private static final Runnable NOOP = new Runnable(){

        @Override
        public void run() {
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChannelsRegistered() throws Exception {
        EventLoopGroup group = this.newEventLoopGroup();
        SingleThreadEventLoop loop = (SingleThreadEventLoop)group.next();
        try {
            boolean channelCountSupported;
            Channel ch1 = this.newChannel();
            Channel ch2 = this.newChannel();
            int rc = AbstractSingleThreadEventLoopTest.registeredChannels(loop);
            boolean bl = channelCountSupported = rc != -1;
            if (channelCountSupported) {
                Assert.assertEquals((long)0L, (long)AbstractSingleThreadEventLoopTest.registeredChannels(loop));
            }
            Assert.assertTrue((boolean)loop.register(ch1).syncUninterruptibly().isSuccess());
            Assert.assertTrue((boolean)loop.register(ch2).syncUninterruptibly().isSuccess());
            if (channelCountSupported) {
                Assert.assertEquals((long)2L, (long)AbstractSingleThreadEventLoopTest.registeredChannels(loop));
            }
            Assert.assertTrue((boolean)ch1.deregister().syncUninterruptibly().isSuccess());
            if (channelCountSupported) {
                Assert.assertEquals((long)1L, (long)AbstractSingleThreadEventLoopTest.registeredChannels(loop));
            }
        }
        finally {
            group.shutdownGracefully();
        }
    }

    private static int registeredChannels(final SingleThreadEventLoop loop) throws Exception {
        return (Integer)loop.submit((Callable)new Callable<Integer>(){

            @Override
            public Integer call() {
                return loop.registeredChannels();
            }
        }).get(1L, TimeUnit.SECONDS);
    }

    @Test
    public void shutdownBeforeStart() throws Exception {
        EventLoopGroup group = this.newEventLoopGroup();
        Assert.assertFalse((boolean)group.awaitTermination(2L, TimeUnit.MILLISECONDS));
        group.shutdown();
        Assert.assertTrue((boolean)group.awaitTermination(200L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void shutdownGracefullyZeroQuietBeforeStart() throws Exception {
        EventLoopGroup group = this.newEventLoopGroup();
        Assert.assertTrue((boolean)group.shutdownGracefully(0L, 2L, TimeUnit.SECONDS).await(200L));
    }

    @Test(timeout=5000L)
    public void testShutdownGracefullyNoQuietPeriod() throws Exception {
        EventLoopGroup loop = this.newEventLoopGroup();
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)b.group(loop).channel(this.serverChannelClass())).childHandler((ChannelHandler)new ChannelInboundHandlerAdapter());
        ChannelFuture cf = this.serverChannelClass() == LocalServerChannel.class ? b.bind((SocketAddress)new LocalAddress("local")) : b.bind(0);
        cf.sync().channel();
        Future f = loop.shutdownGracefully(0L, 1L, TimeUnit.MINUTES);
        Assert.assertTrue((boolean)loop.awaitTermination(600L, TimeUnit.MILLISECONDS));
        Assert.assertTrue((boolean)f.syncUninterruptibly().isSuccess());
        Assert.assertTrue((boolean)loop.isShutdown());
        Assert.assertTrue((boolean)loop.isTerminated());
    }

    @Test
    public void shutdownGracefullyBeforeStart() throws Exception {
        EventLoopGroup group = this.newEventLoopGroup();
        Assert.assertTrue((boolean)group.shutdownGracefully(200L, 1000L, TimeUnit.MILLISECONDS).await(500L));
    }

    @Test
    public void gracefulShutdownAfterStart() throws Exception {
        EventLoop loop = this.newEventLoopGroup().next();
        final CountDownLatch latch = new CountDownLatch(1);
        loop.execute(new Runnable(){

            @Override
            public void run() {
                latch.countDown();
            }
        });
        latch.await();
        loop.shutdownGracefully(200L, 3000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)loop.awaitTermination(500L, TimeUnit.MILLISECONDS));
        AbstractSingleThreadEventLoopTest.assertRejection((EventExecutor)loop);
    }

    private static void assertRejection(EventExecutor loop) {
        try {
            loop.execute(NOOP);
            Assert.fail((String)"A task must be rejected after shutdown() is called.");
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    protected abstract EventLoopGroup newEventLoopGroup();

    protected abstract Channel newChannel();

    protected abstract Class<? extends ServerChannel> serverChannelClass();
}

