/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.testsuite.transport.socket.AbstractServerSocketTest;
import io.netty.util.internal.SocketUtils;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ServerSocketSuspendTest
extends AbstractServerSocketTest {
    private static final int NUM_CHANNELS = 10;
    private static final long TIMEOUT = 3000000000L;

    @Test
    @Ignore(value="Need to investigate why it fails on osx")
    public void testSuspendAndResumeAccept() throws Throwable {
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSuspendAndResumeAccept(ServerBootstrap sb) throws Throwable {
        Socket s;
        AcceptedChannelCounter counter = new AcceptedChannelCounter(10);
        sb.option(ChannelOption.SO_BACKLOG, (Object)1);
        sb.option(ChannelOption.AUTO_READ, (Object)false);
        sb.childHandler((ChannelHandler)counter);
        Channel sc = sb.bind().sync().channel();
        ArrayList<Socket> sockets = new ArrayList<Socket>();
        try {
            long startTime = System.nanoTime();
            for (int i = 0; i < 10; ++i) {
                s = new Socket();
                SocketUtils.connect((Socket)s, (SocketAddress)sc.localAddress(), (int)10000);
                sockets.add(s);
            }
            sc.config().setAutoRead(true);
            counter.latch.await();
            long endTime = System.nanoTime();
            Assert.assertTrue((endTime - startTime > 3000000000L ? 1 : 0) != 0);
        }
        finally {
            for (Socket s2 : sockets) {
                s2.close();
            }
        }
        Thread.sleep(3000L);
        try {
            long startTime = System.nanoTime();
            for (int i = 0; i < 10; ++i) {
                s = new Socket();
                s.connect(sc.localAddress(), 10000);
                sockets.add(s);
            }
            long endTime = System.nanoTime();
            Assert.assertTrue((endTime - startTime < 3000000000L ? 1 : 0) != 0);
        }
        finally {
            for (Socket s2 : sockets) {
                s2.close();
            }
        }
    }

    @ChannelHandler.Sharable
    private static final class AcceptedChannelCounter
    extends ChannelInboundHandlerAdapter {
        final CountDownLatch latch;

        AcceptedChannelCounter(int nChannels) {
            this.latch = new CountDownLatch(nChannels);
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.latch.countDown();
        }
    }
}

