/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.util.concurrent.LinkedBlockingQueue;
import org.junit.Assert;
import org.junit.Test;

public class SocketConnectTest
extends AbstractSocketTest {
    @Test(timeout=30000L)
    public void testLocalAddressAfterConnect() throws Throwable {
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLocalAddressAfterConnect(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        Channel serverChannel = null;
        Channel clientChannel = null;
        try {
            final Promise localAddressPromise = ImmediateEventExecutor.INSTANCE.newPromise();
            serverChannel = sb.childHandler((ChannelHandler)new ChannelInboundHandlerAdapter(){

                public void channelActive(ChannelHandlerContext ctx) throws Exception {
                    localAddressPromise.setSuccess((Object)((InetSocketAddress)ctx.channel().localAddress()));
                }
            }).bind().syncUninterruptibly().channel();
            clientChannel = ((Bootstrap)cb.handler((ChannelHandler)new ChannelInboundHandlerAdapter())).register().syncUninterruptibly().channel();
            Assert.assertNull((Object)clientChannel.localAddress());
            Assert.assertNull((Object)clientChannel.remoteAddress());
            clientChannel.connect(serverChannel.localAddress()).syncUninterruptibly().channel();
            SocketConnectTest.assertLocalAddress((InetSocketAddress)clientChannel.localAddress());
            Assert.assertNotNull((Object)clientChannel.remoteAddress());
            SocketConnectTest.assertLocalAddress((InetSocketAddress)localAddressPromise.get());
        }
        finally {
            if (clientChannel != null) {
                clientChannel.close().syncUninterruptibly();
            }
            if (serverChannel != null) {
                serverChannel.close().syncUninterruptibly();
            }
        }
    }

    @Test(timeout=3000L)
    public void testChannelEventsFiredWhenClosedDirectly() throws Throwable {
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testChannelEventsFiredWhenClosedDirectly(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        final LinkedBlockingQueue events = new LinkedBlockingQueue();
        Channel sc = null;
        Channel cc = null;
        try {
            sb.childHandler((ChannelHandler)new ChannelInboundHandlerAdapter());
            sc = sb.bind().syncUninterruptibly().channel();
            cb.handler((ChannelHandler)new ChannelInboundHandlerAdapter(){

                public void channelActive(ChannelHandlerContext ctx) throws Exception {
                    events.add(0);
                }

                public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                    events.add(1);
                }
            });
            cc = cb.connect(sc.localAddress()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE).syncUninterruptibly().channel();
            Assert.assertEquals((long)0L, (long)((Integer)events.take()).intValue());
            Assert.assertEquals((long)1L, (long)((Integer)events.take()).intValue());
        }
        finally {
            if (cc != null) {
                cc.close();
            }
            if (sc != null) {
                sc.close();
            }
        }
    }

    private static void assertLocalAddress(InetSocketAddress address) {
        Assert.assertTrue((address.getPort() > 0 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)address.getAddress().isAnyLocalAddress());
    }
}

