/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.util;

import io.netty.util.CharsetUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.reflect.Method;
import java.nio.channels.Channel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import org.junit.rules.TestName;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.XZOutputStream;

public final class TestUtils {
    private static final InternalLogger logger;
    private static final Method hotspotMXBeanDumpHeap;
    private static final Object hotspotMXBean;
    private static final long DUMP_PROGRESS_LOGGING_INTERVAL;

    public static boolean isSctpSupported() {
        String os = System.getProperty("os.name").toLowerCase(Locale.UK);
        if ("unix".equals(os) || "linux".equals(os) || "sun".equals(os) || "solaris".equals(os)) {
            block6: {
                try {
                    Class<?> sctpChannelClass = Class.forName("com.sun.nio.sctp.SctpChannel");
                    Channel channel = (Channel)sctpChannelClass.getMethod("open", new Class[0]).invoke(null, new Object[0]);
                    try {
                        channel.close();
                    }
                    catch (IOException iOException) {}
                }
                catch (UnsupportedOperationException e) {
                    System.out.print("Not supported: " + e.getMessage());
                    return false;
                }
                catch (Throwable t) {
                    if (t instanceof IOException) break block6;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static String testMethodName(TestName testName) {
        String testMethodName = testName.getMethodName();
        if (testMethodName.contains("[")) {
            testMethodName = testMethodName.substring(0, testMethodName.indexOf(91));
        }
        return testMethodName;
    }

    public static void dump(String filenamePrefix) throws IOException {
        ObjectUtil.checkNotNull((Object)filenamePrefix, (String)"filenamePrefix");
        String timestamp = TestUtils.timestamp();
        File heapDumpFile = new File(filenamePrefix + '.' + timestamp + ".hprof");
        if (heapDumpFile.exists() && !heapDumpFile.delete()) {
            throw new IOException("Failed to remove the old heap dump: " + heapDumpFile);
        }
        File threadDumpFile = new File(filenamePrefix + '.' + timestamp + ".threads");
        if (threadDumpFile.exists() && !threadDumpFile.delete()) {
            throw new IOException("Failed to remove the old thread dump: " + threadDumpFile);
        }
        TestUtils.dumpHeap(heapDumpFile);
        TestUtils.dumpThreads(threadDumpFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compressHeapDumps() throws IOException {
        File[] files = new File(System.getProperty("user.dir")).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".hprof");
            }
        });
        if (files == null) {
            logger.warn("failed to find heap dump due to I/O error!");
            return;
        }
        byte[] buf = new byte[65536];
        LZMA2Options options = new LZMA2Options(6);
        for (File file : files) {
            String filename = file.toString();
            String xzFilename = filename + ".xz";
            long fileLength = file.length();
            logger.info("Compressing the heap dump: {}", (Object)xzFilename);
            long lastLogTime = System.nanoTime();
            long counter = 0L;
            FileInputStream in = null;
            OutputStream out = null;
            try {
                int readBytes;
                in = new FileInputStream(filename);
                out = new XZOutputStream((OutputStream)new FileOutputStream(xzFilename), (FilterOptions)options);
                while ((readBytes = ((InputStream)in).read(buf)) >= 0) {
                    if (readBytes == 0) continue;
                    out.write(buf, 0, readBytes);
                    counter += (long)readBytes;
                    long currentTime = System.nanoTime();
                    if (currentTime - lastLogTime <= DUMP_PROGRESS_LOGGING_INTERVAL) continue;
                    logger.info("Compressing the heap dump: {} ({}%)", (Object)xzFilename, (Object)(counter * 100L / fileLength));
                    lastLogTime = currentTime;
                }
                out.close();
                ((InputStream)in).close();
            }
            catch (Throwable t) {
                logger.warn("Failed to compress the heap dump: {}", (Object)xzFilename, (Object)t);
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException readBytes) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException readBytes) {}
                }
            }
            if (file.delete()) continue;
            logger.warn("Failed to delete the uncompressed heap dump: {}", (Object)filename);
        }
    }

    private static String timestamp() {
        return new SimpleDateFormat("HHmmss.SSS").format(new Date());
    }

    private static void dumpHeap(File file) {
        if (hotspotMXBean == null) {
            logger.warn("Can't dump heap: HotSpotDiagnosticMXBean unavailable");
            return;
        }
        String filename = file.toString();
        logger.info("Dumping heap: {}", (Object)filename);
        try {
            hotspotMXBeanDumpHeap.invoke(hotspotMXBean, filename, true);
        }
        catch (Exception e) {
            logger.warn("Failed to dump heap: {}", (Object)filename, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpThreads(File file) {
        String filename = file.toString();
        OutputStream out = null;
        try {
            logger.info("Dumping threads: {}", (Object)filename);
            StringBuilder buf = new StringBuilder(8192);
            try {
                for (ThreadInfo info : ManagementFactory.getThreadMXBean().dumpAllThreads(true, true)) {
                    buf.append(info);
                }
                buf.append('\n');
            }
            catch (UnsupportedOperationException ignored) {
                logger.warn("Can't dump threads: ThreadMXBean.dumpAllThreads() unsupported");
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return;
            }
            out = new FileOutputStream(file);
            out.write(buf.toString().getBytes(CharsetUtil.UTF_8));
        }
        catch (Exception e) {
            logger.warn("Failed to dump threads: {}", (Object)filename, (Object)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private TestUtils() {
    }

    static {
        Method mxBeanDumpHeap;
        Object mxBean;
        logger = InternalLoggerFactory.getInstance(TestUtils.class);
        DUMP_PROGRESS_LOGGING_INTERVAL = TimeUnit.SECONDS.toNanos(5L);
        try {
            Class<?> clazz = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            mxBean = ManagementFactory.newPlatformMXBeanProxy(server, "com.sun.management:type=HotSpotDiagnostic", clazz);
            mxBeanDumpHeap = clazz.getMethod("dumpHeap", String.class, Boolean.TYPE);
        }
        catch (Exception ignored) {
            mxBean = null;
            mxBeanDumpHeap = null;
        }
        hotspotMXBean = mxBean;
        hotspotMXBeanDumpHeap = mxBeanDumpHeap;
    }
}

