/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.socket.SocketChannel;
import io.netty.testsuite.transport.AbstractComboTestsuiteTest;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import org.opentest4j.TestAbortedException;

public class SocketConnectTest
extends AbstractSocketTest {
    @Test
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    public void testLocalAddressAfterConnect(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<ServerBootstrap, Bootstrap>(){

            @Override
            public void run(ServerBootstrap serverBootstrap, Bootstrap bootstrap) throws Throwable {
                SocketConnectTest.this.testLocalAddressAfterConnect(serverBootstrap, bootstrap);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLocalAddressAfterConnect(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        Channel serverChannel = null;
        Channel clientChannel = null;
        try {
            final Promise localAddressPromise = ImmediateEventExecutor.INSTANCE.newPromise();
            serverChannel = sb.childHandler((ChannelHandler)new ChannelInboundHandlerAdapter(){

                public void channelActive(ChannelHandlerContext ctx) throws Exception {
                    localAddressPromise.setSuccess((Object)((InetSocketAddress)ctx.channel().localAddress()));
                }
            }).bind().syncUninterruptibly().channel();
            clientChannel = ((Bootstrap)cb.handler((ChannelHandler)new ChannelInboundHandlerAdapter())).register().syncUninterruptibly().channel();
            Assertions.assertNull((Object)clientChannel.localAddress());
            Assertions.assertNull((Object)clientChannel.remoteAddress());
            clientChannel.connect(serverChannel.localAddress()).syncUninterruptibly().channel();
            SocketConnectTest.assertLocalAddress((InetSocketAddress)clientChannel.localAddress());
            Assertions.assertNotNull((Object)clientChannel.remoteAddress());
            SocketConnectTest.assertLocalAddress((InetSocketAddress)localAddressPromise.get());
        }
        finally {
            if (clientChannel != null) {
                clientChannel.close().syncUninterruptibly();
            }
            if (serverChannel != null) {
                serverChannel.close().syncUninterruptibly();
            }
        }
    }

    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testChannelEventsFiredWhenClosedDirectly(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<ServerBootstrap, Bootstrap>(){

            @Override
            public void run(ServerBootstrap serverBootstrap, Bootstrap bootstrap) throws Throwable {
                SocketConnectTest.this.testChannelEventsFiredWhenClosedDirectly(serverBootstrap, bootstrap);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testChannelEventsFiredWhenClosedDirectly(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        final LinkedBlockingQueue events = new LinkedBlockingQueue();
        Channel sc = null;
        Channel cc = null;
        try {
            sb.childHandler((ChannelHandler)new ChannelInboundHandlerAdapter());
            sc = sb.bind().syncUninterruptibly().channel();
            cb.handler((ChannelHandler)new ChannelInboundHandlerAdapter(){

                public void channelActive(ChannelHandlerContext ctx) throws Exception {
                    events.add(0);
                }

                public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                    events.add(1);
                }
            });
            cc = cb.connect(sc.localAddress()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE).syncUninterruptibly().channel();
            Assertions.assertEquals((int)0, (int)((Integer)events.take()));
            Assertions.assertEquals((int)1, (int)((Integer)events.take()));
        }
        finally {
            if (cc != null) {
                cc.close();
            }
            if (sc != null) {
                sc.close();
            }
        }
    }

    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testWriteWithFastOpenBeforeConnect(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<ServerBootstrap, Bootstrap>(){

            @Override
            public void run(ServerBootstrap serverBootstrap, Bootstrap bootstrap) throws Throwable {
                SocketConnectTest.this.testWriteWithFastOpenBeforeConnect(serverBootstrap, bootstrap);
            }
        });
    }

    public void testWriteWithFastOpenBeforeConnect(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        this.enableTcpFastOpen(sb, cb);
        sb.childOption(ChannelOption.AUTO_READ, (Object)true);
        cb.option(ChannelOption.AUTO_READ, (Object)true);
        sb.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new EchoServerHandler()});
            }
        });
        Channel sc = sb.bind().sync().channel();
        SocketConnectTest.connectAndVerifyDataTransfer(cb, sc);
        SocketConnectTest.connectAndVerifyDataTransfer(cb, sc);
    }

    private static void connectAndVerifyDataTransfer(Bootstrap cb, Channel sc) throws InterruptedException {
        BufferingClientHandler handler = new BufferingClientHandler();
        cb.handler((ChannelHandler)handler);
        ChannelFuture register = cb.register();
        Channel channel = register.sync().channel();
        ChannelFuture write = channel.write((Object)ByteBufUtil.writeAscii((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (CharSequence)"[fastopen]"));
        SocketAddress remoteAddress = sc.localAddress();
        ChannelFuture connectFuture = channel.connect(remoteAddress);
        Channel cc = connectFuture.sync().channel();
        cc.writeAndFlush((Object)ByteBufUtil.writeAscii((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (CharSequence)"[normal data]")).sync();
        write.sync();
        String expectedString = "[fastopen][normal data]";
        String result = handler.collectBuffer(expectedString.getBytes(CharsetUtil.US_ASCII).length);
        cc.disconnect().sync();
        Assertions.assertEquals((Object)expectedString, (Object)result);
    }

    protected void enableTcpFastOpen(ServerBootstrap sb, Bootstrap cb) {
        throw new TestAbortedException("Support for testing TCP_FASTOPEN not enabled for " + StringUtil.simpleClassName((Object)this));
    }

    private static void assertLocalAddress(InetSocketAddress address) {
        Assertions.assertTrue((address.getPort() > 0 ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)address.getAddress().isAnyLocalAddress());
    }

    private static final class EchoServerHandler
    extends ChannelInboundHandlerAdapter {
        private EchoServerHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (!(msg instanceof ByteBuf)) {
                throw new IllegalArgumentException("Unexpected message type: " + msg);
            }
            ByteBuf buffer = ctx.alloc().buffer();
            ByteBuf buf = (ByteBuf)msg;
            buffer.writeBytes(buf);
            buf.release();
            ctx.channel().writeAndFlush((Object)buffer);
        }
    }

    private static class BufferingClientHandler
    extends ChannelInboundHandlerAdapter {
        private final Semaphore semaphore = new Semaphore(0);
        private final ByteArrayOutputStream streamBuffer = new ByteArrayOutputStream();

        private BufferingClientHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (!(msg instanceof ByteBuf)) {
                throw new IllegalArgumentException("Unexpected message type: " + msg);
            }
            ByteBuf buf = (ByteBuf)msg;
            int readableBytes = buf.readableBytes();
            buf.readBytes((OutputStream)this.streamBuffer, readableBytes);
            this.semaphore.release(readableBytes);
            buf.release();
        }

        String collectBuffer(int expectedBytes) throws InterruptedException {
            this.semaphore.acquire(expectedBytes);
            byte[] bytes = this.streamBuffer.toByteArray();
            this.streamBuffer.reset();
            return new String(bytes, CharsetUtil.US_ASCII);
        }
    }
}

