/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.testsuite.transport.AbstractComboTestsuiteTest;
import io.netty.testsuite.transport.socket.AbstractDatagramTest;
import io.netty.util.NetUtil;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.NotYetConnectedException;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public abstract class DatagramUnicastTest
extends AbstractDatagramTest {
    private static final byte[] BYTES = new byte[]{0, 1, 2, 3};

    @Test
    public void testSimpleSendDirectByteBuf(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<Bootstrap, Bootstrap>(){

            @Override
            public void run(Bootstrap bootstrap, Bootstrap bootstrap2) throws Throwable {
                DatagramUnicastTest.this.testSimpleSendDirectByteBuf(bootstrap, bootstrap2);
            }
        });
    }

    public void testSimpleSendDirectByteBuf(Bootstrap sb, Bootstrap cb) throws Throwable {
        this.testSimpleSend(sb, cb, Unpooled.directBuffer().writeBytes(BYTES), true, BYTES, 1);
        this.testSimpleSend(sb, cb, Unpooled.directBuffer().writeBytes(BYTES), true, BYTES, 4);
    }

    @Test
    public void testSimpleSendHeapByteBuf(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<Bootstrap, Bootstrap>(){

            @Override
            public void run(Bootstrap bootstrap, Bootstrap bootstrap2) throws Throwable {
                DatagramUnicastTest.this.testSimpleSendHeapByteBuf(bootstrap, bootstrap2);
            }
        });
    }

    public void testSimpleSendHeapByteBuf(Bootstrap sb, Bootstrap cb) throws Throwable {
        this.testSimpleSend(sb, cb, Unpooled.buffer().writeBytes(BYTES), true, BYTES, 1);
        this.testSimpleSend(sb, cb, Unpooled.buffer().writeBytes(BYTES), true, BYTES, 4);
    }

    @Test
    public void testSimpleSendCompositeDirectByteBuf(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<Bootstrap, Bootstrap>(){

            @Override
            public void run(Bootstrap bootstrap, Bootstrap bootstrap2) throws Throwable {
                DatagramUnicastTest.this.testSimpleSendCompositeDirectByteBuf(bootstrap, bootstrap2);
            }
        });
    }

    public void testSimpleSendCompositeDirectByteBuf(Bootstrap sb, Bootstrap cb) throws Throwable {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        buf.addComponent(true, Unpooled.directBuffer().writeBytes(BYTES, 0, 2));
        buf.addComponent(true, Unpooled.directBuffer().writeBytes(BYTES, 2, 2));
        this.testSimpleSend(sb, cb, (ByteBuf)buf, true, BYTES, 1);
        CompositeByteBuf buf2 = Unpooled.compositeBuffer();
        buf2.addComponent(true, Unpooled.directBuffer().writeBytes(BYTES, 0, 2));
        buf2.addComponent(true, Unpooled.directBuffer().writeBytes(BYTES, 2, 2));
        this.testSimpleSend(sb, cb, (ByteBuf)buf2, true, BYTES, 4);
    }

    @Test
    public void testSimpleSendCompositeHeapByteBuf(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<Bootstrap, Bootstrap>(){

            @Override
            public void run(Bootstrap bootstrap, Bootstrap bootstrap2) throws Throwable {
                DatagramUnicastTest.this.testSimpleSendCompositeHeapByteBuf(bootstrap, bootstrap2);
            }
        });
    }

    public void testSimpleSendCompositeHeapByteBuf(Bootstrap sb, Bootstrap cb) throws Throwable {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        buf.addComponent(true, Unpooled.buffer().writeBytes(BYTES, 0, 2));
        buf.addComponent(true, Unpooled.buffer().writeBytes(BYTES, 2, 2));
        this.testSimpleSend(sb, cb, (ByteBuf)buf, true, BYTES, 1);
        CompositeByteBuf buf2 = Unpooled.compositeBuffer();
        buf2.addComponent(true, Unpooled.buffer().writeBytes(BYTES, 0, 2));
        buf2.addComponent(true, Unpooled.buffer().writeBytes(BYTES, 2, 2));
        this.testSimpleSend(sb, cb, (ByteBuf)buf2, true, BYTES, 4);
    }

    @Test
    public void testSimpleSendCompositeMixedByteBuf(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<Bootstrap, Bootstrap>(){

            @Override
            public void run(Bootstrap bootstrap, Bootstrap bootstrap2) throws Throwable {
                DatagramUnicastTest.this.testSimpleSendCompositeMixedByteBuf(bootstrap, bootstrap2);
            }
        });
    }

    public void testSimpleSendCompositeMixedByteBuf(Bootstrap sb, Bootstrap cb) throws Throwable {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        buf.addComponent(true, Unpooled.directBuffer().writeBytes(BYTES, 0, 2));
        buf.addComponent(true, Unpooled.buffer().writeBytes(BYTES, 2, 2));
        this.testSimpleSend(sb, cb, (ByteBuf)buf, true, BYTES, 1);
        CompositeByteBuf buf2 = Unpooled.compositeBuffer();
        buf2.addComponent(true, Unpooled.directBuffer().writeBytes(BYTES, 0, 2));
        buf2.addComponent(true, Unpooled.buffer().writeBytes(BYTES, 2, 2));
        this.testSimpleSend(sb, cb, (ByteBuf)buf2, true, BYTES, 4);
    }

    @Test
    public void testSimpleSendWithoutBind(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<Bootstrap, Bootstrap>(){

            @Override
            public void run(Bootstrap bootstrap, Bootstrap bootstrap2) throws Throwable {
                DatagramUnicastTest.this.testSimpleSendWithoutBind(bootstrap, bootstrap2);
            }
        });
    }

    public void testSimpleSendWithoutBind(Bootstrap sb, Bootstrap cb) throws Throwable {
        this.testSimpleSend(sb, cb, Unpooled.directBuffer().writeBytes(BYTES), false, BYTES, 1);
        this.testSimpleSend(sb, cb, Unpooled.directBuffer().writeBytes(BYTES), false, BYTES, 4);
    }

    private void testSimpleSend(Bootstrap sb, Bootstrap cb, ByteBuf buf, boolean bindClient, byte[] bytes, int count) throws Throwable {
        for (WrapType type : WrapType.values()) {
            this.testSimpleSend0(sb, cb, buf.retain(), bindClient, bytes, count, type);
        }
        Assertions.assertTrue((boolean)buf.release());
    }

    @Test
    public void testSimpleSendWithConnect(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<Bootstrap, Bootstrap>(){

            @Override
            public void run(Bootstrap bootstrap, Bootstrap bootstrap2) throws Throwable {
                DatagramUnicastTest.this.testSimpleSendWithConnect(bootstrap, bootstrap2);
            }
        });
    }

    public void testSimpleSendWithConnect(Bootstrap sb, Bootstrap cb) throws Throwable {
        this.testSimpleSendWithConnect(sb, cb, Unpooled.directBuffer().writeBytes(BYTES), BYTES, 1);
        this.testSimpleSendWithConnect(sb, cb, Unpooled.directBuffer().writeBytes(BYTES), BYTES, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSimpleSend0(Bootstrap sb, Bootstrap cb, ByteBuf buf, boolean bindClient, byte[] bytes, int count, WrapType wrapType) throws Throwable {
        Channel sc = null;
        Channel cc = null;
        try {
            SocketAddress sender;
            cb.handler((ChannelHandler)new SimpleChannelInboundHandler<Object>(){

                public void channelRead0(ChannelHandlerContext ctx, Object msgs) {
                }
            });
            if (bindClient) {
                cc = cb.bind(this.newSocketAddress()).sync().channel();
                sender = cc.localAddress();
            } else {
                cb.option(ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION, (Object)true);
                cc = cb.register().sync().channel();
                sender = null;
            }
            CountDownLatch latch = new CountDownLatch(count);
            AtomicReference<Throwable> errorRef = new AtomicReference<Throwable>();
            sc = this.setupServerChannel(sb, bytes, sender, latch, errorRef, false);
            SocketAddress localAddr = sc.localAddress();
            SocketAddress addr = localAddr instanceof InetSocketAddress ? this.sendToAddress((InetSocketAddress)sc.localAddress()) : localAddr;
            ArrayList<ChannelFuture> futures = new ArrayList<ChannelFuture>(count);
            for (int i = 0; i < count; ++i) {
                futures.add(this.write(cc, buf, addr, wrapType));
            }
            cc.flush();
            for (ChannelFuture future : futures) {
                future.sync();
            }
            if (!latch.await(10L, TimeUnit.SECONDS)) {
                Throwable error = errorRef.get();
                if (error != null) {
                    throw error;
                }
                Assertions.fail();
            }
        }
        catch (Throwable throwable) {
            buf.release();
            DatagramUnicastTest.closeChannel(cc);
            DatagramUnicastTest.closeChannel(sc);
            throw throwable;
        }
        buf.release();
        DatagramUnicastTest.closeChannel(cc);
        DatagramUnicastTest.closeChannel(sc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSimpleSendWithConnect(Bootstrap sb, Bootstrap cb, ByteBuf buf, byte[] bytes, int count) throws Throwable {
        try {
            for (WrapType type : WrapType.values()) {
                this.testSimpleSendWithConnect0(sb, cb, buf.retain(), bytes, count, type);
            }
        }
        finally {
            Assertions.assertTrue((boolean)buf.release());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSimpleSendWithConnect0(Bootstrap sb, Bootstrap cb, ByteBuf buf, byte[] bytes, int count, WrapType wrapType) throws Throwable {
        Channel sc = null;
        Channel cc = null;
        try {
            Throwable cause;
            CountDownLatch latch = new CountDownLatch(count);
            AtomicReference<Throwable> errorRef = new AtomicReference<Throwable>();
            CountDownLatch clientLatch = new CountDownLatch(count);
            AtomicReference<Throwable> clientErrorRef = new AtomicReference<Throwable>();
            cc = this.setupClientChannel(cb, bytes, clientLatch, clientErrorRef);
            sc = this.setupServerChannel(sb, bytes, cc.localAddress(), latch, errorRef, true);
            SocketAddress localAddr = sc.localAddress();
            SocketAddress addr = localAddr instanceof InetSocketAddress ? this.sendToAddress((InetSocketAddress)sc.localAddress()) : localAddr;
            cc.connect(addr).syncUninterruptibly();
            ArrayList<ChannelFuture> futures = new ArrayList<ChannelFuture>();
            for (int i = 0; i < count; ++i) {
                futures.add(DatagramUnicastTest.write(cc, buf, wrapType));
            }
            cc.flush();
            for (ChannelFuture future : futures) {
                future.sync();
            }
            if (!latch.await(10L, TimeUnit.SECONDS)) {
                cause = errorRef.get();
                if (cause != null) {
                    throw cause;
                }
                Assertions.fail();
            }
            if (!clientLatch.await(10L, TimeUnit.SECONDS)) {
                cause = clientErrorRef.get();
                if (cause != null) {
                    throw cause;
                }
                Assertions.fail();
            }
            Assertions.assertTrue((boolean)this.isConnected(cc));
            Assertions.assertNotNull((Object)cc.localAddress());
            Assertions.assertNotNull((Object)cc.remoteAddress());
            if (this.supportDisconnect()) {
                cc.disconnect().syncUninterruptibly();
                Assertions.assertFalse((boolean)this.isConnected(cc));
                Assertions.assertNotNull((Object)cc.localAddress());
                Assertions.assertNull((Object)cc.remoteAddress());
                ChannelFuture future = cc.writeAndFlush((Object)buf.retain().duplicate()).awaitUninterruptibly();
                Assertions.assertTrue((boolean)(future.cause() instanceof NotYetConnectedException), (String)("NotYetConnectedException expected, got: " + future.cause()));
            }
        }
        catch (Throwable throwable) {
            buf.release();
            DatagramUnicastTest.closeChannel(cc);
            DatagramUnicastTest.closeChannel(sc);
            throw throwable;
        }
        buf.release();
        DatagramUnicastTest.closeChannel(cc);
        DatagramUnicastTest.closeChannel(sc);
    }

    private static ChannelFuture write(Channel cc, ByteBuf buf, WrapType wrapType) {
        switch (wrapType) {
            case DUP: {
                return cc.write((Object)buf.retainedDuplicate());
            }
            case SLICE: {
                return cc.write((Object)buf.retainedSlice());
            }
            case READ_ONLY: {
                return cc.write((Object)buf.retain().asReadOnly());
            }
            case NONE: {
                return cc.write((Object)buf.retain());
            }
        }
        throw new Error("unknown wrap type: " + (Object)((Object)wrapType));
    }

    protected abstract boolean isConnected(Channel var1);

    protected abstract Channel setupClientChannel(Bootstrap var1, byte[] var2, CountDownLatch var3, AtomicReference<Throwable> var4) throws Throwable;

    protected abstract Channel setupServerChannel(Bootstrap var1, byte[] var2, SocketAddress var3, CountDownLatch var4, AtomicReference<Throwable> var5, boolean var6) throws Throwable;

    protected abstract boolean supportDisconnect();

    protected abstract ChannelFuture write(Channel var1, ByteBuf var2, SocketAddress var3, WrapType var4);

    protected static void closeChannel(Channel channel) throws Exception {
        if (channel != null) {
            channel.close().sync();
        }
    }

    protected InetSocketAddress sendToAddress(InetSocketAddress serverAddress) {
        InetAddress addr = serverAddress.getAddress();
        if (addr.isAnyLocalAddress()) {
            if (addr instanceof Inet6Address) {
                return new InetSocketAddress(NetUtil.LOCALHOST6, serverAddress.getPort());
            }
            return new InetSocketAddress(NetUtil.LOCALHOST4, serverAddress.getPort());
        }
        return serverAddress;
    }

    protected static enum WrapType {
        NONE,
        DUP,
        SLICE,
        READ_ONLY;

    }
}

